/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.management.server.configuration;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.mbeans.MBeanUtils;
import org.mobicents.servlet.management.client.configuration.ConfigurationService;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.CongestionControlPolicy;

public class ConfigurationServiceImpl
extends RemoteServiceServlet
implements ConfigurationService {
    static final long serialVersionUID = 1L;
    private static MBeanServer mserver = MBeanUtils.createServer();

    private ObjectName getApplicationDispatcher() {
        try {
            ObjectName dispatcherQuery = new ObjectName("*:type=SipApplicationDispatcher");
            ObjectInstance dispatcherInstance = mserver.queryMBeans(dispatcherQuery, null).iterator().next();
            ObjectName dispatcherName = dispatcherInstance.getObjectName();
            return dispatcherName;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private ObjectName getSglcMBean() {
        try {
            ObjectName dispatcherQuery = new ObjectName("*:service=SimpleGlobalLoggingConfiguration");
            Iterator<ObjectInstance> objectInstances = mserver.queryMBeans(dispatcherQuery, null).iterator();
            ObjectName sglcName = null;
            if (objectInstances.hasNext()) {
                sglcName = objectInstances.next().getObjectName();
            }
            return sglcName;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String getConcurrencyControlMode() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            ConcurrencyControlMode mode = (ConcurrencyControlMode)mserver.getAttribute(dispatcherName, "concurrencyControlMode");
            return mode.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public String getLoggingMode() {
        try {
            ObjectName sglcName = this.getSglcMBean();
            if (sglcName == null) {
                return null;
            }
            String mode = (String)mserver.invoke(sglcName, "getCurrentProfile", new Object[0], new String[0]);
            return mode.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getQueueSize() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String size = mserver.getAttribute(dispatcherName, "queueSize").toString();
            return Integer.parseInt(size);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getBaseTimerInterval() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String size = mserver.getAttribute(dispatcherName, "baseTimerInterval").toString();
            return Integer.parseInt(size);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getT2Interval() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String size = mserver.getAttribute(dispatcherName, "t2Interval").toString();
            return Integer.parseInt(size);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getT4Interval() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String size = mserver.getAttribute(dispatcherName, "t4Interval").toString();
            return Integer.parseInt(size);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getTimerDInterval() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String size = mserver.getAttribute(dispatcherName, "timerDInterval").toString();
            return Integer.parseInt(size);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setConcurrencyControlMode(String mode) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            mserver.invoke(dispatcherName, "setConcurrencyControlModeByName", new Object[]{mode}, new String[]{"java.lang.String"});
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setLoggingMode(String mode) {
        try {
            ObjectName sglcName = this.getSglcMBean();
            if (sglcName == null) {
                return;
            }
            mserver.invoke(sglcName, "switchLoggingConfiguration", new Object[]{mode}, new String[]{"java.lang.String"});
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public String[] listLoggingProfiles() {
        try {
            ObjectName sglcName = this.getSglcMBean();
            if (sglcName == null) {
                return null;
            }
            Set profiles = (Set)mserver.invoke(sglcName, "listProfiles", new Object[0], new String[0]);
            String[] sglcModes = new String[]{};
            if (profiles != null) {
                Iterator profilesIt = profiles.iterator();
                sglcModes = new String[profiles.size()];
                int i = 0;
                while (profilesIt.hasNext()) {
                    String profile;
                    sglcModes[i] = profile = (String)profilesIt.next();
                    ++i;
                }
            }
            return sglcModes;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setQueueSize(int queueSize) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("queueSize", new Integer(queueSize));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setBaseTimerInterval(int baseTimerInterval) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("baseTimerInterval", new Integer(baseTimerInterval));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setT2Interval(int t2Interval) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("t2Interval", new Integer(t2Interval));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setT4Interval(int t4Interval) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("t4Interval", new Integer(t4Interval));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setTimerDInterval(int timerDInterval) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("timerDInterval", new Integer(timerDInterval));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public String getCongestionControlPolicy() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            CongestionControlPolicy policy = (CongestionControlPolicy)mserver.getAttribute(dispatcherName, "congestionControlPolicy");
            return policy.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getMemoryThreshold() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String memoryThreshold = mserver.getAttribute(dispatcherName, "memoryThreshold").toString();
            return Integer.parseInt(memoryThreshold);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setCongestionControlPolicy(String policy) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            mserver.invoke(dispatcherName, "setCongestionControlPolicyByName", new Object[]{policy}, new String[]{"java.lang.String"});
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setMemoryThreshold(int memoryThreshold) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("memoryThreshold", new Integer(memoryThreshold));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public long getCongestionControlCheckingInterval() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String checkingInterval = mserver.getAttribute(dispatcherName, "congestionControlCheckingInterval").toString();
            return Long.parseLong(checkingInterval);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setCongestionControlCheckingInterval(long interval) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("congestionControlCheckingInterval", new Long(interval));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }
}

