/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.management.server.configuration;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.mbeans.MBeanUtils;
import org.mobicents.servlet.management.client.configuration.ConfigurationService;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.CongestionControlPolicy;

public class ConfigurationServiceImpl
extends RemoteServiceServlet
implements ConfigurationService {
    private static MBeanServer mserver = MBeanUtils.createServer();

    private ObjectName getApplicationDispatcher() {
        try {
            ObjectName dispatcherQuery = new ObjectName("*:type=SipApplicationDispatcher");
            ObjectInstance dispatcherInstance = mserver.queryMBeans(dispatcherQuery, null).iterator().next();
            ObjectName dispatcherName = dispatcherInstance.getObjectName();
            return dispatcherName;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String getConcurrencyControlMode() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            ConcurrencyControlMode mode = (ConcurrencyControlMode)mserver.getAttribute(dispatcherName, "concurrencyControlMode");
            return mode.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getQueueSize() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String size = mserver.getAttribute(dispatcherName, "queueSize").toString();
            return Integer.parseInt(size);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setConcurrencyControlMode(String mode) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            mserver.invoke(dispatcherName, "setConcurrencyControlModeByName", new Object[]{mode}, new String[]{"java.lang.String"});
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setQueueSize(int queueSize) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("queueSize", new Integer(queueSize));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public String getCongestionControlPolicy() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            CongestionControlPolicy policy = (CongestionControlPolicy)mserver.getAttribute(dispatcherName, "congestionControlPolicy");
            return policy.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getMemoryThreshold() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String memoryThreshold = mserver.getAttribute(dispatcherName, "memoryThreshold").toString();
            return Integer.parseInt(memoryThreshold);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setCongestionControlPolicy(String policy) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            mserver.invoke(dispatcherName, "setCongestionControlPolicyByName", new Object[]{policy}, new String[]{"java.lang.String"});
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setMemoryThreshold(int memoryThreshold) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("memoryThreshold", new Integer(memoryThreshold));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public long getCongestionControlCheckingInterval() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String checkingInterval = mserver.getAttribute(dispatcherName, "congestionControlCheckingInterval").toString();
            return Long.parseLong(checkingInterval);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setCongestionControlCheckingInterval(long interval) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("congestionControlCheckingInterval", new Long(interval));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }
}

