/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.management.client.router;

import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.allen_sauer.gwt.dnd.client.drop.IndexedDropController;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.event.ButtonListener;
import org.mobicents.servlet.management.client.dnd.NoInsertAtEndIndexedDropController;
import org.mobicents.servlet.management.client.router.ApplicationRouteNodeEditor;
import org.mobicents.servlet.management.client.router.DARConfigurationService;
import org.mobicents.servlet.management.client.router.DARConfigurationServiceAsync;
import org.mobicents.servlet.management.client.router.DARRoute;

public final class RequestColumnsContainer
extends AbsolutePanel {
    private static final String[] COLUMNS = new String[]{"INVITE", "REGISTER", "SUBSCRIBE", "OPTIONS", "MESSAGE", "NOTIFY", "PUBLISH", "INFO", "UPDATE", "REFER"};
    private static final String CSS_SSM = "ssm";
    private static final String CSS_SSM_COLUMN_COMPOSITE = "ssm-column-composite";
    private static final String CSS_CONTAINER = "ssm-container";
    private static final String CSS_HEADING = "ssm-heading";
    private static final String CSS_WIDGET = "ssm-widget";
    private static final String CSS_TITLE = "ssm-title-background";
    private static final int SPACING = 0;
    private VerticalPanel[] routeColumns;

    public RequestColumnsContainer() {
        this.init();
    }

    private Widget makeTitle(String text) {
        Label title = new Label(text);
        title.setPixelSize(221, 20);
        title.addStyleName(CSS_HEADING);
        return title;
    }

    private Widget buildTitles() {
        HorizontalPanel titles = new HorizontalPanel();
        titles.setStyleName(CSS_TITLE);
        titles.setSpacing(0);
        Label spacerLabel = new Label("");
        spacerLabel.setPixelSize(14, 7);
        titles.add((Widget)spacerLabel);
        for (int col = 0; col < COLUMNS.length; ++col) {
            titles.add(this.makeTitle(COLUMNS[col]));
        }
        return titles;
    }

    private void populateRouterNodes(DARRoute[] routes) {
        RequestColumnsContainer boundaryPanel = this;
        boundaryPanel.add(this.buildTitles());
        boundaryPanel.setSize("1700", "1500");
        this.addStyleName(CSS_SSM);
        this.routeColumns = new VerticalPanel[COLUMNS.length];
        PickupDragController columnDragController = new PickupDragController((AbsolutePanel)boundaryPanel, false);
        columnDragController.setBehaviorMultipleSelection(false);
        PickupDragController widgetDragController = new PickupDragController((AbsolutePanel)boundaryPanel, false);
        widgetDragController.setBehaviorMultipleSelection(false);
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.addStyleName(CSS_CONTAINER);
        horizontalPanel.setSpacing(0);
        boundaryPanel.add((Widget)horizontalPanel);
        IndexedDropController columnDropController = new IndexedDropController((IndexedPanel)horizontalPanel);
        columnDragController.registerDropController((DropController)columnDropController);
        for (int col = 0; col < COLUMNS.length; ++col) {
            VerticalPanel verticalPanel;
            VerticalPanel columnCompositePanel = new VerticalPanel();
            columnCompositePanel.addStyleName(CSS_SSM_COLUMN_COMPOSITE);
            this.routeColumns[col] = verticalPanel = new VerticalPanel();
            verticalPanel.addStyleName(CSS_CONTAINER);
            verticalPanel.setSpacing(0);
            horizontalPanel.add((Widget)columnCompositePanel);
            NoInsertAtEndIndexedDropController widgetDropController = new NoInsertAtEndIndexedDropController((IndexedPanel)verticalPanel);
            widgetDragController.registerDropController((DropController)widgetDropController);
            HTML groupDragHandle = new HTML("<div class='group-drag-handle'/>");
            columnCompositePanel.add((Widget)groupDragHandle);
            columnCompositePanel.add((Widget)verticalPanel);
            columnDragController.makeDraggable((Widget)columnCompositePanel, (Widget)groupDragHandle);
            for (int q = 0; q < routes.length; ++q) {
                if (!COLUMNS[col].equals(routes[q].getRequest())) continue;
                for (int w = 0; w < routes[q].getNodes().length; ++w) {
                    ApplicationRouteNodeEditor widget = new ApplicationRouteNodeEditor(routes[q].getNodes()[w]);
                    verticalPanel.add((Widget)widget);
                    widgetDragController.makeDraggable((Widget)widget, widget.getDragHandle());
                }
            }
            Label spacerLabel = new Label("");
            spacerLabel.setPixelSize(199, 50);
            verticalPanel.add((Widget)spacerLabel);
            Button addApplicationButton = new Button("Add application", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            addApplicationButton.setWidth("100%");
            columnCompositePanel.add((Widget)addApplicationButton);
        }
    }

    public String getDARText() {
        String source = "";
        for (int col = 0; col < this.routeColumns.length; ++col) {
            int count = this.routeColumns[col].getWidgetCount();
            boolean empty = true;
            String routeText = "";
            for (int row = 0; row < count; ++row) {
                Widget widget = this.routeColumns[col].getWidget(row);
                if (!(widget instanceof ApplicationRouteNodeEditor)) continue;
                empty = false;
                routeText = routeText + widget.toString() + ",";
            }
            if (empty) continue;
            routeText = routeText.substring(0, routeText.length() - 1);
            source = source + COLUMNS[col] + ":" + routeText + "\n";
        }
        return source;
    }

    public VerticalPanel[] getColumns() {
        return this.routeColumns;
    }

    private void init() {
        DARConfigurationServiceAsync darConfigService = DARConfigurationService.Util.getInstance();
        darConfigService.getConfiguration((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$000(RequestColumnsContainer x0, DARRoute[] x1) {
        x0.populateRouterNodes(x1);
    }
}

