/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.management.client.dnd;

import com.allen_sauer.gwt.dnd.client.AbstractDragController;
import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.VetoDragException;
import com.allen_sauer.gwt.dnd.client.drop.BoundaryDropController;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.allen_sauer.gwt.dnd.client.util.CoordinateLocation;
import com.allen_sauer.gwt.dnd.client.util.DOMUtil;
import com.allen_sauer.gwt.dnd.client.util.Location;
import com.allen_sauer.gwt.dnd.client.util.WidgetArea;
import com.allen_sauer.gwt.dnd.client.util.WidgetLocation;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import org.mobicents.servlet.management.client.dnd.DropControllerCollection;
import org.mobicents.servlet.management.client.dnd.PickupDragController;

public class PickupDragController
extends AbstractDragController {
    private static final String PRIVATE_CSS_MOVABLE_PANEL = "dragdrop-movable-panel";
    private static final String PRIVATE_CSS_PROXY = "dragdrop-proxy";
    private BoundaryDropController boundaryDropController;
    private int boundaryOffsetX;
    private int boundaryOffsetY;
    private boolean dragProxyEnabled = false;
    private DropControllerCollection dropControllerCollection;
    private ArrayList dropControllerList = new ArrayList();
    private int dropTargetClientHeight;
    private int dropTargetClientWidth;
    private Widget movablePanel;
    private HashMap savedWidgetInfoMap;

    public PickupDragController(AbsolutePanel boundaryPanel, boolean allowDroppingOnBoundaryPanel) {
        super(boundaryPanel);
        this.boundaryDropController = this.newBoundaryDropController(boundaryPanel, allowDroppingOnBoundaryPanel);
        this.registerDropController((DropController)this.boundaryDropController);
        this.dropControllerCollection = new DropControllerCollection(this.dropControllerList);
    }

    public void dragEnd() {
        if (this.context.vetoException != null) {
            if (!this.getBehaviorDragProxy()) {
                this.restoreSelectedWidgetsLocation();
            }
        } else {
            this.context.dropController.onDrop(this.context);
        }
        this.context.dropController.onLeave(this.context);
        this.context.dropController = null;
        if (!this.getBehaviorDragProxy()) {
            this.restoreSelectedWidgetsStyle();
        }
        this.movablePanel.removeFromParent();
        this.movablePanel = null;
        super.dragEnd();
    }

    public void dragMove() {
        int desiredLeft = this.context.desiredDraggableX - this.boundaryOffsetX;
        int desiredTop = this.context.desiredDraggableY - this.boundaryOffsetY;
        if (this.getBehaviorConstrainedToBoundaryPanel()) {
            desiredLeft = Math.max(0, Math.min(desiredLeft, this.dropTargetClientWidth - this.context.draggable.getOffsetWidth()));
            desiredTop = Math.max(0, Math.min(desiredTop, this.dropTargetClientHeight - this.context.draggable.getOffsetHeight()));
        }
        DOMUtil.fastSetElementPosition((Element)this.movablePanel.getElement(), (int)desiredLeft, (int)desiredTop);
        DropController newDropController = this.getIntersectDropController(this.context.mouseX, this.context.mouseY);
        if (this.context.dropController != newDropController) {
            if (this.context.dropController != null) {
                this.context.dropController.onLeave(this.context);
            }
            this.context.dropController = newDropController;
            if (this.context.dropController != null) {
                this.context.dropController.onEnter(this.context);
            }
        }
        if (this.context.dropController != null) {
            this.context.dropController.onMove(this.context);
        }
    }

    public void dragStart() {
        Widget widget;
        int q;
        super.dragStart();
        WidgetLocation currentDraggableLocation = new WidgetLocation(this.context.draggable, (Widget)this.context.boundaryPanel);
        this.saveSelectedWidgetsLocationAndStyle();
        AbsolutePanel container = new AbsolutePanel();
        DOM.setStyleAttribute((Element)container.getElement(), (String)"overflow", (String)"visible");
        container.setPixelSize(this.context.draggable.getOffsetWidth(), this.context.draggable.getOffsetHeight());
        this.context.boundaryPanel.add((Widget)container, currentDraggableLocation.getLeft(), currentDraggableLocation.getTop());
        int draggableAbsoluteLeft = this.context.draggable.getAbsoluteLeft();
        int draggableAbsoluteTop = this.context.draggable.getAbsoluteTop();
        HashMap<Widget, CoordinateLocation> widgetLocation = new HashMap<Widget, CoordinateLocation>();
        for (q = 0; q < this.context.selectedWidgets.size(); ++q) {
            widget = (Widget)this.context.selectedWidgets.get(q);
            widgetLocation.put(widget, new CoordinateLocation(widget.getAbsoluteLeft(), widget.getAbsoluteTop()));
        }
        this.context.dropController = this.getIntersectDropController(this.context.mouseX, this.context.mouseY);
        if (this.context.dropController != null) {
            this.context.dropController.onEnter(this.context);
        }
        for (q = 0; q < this.context.selectedWidgets.size(); ++q) {
            widget = (Widget)this.context.selectedWidgets.get(q);
            Location location = (Location)widgetLocation.get(widget);
            int relativeX = location.getLeft() - draggableAbsoluteLeft;
            int relativeY = location.getTop() - draggableAbsoluteTop;
            container.add(widget, relativeX, relativeY);
        }
        this.movablePanel = container;
        this.movablePanel.addStyleName(PRIVATE_CSS_MOVABLE_PANEL);
        WidgetLocation widgetLocation2 = new WidgetLocation((Widget)this.context.boundaryPanel, null);
        this.boundaryOffsetX = widgetLocation2.getLeft() + DOMUtil.getBorderLeft((Element)this.context.boundaryPanel.getElement());
        this.boundaryOffsetY = widgetLocation2.getTop() + DOMUtil.getBorderTop((Element)this.context.boundaryPanel.getElement());
        this.dropTargetClientWidth = DOMUtil.getClientWidth((Element)this.getBoundaryPanel().getElement());
        this.dropTargetClientHeight = DOMUtil.getClientHeight((Element)this.getBoundaryPanel().getElement());
    }

    public boolean getBehaviorBoundaryPanelDrop() {
        return this.boundaryDropController.getBehaviorBoundaryPanelDrop();
    }

    public boolean getBehaviorDragProxy() {
        return this.dragProxyEnabled;
    }

    public void previewDragEnd() throws VetoDragException {
        try {
            this.context.dropController.onPreviewDrop(this.context);
            this.context.finalDropController = this.context.dropController;
        }
        catch (VetoDragException ex) {
            this.context.finalDropController = null;
            throw ex;
        }
        finally {
            super.previewDragEnd();
        }
    }

    public void registerDropController(DropController dropController) {
        this.dropControllerList.add(dropController);
    }

    public void resetCache() {
        super.resetCache();
        this.dropControllerCollection.resetCache((Panel)this.getBoundaryPanel(), this.context);
    }

    public void setBehaviorBoundaryPanelDrop(boolean allowDroppingOnBoundaryPanel) {
        this.boundaryDropController.setBehaviorBoundaryPanelDrop(allowDroppingOnBoundaryPanel);
    }

    public void setBehaviorDragProxy(boolean dragProxyEnabled) {
        this.dragProxyEnabled = dragProxyEnabled;
    }

    public void unregisterDropController(DropController dropController) {
        this.dropControllerList.remove(dropController);
    }

    protected BoundaryDropController newBoundaryDropController(AbsolutePanel boundaryPanel, boolean allowDroppingOnBoundaryPanel) {
        return new BoundaryDropController(boundaryPanel, allowDroppingOnBoundaryPanel);
    }

    protected Widget newDragProxy(DragContext context) {
        AbsolutePanel container = new AbsolutePanel();
        DOM.setStyleAttribute((Element)container.getElement(), (String)"overflow", (String)"visible");
        WidgetArea draggableArea = new WidgetArea(context.draggable, null);
        for (int q = 0; q < context.selectedWidgets.size(); ++q) {
            Widget widget = (Widget)context.selectedWidgets.get(q);
            WidgetArea widgetArea = new WidgetArea(widget, null);
            SimplePanel proxy = new SimplePanel();
            proxy.setPixelSize(widget.getOffsetWidth(), widget.getOffsetHeight());
            proxy.addStyleName(PRIVATE_CSS_PROXY);
            container.add((Widget)proxy, widgetArea.getLeft() - draggableArea.getLeft(), widgetArea.getTop() - draggableArea.getTop());
        }
        return container;
    }

    protected void restoreSelectedWidgetsLocation() {
        for (int q = 0; q < this.context.selectedWidgets.size(); ++q) {
            Widget widget = (Widget)this.context.selectedWidgets.get(q);
            SavedWidgetInfo info = (SavedWidgetInfo)this.savedWidgetInfoMap.get(widget);
            if (info.initialDraggableParent instanceof AbsolutePanel) {
                ((AbsolutePanel)info.initialDraggableParent).add(widget, info.initialDraggableParentLocation.getLeft(), info.initialDraggableParentLocation.getTop());
                continue;
            }
            if (info.initialDraggableParent instanceof HorizontalPanel) {
                ((HorizontalPanel)info.initialDraggableParent).insert(widget, info.initialDraggableIndex);
                continue;
            }
            if (info.initialDraggableParent instanceof VerticalPanel) {
                ((VerticalPanel)info.initialDraggableParent).insert(widget, info.initialDraggableIndex);
                continue;
            }
            if (info.initialDraggableParent instanceof FlowPanel) {
                ((FlowPanel)info.initialDraggableParent).insert(widget, info.initialDraggableIndex);
                continue;
            }
            if (info.initialDraggableParent instanceof SimplePanel) {
                ((SimplePanel)info.initialDraggableParent).setWidget(widget);
                continue;
            }
            throw new RuntimeException("Unable to handle initialDraggableParent " + info.initialDraggableParent.toString());
        }
    }

    protected void restoreSelectedWidgetsStyle() {
        for (int q = 0; q < this.context.selectedWidgets.size(); ++q) {
            Widget widget = (Widget)this.context.selectedWidgets.get(q);
            SavedWidgetInfo info = (SavedWidgetInfo)this.savedWidgetInfoMap.get(widget);
            DOM.setStyleAttribute((Element)widget.getElement(), (String)"margin", (String)info.initialDraggableMargin);
        }
    }

    protected void saveSelectedWidgetsLocationAndStyle() {
        this.savedWidgetInfoMap = new HashMap();
        for (int q = 0; q < this.context.selectedWidgets.size(); ++q) {
            Widget widget = (Widget)this.context.selectedWidgets.get(q);
            SavedWidgetInfo info = new SavedWidgetInfo(null);
            info.initialDraggableParent = widget.getParent();
            if (info.initialDraggableParent instanceof AbsolutePanel) {
                info.initialDraggableParentLocation = new WidgetLocation(widget, info.initialDraggableParent);
            } else if (info.initialDraggableParent instanceof HorizontalPanel) {
                info.initialDraggableIndex = ((HorizontalPanel)info.initialDraggableParent).getWidgetIndex(widget);
            } else if (info.initialDraggableParent instanceof VerticalPanel) {
                info.initialDraggableIndex = ((VerticalPanel)info.initialDraggableParent).getWidgetIndex(widget);
            } else if (info.initialDraggableParent instanceof FlowPanel) {
                info.initialDraggableIndex = ((FlowPanel)info.initialDraggableParent).getWidgetIndex(widget);
            } else if (!(info.initialDraggableParent instanceof SimplePanel)) {
                throw new RuntimeException("Unable to handle 'initialDraggableParent instanceof " + info.initialDraggableParent.toString() + "'; Please create your own DragController and override saveDraggableLocationAndStyle() and restoreDraggableLocation()");
            }
            info.initialDraggableMargin = DOM.getStyleAttribute((Element)widget.getElement(), (String)"margin");
            DOM.setStyleAttribute((Element)widget.getElement(), (String)"margin", (String)"0px");
            this.savedWidgetInfoMap.put(widget, info);
        }
    }

    private DropController getIntersectDropController(int x, int y) {
        DropController dropController = this.dropControllerCollection.getIntersectDropController(x, y);
        return dropController != null ? dropController : this.boundaryDropController;
    }
}

