/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.management.client.dnd;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.allen_sauer.gwt.dnd.client.util.Area;
import com.allen_sauer.gwt.dnd.client.util.CoordinateLocation;
import com.allen_sauer.gwt.dnd.client.util.DOMUtil;
import com.allen_sauer.gwt.dnd.client.util.Location;
import com.allen_sauer.gwt.dnd.client.util.WidgetArea;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import org.mobicents.servlet.management.client.dnd.DropControllerCollection;

class DropControllerCollection {
    private final ArrayList dropControllerList;
    private Candidate[] sortedCandidates = null;

    DropControllerCollection(ArrayList dropControllerList) {
        this.dropControllerList = dropControllerList;
    }

    DropController getIntersectDropController(int x, int y) {
        CoordinateLocation location = new CoordinateLocation(x, y);
        for (int i = this.sortedCandidates.length - 1; i >= 0; --i) {
            Candidate candidate = this.sortedCandidates[i];
            Area targetArea = candidate.getTargetArea();
            if (!targetArea.intersects((Location)location)) continue;
            return candidate.getDropController();
        }
        return null;
    }

    void resetCache(Panel boundaryPanel, DragContext context) {
        ArrayList<Candidate> list = new ArrayList<Candidate>();
        if (context.draggable != null) {
            WidgetArea boundaryArea = new WidgetArea((Widget)boundaryPanel, null);
            for (DropController dropController : this.dropControllerList) {
                Candidate candidate = new Candidate(dropController);
                if (DOMUtil.isOrContains((Element)context.draggable.getElement(), (Element)candidate.getDropTarget().getElement()) || !candidate.getTargetArea().intersects((Area)boundaryArea)) continue;
                list.add(candidate);
            }
        }
        Object[] sortedCandidates = new Candidate[list.size()];
        for (int q = 0; q < sortedCandidates.length; ++q) {
            sortedCandidates[q] = (Candidate)list.get(q);
        }
        Arrays.sort(sortedCandidates);
    }
}

