/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.management.server.configuration;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.mbeans.MBeanUtils;
import org.mobicents.servlet.management.client.configuration.ConfigurationService;
import org.mobicents.servlet.sip.core.ConcurrencyControlMode;

public class ConfigurationServiceImpl
extends RemoteServiceServlet
implements ConfigurationService {
    private static MBeanServer mserver = MBeanUtils.createServer();

    private ObjectName getApplicationDispatcher() {
        try {
            ObjectName dispatcherQuery = new ObjectName("*:type=SipApplicationDispatcher");
            ObjectInstance dispatcherInstance = mserver.queryMBeans(dispatcherQuery, null).iterator().next();
            ObjectName dispatcherName = dispatcherInstance.getObjectName();
            return dispatcherName;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String getConcurrencyControlMode() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            ConcurrencyControlMode mode = (ConcurrencyControlMode)mserver.getAttribute(dispatcherName, "concurrencyControlMode");
            return mode.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public int getQueueSize() {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            String size = mserver.getAttribute(dispatcherName, "queueSize").toString();
            return Integer.parseInt(size);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setConcurrencyControlMode(String mode) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("concurrencyControlMode", ConcurrencyControlMode.valueOf((String)mode));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }

    public void setQueueSize(int queueSize) {
        try {
            ObjectName dispatcherName = this.getApplicationDispatcher();
            Attribute att = new Attribute("queueSize", new Integer(queueSize));
            mserver.setAttribute(dispatcherName, att);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error", t);
        }
    }
}

