/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;

public class LocationServiceSipServlet
extends SipServlet {
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = Logger.getLogger(LocationServiceSipServlet.class);
    private static final String LOCAL_TRANSPORT = "udp";
    private static final int LOCAL_PORT = 5070;
    private static final String LOCAL_LOCALHOST_ADDR = "127.0.0.1";
    private static final String REMOTE_TRANSPORT = "udp";
    private static final int REMOTE_PORT = 5090;
    private static final String REMOTE_LOCALHOST_ADDR = "127.0.0.1";
    private static final String INITIAL_REMOTE_TRANSPORT = "udp";
    private static final int INITIAL_REMOTE_PORT = 5070;
    private static final String INITIAL_REMOTE_LOCALHOST_ADDR = "127.0.0.1";
    private static final String TEST_USER_REMOTE = "remote";
    Map<String, List<URI>> registeredUsers = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the locationb service sip servlet has been started");
        super.init(servletConfig);
        SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        this.registeredUsers = new HashMap();
        ArrayList<URI> uriList = new ArrayList<URI>();
        uriList.add(sipFactory.createURI("sip:receiver@127.0.0.1:5090"));
        uriList.add(sipFactory.createURI("sip:receiver@127.0.0.1:6090"));
        this.registeredUsers.put("sip:receiver@sip-servlets.com", uriList);
        uriList = new ArrayList();
        uriList.add(sipFactory.createURI("sip:receiver-failover@127.0.0.1:5090"));
        this.registeredUsers.put("sip:receiver-failover@sip-servlets.com", uriList);
        this.registeredUsers.put("sip:receiver-failover@127.0.0.1:5090", uriList);
        uriList = new ArrayList();
        uriList.add(sipFactory.createURI("sip:receiver@127.0.0.1:5070"));
        this.registeredUsers.put("sip:proxy-b2bua@127.0.0.1:5070", uriList);
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got request:\n" + request.toString()));
        if (((SipURI)request.getFrom().getURI()).getUser().equalsIgnoreCase(TEST_USER_REMOTE)) {
            if (!request.getRemoteAddr().equals("127.0.0.1") || request.getRemotePort() != 5070 || !request.getTransport().equalsIgnoreCase("udp")) {
                logger.error((Object)"remote information is incorrect");
                logger.error((Object)("remote addr " + request.getRemoteAddr()));
                logger.error((Object)("remote port " + request.getRemotePort()));
                logger.error((Object)("remote transport " + request.getTransport()));
                SipServletResponse sipServletResponse = request.createResponse(500, "Incorrect remote information");
                sipServletResponse.send();
                return;
            }
            logger.info((Object)"remote information is correct");
            if (!request.getInitialRemoteAddr().equals("127.0.0.1") || request.getInitialRemotePort() != 5070 || !request.getInitialTransport().equalsIgnoreCase("udp")) {
                logger.error((Object)"Initial remote information is incorrect");
                logger.error((Object)("Initial remote addr " + request.getInitialRemoteAddr()));
                logger.error((Object)("Initial remote port " + request.getInitialRemotePort()));
                logger.error((Object)("Initial remote transport " + request.getInitialTransport()));
                throw new IllegalArgumentException("initial remote information is incorrect");
            }
            logger.info((Object)"Initial remote information is correct");
            if (request.getLocalAddr().equals("127.0.0.1") && request.getLocalPort() == 5070 && request.getTransport().equalsIgnoreCase("udp")) {
                logger.info((Object)"local information is correct");
            } else {
                logger.error((Object)"local information is incorrect");
                logger.error((Object)("local addr " + request.getLocalAddr()));
                logger.error((Object)("local port " + request.getLocalPort()));
                logger.error((Object)("local transport " + request.getTransport()));
                throw new IllegalArgumentException("local information is incorrect");
            }
        }
        if (request.isInitial()) {
            List contactAddresses = (List)this.registeredUsers.get(request.getRequestURI().toString());
            if (contactAddresses != null && contactAddresses.size() > 0) {
                Proxy proxy = request.getProxy();
                proxy.setProxyTimeout(3);
                proxy.setRecordRoute(true);
                proxy.setParallel(true);
                proxy.setSupervised(true);
                for (URI uri : contactAddresses) {
                    logger.info((Object)("proxying to " + uri));
                }
                proxy.proxyTo(contactAddresses);
            } else {
                logger.info((Object)(request.getRequestURI().toString() + " is not currently registered"));
                SipServletResponse sipServletResponse = request.createResponse(301, "Moved Permanently");
                sipServletResponse.send();
            }
        }
    }

    protected void doErrorResponse(SipServletResponse resp) throws ServletException, IOException {
        logger.info((Object)("Got response " + resp));
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
        logger.info((Object)("Got response " + resp));
        if (((SipURI)resp.getFrom().getURI()).getUser().equalsIgnoreCase(TEST_USER_REMOTE)) {
            if (!resp.getRemoteAddr().equals("127.0.0.1") || resp.getRemotePort() != 5090 || !resp.getTransport().equalsIgnoreCase("udp")) {
                logger.error((Object)"remote information is incorrect");
                logger.error((Object)("remote addr " + resp.getRemoteAddr()));
                logger.error((Object)("remote port " + resp.getRemotePort()));
                logger.error((Object)("remote transport " + resp.getTransport()));
                throw new IllegalArgumentException("remote information is incorrect");
            }
            logger.info((Object)"remote information is correct");
            if (!resp.getInitialRemoteAddr().equals("127.0.0.1") || resp.getInitialRemotePort() != 5090 || !resp.getInitialTransport().equalsIgnoreCase("udp")) {
                logger.error((Object)"Initial remote information is incorrect");
                logger.error((Object)("Initial remote addr " + resp.getInitialRemoteAddr()));
                logger.error((Object)("Initial remote port " + resp.getInitialRemotePort()));
                logger.error((Object)("Initial remote transport " + resp.getInitialTransport()));
                throw new IllegalArgumentException("initial remote information is incorrect");
            }
            logger.info((Object)"Initial remote information is correct");
            if (resp.getLocalAddr().equals("127.0.0.1") && resp.getLocalPort() == 5070 && resp.getTransport().equalsIgnoreCase("udp")) {
                logger.info((Object)"local information is correct");
            } else {
                logger.error((Object)"local information is incorrect");
                logger.error((Object)("local addr " + resp.getLocalAddr()));
                logger.error((Object)("local port " + resp.getLocalPort()));
                logger.error((Object)("local transport " + resp.getTransport()));
                throw new IllegalArgumentException("local information is incorrect");
            }
        }
    }

    protected void doRegister(SipServletRequest req) throws ServletException, IOException {
        logger.info((Object)("Received register request: " + req.getTo()));
        Address toAddress = req.getTo();
        ListIterator contactAddresses = req.getAddressHeaders("Contact");
        ArrayList<URI> contactUris = new ArrayList<URI>();
        while (contactAddresses.hasNext()) {
            Address contactAddress = (Address)contactAddresses.next();
            contactUris.add(contactAddress.getURI());
        }
        this.registeredUsers.put(toAddress.toString(), contactUris);
        int response = 200;
        SipServletResponse resp = req.createResponse(response);
        resp.send();
    }

    protected void doCancel(SipServletRequest req) throws ServletException, IOException {
        logger.error((Object)("CANCEL seen at proxy " + req));
    }
}

