/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocationServiceSipServlet
extends SipServlet
implements SipErrorListener,
Servlet {
    private static Log logger = LogFactory.getLog(LocationServiceSipServlet.class);
    Map<String, List<URI>> registeredUsers = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the locationb service sip servlet has been started");
        super.init(servletConfig);
        SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        this.registeredUsers = new HashMap();
        ArrayList<URI> uriList = new ArrayList<URI>();
        uriList.add(sipFactory.createURI("sip:receiver@127.0.0.1:5090"));
        uriList.add(sipFactory.createURI("sip:receiver@127.0.0.1:6090"));
        this.registeredUsers.put("sip:receiver@sip-servlets.com", uriList);
        uriList = new ArrayList();
        uriList.add(sipFactory.createURI("sip:receiver-failover@127.0.0.1:5090"));
        this.registeredUsers.put("sip:receiver-failover@sip-servlets.com", uriList);
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got request:\n" + request.toString()));
        List contactAddresses = (List)this.registeredUsers.get(request.getRequestURI().toString());
        if (contactAddresses != null && contactAddresses.size() > 0) {
            Proxy proxy = request.getProxy();
            proxy.setProxyTimeout(3);
            proxy.setRecordRoute(true);
            proxy.setParallel(true);
            proxy.setSupervised(true);
            proxy.proxyTo(contactAddresses);
        } else {
            logger.info((Object)(request.getRequestURI().toString() + " is not currently registered"));
            SipServletResponse sipServletResponse = request.createResponse(301, "Moved Permanently");
            sipServletResponse.send();
        }
    }

    protected void doErrorResponse(SipServletResponse resp) throws ServletException, IOException {
        logger.info((Object)("Got response " + resp));
    }

    protected void doRegister(SipServletRequest req) throws ServletException, IOException {
        logger.info((Object)("Received register request: " + req.getTo()));
        Address toAddress = req.getTo();
        ListIterator contactAddresses = req.getAddressHeaders("Contact");
        ArrayList<URI> contactUris = new ArrayList<URI>();
        while (contactAddresses.hasNext()) {
            Address contactAddress = (Address)contactAddresses.next();
            contactUris.add(contactAddress.getURI());
        }
        this.registeredUsers.put(toAddress.toString(), contactUris);
        int response = 200;
        SipServletResponse resp = req.createResponse(response);
        resp.send();
    }

    public void noAckReceived(SipErrorEvent ee) {
        logger.error((Object)"noAckReceived.");
    }

    public void noPrackReceived(SipErrorEvent ee) {
        logger.error((Object)"noPrackReceived.");
    }
}

