/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mobicents.servlet.sip;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.mobicents.servlet.sip.ConvergedWarDiscoveryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedConvergedWarDiscoveryComponent
extends MBeanResourceDiscoveryComponent {
    private static final Log log = LogFactory.getLog(EmbeddedConvergedWarDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context) {
        Set resources = super.discoverResources(context);
        Set<Object> resourceDetails = new HashSet<DiscoveredResourceDetails>();
        log.debug((Object)("resources " + resources.size()));
        for (DiscoveredResourceDetails discoveredResourceDetails : resources) {
            JBossASServerComponent parentJBossASComponent = (JBossASServerComponent)context.getParentResourceComponent();
            String parentEar = discoveredResourceDetails.getResourceName();
            String objectName = "jboss.management.local:J2EEApplication=" + parentEar + ",J2EEServer=Local,j2eeType=WebModule,name=%name%";
            log.debug((Object)("discoveredResourceDetails Object name to dicsover the converged sar/war embedded resource " + objectName));
            Configuration defaultPluginConfiguration = context.getDefaultPluginConfiguration();
            defaultPluginConfiguration.put((Property)new PropertySimple("objectName", (Object)objectName));
            resourceDetails = super.performDiscovery(defaultPluginConfiguration, (JMXComponent)parentJBossASComponent, context.getResourceType());
            log.debug((Object)("resourceDetails size" + resourceDetails.size()));
            resourceDetails = ConvergedWarDiscoveryHelper.initPluginConfigurations(parentJBossASComponent, resourceDetails);
            log.debug((Object)("resourceDetails final size" + resourceDetails.size()));
        }
        return resourceDetails;
    }
}

