/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mobicents.servlet.sip;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.plugins.jbossas.util.WarDeploymentInformation;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;
import org.rhq.plugins.mobicents.servlet.sip.ConvergedWarDiscoveryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvergedDeploymentUtility {
    private static Log log = LogFactory.getLog(ConvergedDeploymentUtility.class);
    protected static final String MAIN_DEPLOYER = "jboss.system:service=MainDeployer";
    private static final String LIST_DEPLOYED_MODULES_OP_NAME = "listDeployedModules";
    private static final String LIST_DEPLOYED_OP_NAME = "listDeployed";

    public static Map<String, List<WarDeploymentInformation>> getConvergedWarDeploymentInformation(EmsConnection connection, List<String> objectNames) {
        Collection deployed;
        HashMap<String, List<WarDeploymentInformation>> retDeploymentInformationMap = new HashMap<String, List<WarDeploymentInformation>>();
        try {
            deployed = ConvergedDeploymentUtility.getDeploymentInformations(connection);
        }
        catch (Exception e) {
            return null;
        }
        String separator = System.getProperty("file.separator");
        boolean isOnWin = separator.equals("\\");
        for (Object sdi : deployed) {
            try {
                ObjectName jbossWebObjectName = ConvergedDeploymentUtility.getFieldValue(sdi, "deployedObject", ObjectName.class);
                if (jbossWebObjectName == null) continue;
                String shortName = ConvergedDeploymentUtility.getFieldValue(sdi, "shortName", String.class);
                for (String objectNameString : objectNames) {
                    String file;
                    String nameFromObject = ConvergedDeploymentUtility.getMBeanNameAttribute(objectNameString);
                    if (!shortName.equals(nameFromObject)) continue;
                    String jbossWebmBeanName = jbossWebObjectName.getCanonicalName();
                    String contextRoot = ConvergedDeploymentUtility.getMBeanNameAttribute(jbossWebmBeanName);
                    int lastSlashIndex = contextRoot.lastIndexOf("/");
                    if (lastSlashIndex > 0) {
                        int lastIndex = contextRoot.length() - 1;
                        String string = contextRoot = lastSlashIndex == lastIndex ? "/" : contextRoot.substring(lastSlashIndex + 1);
                    }
                    if ((file = ConvergedDeploymentUtility.getFieldValue(sdi, "url", URL.class).toString()).startsWith("file:/")) {
                        if (isOnWin) {
                            file = file.substring(6);
                            File tmp = new File(file);
                            file = tmp.getCanonicalPath();
                        } else {
                            file = file.substring(5);
                        }
                    }
                    List<EmsBean> vhosts = ConvergedDeploymentUtility.getVHosts(contextRoot, connection);
                    ArrayList<WarDeploymentInformation> infos = new ArrayList<WarDeploymentInformation>(vhosts.size());
                    for (EmsBean vhost : vhosts) {
                        WarDeploymentInformation deploymentInformation = new WarDeploymentInformation();
                        String vhostname = vhost.getBeanName().getKeyProperty("host");
                        deploymentInformation.setVHost(vhostname);
                        deploymentInformation.setFileName(file);
                        deploymentInformation.setContextRoot(contextRoot);
                        int index = jbossWebmBeanName.indexOf("name=");
                        jbossWebmBeanName = jbossWebmBeanName.substring(0, index + 5);
                        jbossWebmBeanName = jbossWebmBeanName + "//" + vhostname + ConvergedWarDiscoveryHelper.getContextPath(contextRoot);
                        deploymentInformation.setJbossWebModuleMBeanObjectName(jbossWebmBeanName);
                        infos.add(deploymentInformation);
                    }
                    retDeploymentInformationMap.put(objectNameString, infos);
                }
            }
            catch (Exception evalError) {
                log.warn((Object)"Failed to determine if a deployment contains our mbean", (Throwable)evalError);
            }
        }
        return retDeploymentInformationMap;
    }

    public static List<EmsBean> getVHosts(String contextRoot, EmsConnection emsConnection) {
        String pattern = "jboss.web:host=%host%,path=" + ConvergedWarDiscoveryHelper.getContextPath(contextRoot) + ",type=SipManager";
        ObjectNameQueryUtility queryUtil = new ObjectNameQueryUtility(pattern);
        List mBeans = emsConnection.queryBeans(queryUtil.getTranslatedQuery());
        return mBeans;
    }

    private static Collection getDeploymentInformations(EmsConnection connection) throws Exception {
        Collection deploymentInfos;
        block6: {
            deploymentInfos = null;
            EmsOperation operation = null;
            try {
                operation = ConvergedDeploymentUtility.getListDeployedOperation(connection);
                if (operation == null) {
                    throw new UnsupportedOperationException("This JBossAS instance is unsupported; its MainDeployer MBean doesn't have a listDeployedModules or listDeployed operation.");
                }
                deploymentInfos = (Collection)operation.invoke(new Object[0]);
            }
            catch (RuntimeException re) {
                if (operation != null && operation.getName().equals(LIST_DEPLOYED_MODULES_OP_NAME)) {
                    EmsBean mainDeployerMBean = connection.getBean(MAIN_DEPLOYER);
                    operation = mainDeployerMBean.getOperation(LIST_DEPLOYED_OP_NAME);
                    try {
                        deploymentInfos = (Collection)operation.invoke(new Object[0]);
                    }
                    catch (RuntimeException re2) {
                        deploymentInfos = null;
                    }
                }
                if (deploymentInfos != null) break block6;
                log.warn((Object)("Cannot determine deployed modules - cause: " + re));
                throw new Exception(re);
            }
        }
        return deploymentInfos;
    }

    private static String getMBeanNameAttribute(String objectBeanName) {
        String[] splitName = objectBeanName.split("name=");
        String retNameAttribute = "";
        if (splitName.length > 1) {
            String afterName = splitName[1];
            String[] removeAnythingAfter = afterName.split(",");
            retNameAttribute = removeAnythingAfter.length > 0 ? removeAnythingAfter[0] : afterName;
        }
        return retNameAttribute;
    }

    private static <T> T getFieldValue(Object target, String name, Class<T> T) {
        Object ret;
        if (target == null) {
            return null;
        }
        try {
            Field field = target.getClass().getField(name);
            ret = field.get(target);
            if (T == ObjectName.class && ret != null) {
                ret = new ObjectName(ret.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return (T)ret;
    }

    protected static EmsOperation getListDeployedOperation(EmsConnection connection) {
        EmsBean bean = connection.getBean(MAIN_DEPLOYER);
        EmsOperation retOperation = bean.getOperation(LIST_DEPLOYED_MODULES_OP_NAME);
        if (retOperation == null) {
            retOperation = bean.getOperation(LIST_DEPLOYED_OP_NAME);
        }
        return retOperation;
    }
}

