/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.sip.SipServletRequest;
import org.mobicents.servlet.sip.catalina.rules.request.DisplayName;
import org.mobicents.servlet.sip.catalina.rules.request.Extractor;
import org.mobicents.servlet.sip.catalina.rules.request.From;
import org.mobicents.servlet.sip.catalina.rules.request.Host;
import org.mobicents.servlet.sip.catalina.rules.request.Method;
import org.mobicents.servlet.sip.catalina.rules.request.Param;
import org.mobicents.servlet.sip.catalina.rules.request.Port;
import org.mobicents.servlet.sip.catalina.rules.request.Scheme;
import org.mobicents.servlet.sip.catalina.rules.request.Tel;
import org.mobicents.servlet.sip.catalina.rules.request.To;
import org.mobicents.servlet.sip.catalina.rules.request.Uri;
import org.mobicents.servlet.sip.catalina.rules.request.User;
import org.mobicents.servlet.sip.core.descriptor.MatchingRule;

public abstract class RequestRule
implements MatchingRule {
    private String varName;
    private List<Extractor> extractors;

    protected RequestRule(String varName) {
        this.varName = varName;
        this.extractors = new ArrayList<Extractor>();
        StringTokenizer st = new StringTokenizer(varName, ".");
        String lastToken = st.nextToken();
        if (!lastToken.equals("request")) {
            throw new IllegalArgumentException("Expression does not start with request: " + varName);
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("from")) {
                this.extractors.add(new From(lastToken));
            } else if (token.equals("uri")) {
                this.extractors.add(new Uri(lastToken));
            } else if (token.equals("method")) {
                this.extractors.add(new Method(lastToken));
            } else if (token.equals("user")) {
                this.extractors.add(new User(lastToken));
            } else if (token.equals("scheme")) {
                this.extractors.add(new Scheme(lastToken));
            } else if (token.equals("host")) {
                this.extractors.add(new Host(lastToken));
            } else if (token.equals("port")) {
                this.extractors.add(new Port(lastToken));
            } else if (token.equals("tel")) {
                this.extractors.add(new Tel(lastToken));
            } else if (token.equals("display-name")) {
                this.extractors.add(new DisplayName(lastToken));
            } else if (token.equals("to")) {
                this.extractors.add(new To(lastToken));
            } else if (token.equals("param")) {
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("No param name: " + varName);
                }
                String param = st.nextToken();
                this.extractors.add(new Param(lastToken, param));
                if (st.hasMoreTokens()) {
                    throw new IllegalArgumentException("Invalid var: " + st.nextToken() + " in " + varName);
                }
            } else {
                throw new IllegalArgumentException("Invalid property: " + token + " in " + varName);
            }
            lastToken = token;
        }
    }

    public String getValue(SipServletRequest request) {
        Object o = request;
        for (Extractor e : this.extractors) {
            o = e.extract(o);
            if (o != null) continue;
            return null;
        }
        return o.toString();
    }

    public String getVarName() {
        return this.varName;
    }
}

