/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina;

import gov.nist.core.net.AddressResolver;
import gov.nist.javax.sip.SipStackExt;
import gov.nist.javax.sip.message.MessageFactoryExt;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sip.SipListener;
import javax.sip.SipStack;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardService;
import org.apache.coyote.ProtocolHandler;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.modeler.Registry;
import org.mobicents.ext.javax.sip.dns.DNSAwareRouter;
import org.mobicents.ext.javax.sip.dns.DNSServerLocator;
import org.mobicents.ext.javax.sip.dns.DefaultDNSServerLocator;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingListener;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceImpl;
import org.mobicents.ha.javax.sip.ReplicationStrategy;
import org.mobicents.javax.servlet.CongestionControlPolicy;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.catalina.CatalinaSipService;
import org.mobicents.servlet.sip.catalina.ServiceGracefulStopTask;
import org.mobicents.servlet.sip.catalina.SipProtocolHandler;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipService;
import org.mobicents.servlet.sip.core.message.OutboundProxy;
import org.mobicents.servlet.sip.dns.MobicentsDNSResolver;
import org.mobicents.servlet.sip.message.Servlet3SipServletMessageFactory;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class SipStandardService
extends StandardService
implements CatalinaSipService {
    private static final Logger logger = Logger.getLogger(SipStandardService.class);
    public static final String DEFAULT_SIP_PATH_NAME = "gov.nist";
    public static final String PASS_INVITE_NON_2XX_ACK_TO_LISTENER = "gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER";
    public static final String TCP_POST_PARSING_THREAD_POOL_SIZE = "gov.nist.javax.sip.TCP_POST_PARSING_THREAD_POOL_SIZE";
    public static final String AUTOMATIC_DIALOG_SUPPORT_STACK_PROP = "javax.sip.AUTOMATIC_DIALOG_SUPPORT";
    public static final String LOOSE_DIALOG_VALIDATION = "gov.nist.javax.sip.LOOSE_DIALOG_VALIDATION";
    public static final String SERVER_LOG_STACK_PROP = "gov.nist.javax.sip.SERVER_LOG";
    public static final String DEBUG_LOG_STACK_PROP = "gov.nist.javax.sip.DEBUG_LOG";
    public static final String SERVER_HEADER = "org.mobicents.servlet.sip.SERVER_HEADER";
    public static final String USER_AGENT_HEADER = "org.mobicents.servlet.sip.USER_AGENT_HEADER";
    public static final String JVM_ROUTE = "jvmRoute";
    private static final String INFO = "org.mobicents.servlet.sip.startup.SipStandardService/1.0";
    protected String sipApplicationDispatcherClassName;
    protected SipApplicationDispatcher sipApplicationDispatcher;
    private boolean gatherStatistics = true;
    protected int sipMessageQueueSize = 1500;
    private int backToNormalSipMessageQueueSize = 1300;
    protected int memoryThreshold = 95;
    private int backToNormalMemoryThreshold = 90;
    protected OutboundProxy outboundProxy;
    protected String proxyTimerServiceImplementationType;
    protected String sasTimerServiceImplementationType;
    protected long congestionControlCheckingInterval = 30000L;
    private int canceledTimerTasksPurgePeriod = 0;
    private int baseTimerInterval = 500;
    private int t2Interval = 4000;
    private int t4Interval = 5000;
    private int timerDInterval = 32000;
    protected int dispatcherThreadPoolSize = 15;
    private boolean md5ContactUserPart = false;
    protected String concurrencyControlMode = ConcurrencyControlMode.SipApplicationSession.toString();
    protected String congestionControlPolicy = CongestionControlPolicy.ErrorResponse.toString();
    protected String additionalParameterableHeaders;
    protected boolean bypassResponseExecutor = true;
    protected boolean bypassRequestExecutor = true;
    protected String darConfigurationFileLocation;
    protected boolean connectorsStartedExternally = false;
    protected boolean dialogPendingRequestChecking = false;
    protected int callIdMaxLength;
    protected int tagHashMaxLength;
    protected boolean httpFollowsSip = false;
    protected String jvmRoute;
    protected ReplicationStrategy replicationStrategy;
    private String sipPathName;
    private boolean usePrettyEncoding = true;
    private SipStack sipStack;
    private Properties sipStackProperties;
    private String sipStackPropertiesFileLocation;
    @Deprecated
    private String addressResolverClass = null;
    private String dnsServerLocatorClass = DefaultDNSServerLocator.class.getName();
    private int dnsTimeout = 1;
    private String dnsResolverClass = MobicentsDNSResolver.class.getName();
    private String mobicentsSipServletMessageFactoryClassName = Servlet3SipServletMessageFactory.class.getName();
    @Deprecated
    private String balancers;
    private ScheduledFuture<?> gracefulStopFuture;

    public String getInfo() {
        return INFO;
    }

    public void addConnector(Connector connector) {
        ProtocolHandler protocolHandler;
        MobicentsExtendedListeningPoint extendedListeningPoint = null;
        if (connector.getProtocolHandler() instanceof SipProtocolHandler) {
            extendedListeningPoint = (MobicentsExtendedListeningPoint)((SipProtocolHandler)connector.getProtocolHandler()).getAttribute(ExtendedListeningPoint.class.getSimpleName());
        }
        if (extendedListeningPoint != null) {
            try {
                extendedListeningPoint.getSipProvider().addSipListener((SipListener)this.sipApplicationDispatcher);
                this.sipApplicationDispatcher.getSipNetworkInterfaceManager().addExtendedListeningPoint(extendedListeningPoint);
            }
            catch (TooManyListenersException e) {
                logger.error((Object)"Connector.initialize", (Throwable)e);
            }
        }
        if ((protocolHandler = connector.getProtocolHandler()) instanceof SipProtocolHandler) {
            connector.setPort(((SipProtocolHandler)protocolHandler).getPort());
            ((SipProtocolHandler)protocolHandler).setSipStack(this.sipStack);
            ((SipProtocolHandler)protocolHandler).setAttribute(SipApplicationDispatcher.class.getSimpleName(), this.sipApplicationDispatcher);
            this.registerSipConnector(connector);
        }
        super.addConnector(connector);
    }

    protected void registerSipConnector(Connector connector) {
        try {
            ObjectName objectName = this.createSipConnectorObjectName(connector, this.getName(), "SipConnector");
            Registry.getRegistry(null, null).registerComponent((Object)connector, objectName, null);
        }
        catch (Exception e) {
            logger.error((Object)"Error registering connector ", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating name for connector " + this.getObjectName()));
        }
    }

    public void removeConnector(Connector connector) {
        MobicentsExtendedListeningPoint extendedListeningPoint = null;
        if (connector.getProtocolHandler() instanceof SipProtocolHandler) {
            extendedListeningPoint = (MobicentsExtendedListeningPoint)((SipProtocolHandler)connector.getProtocolHandler()).getAttribute(ExtendedListeningPoint.class.getSimpleName());
        }
        if (extendedListeningPoint != null) {
            extendedListeningPoint.getSipProvider().removeSipListener((SipListener)this.sipApplicationDispatcher);
            this.sipApplicationDispatcher.getSipNetworkInterfaceManager().removeExtendedListeningPoint(extendedListeningPoint);
        }
        super.removeConnector(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInternal() throws LifecycleException {
        StaticServiceHolder.sipStandardService = this;
        try {
            this.sipApplicationDispatcher = (SipApplicationDispatcher)Class.forName(this.sipApplicationDispatcherClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new LifecycleException("Impossible to load the Sip Application Dispatcher", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new LifecycleException("Impossible to load the Sip Application Dispatcher", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new LifecycleException("Impossible to load the Sip Application Dispatcher", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new LifecycleException("Sip Application Dispatcher defined does not implement " + SipApplicationDispatcher.class.getName(), (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Pretty encoding of headers enabled ? " + this.usePrettyEncoding));
        }
        if (this.sipPathName == null) {
            this.sipPathName = DEFAULT_SIP_PATH_NAME;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Sip Stack path name : " + this.sipPathName));
        }
        this.sipApplicationDispatcher.setSipService((SipService)this);
        this.sipApplicationDispatcher.getSipFactory().initialize(this.sipPathName, this.usePrettyEncoding);
        String catalinaBase = this.getCatalinaBase();
        if (this.darConfigurationFileLocation != null) {
            if (!this.darConfigurationFileLocation.startsWith("file:///")) {
                this.darConfigurationFileLocation = "file:///" + catalinaBase.replace(File.separatorChar, '/') + "/" + this.darConfigurationFileLocation;
            }
            System.setProperty("javax.servlet.sip.dar", this.darConfigurationFileLocation);
        }
        super.initInternal();
        this.sipApplicationDispatcher.setDomain(this.getName());
        if (this.baseTimerInterval < 1) {
            throw new LifecycleException("It's forbidden to set the Base Timer Interval to a non positive value");
        }
        this.initSipStack();
        if (System.getProperty("telscale.license.dir") == null) {
            System.setProperty("telscale.license.dir", this.getCatalinaBase() + File.separatorChar + "bin");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting telscale.license.dir directory to : " + this.getCatalinaBase() + File.separatorChar + "bin"));
            }
        }
        if (System.getProperty("telscale.license.key.location") == null) {
            System.setProperty("telscale.license.key.location", this.getCatalinaBase() + File.separatorChar + "bin");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting telscale.license.key.location directory to : " + this.getCatalinaBase() + File.separatorChar + "bin"));
            }
        }
        this.sipApplicationDispatcher.setBaseTimerInterval(this.baseTimerInterval);
        this.sipApplicationDispatcher.setT2Interval(this.t2Interval);
        this.sipApplicationDispatcher.setT4Interval(this.t4Interval);
        this.sipApplicationDispatcher.setTimerDInterval(this.timerDInterval);
        this.sipApplicationDispatcher.setMemoryThreshold(this.getMemoryThreshold());
        this.sipApplicationDispatcher.setBackToNormalMemoryThreshold(this.backToNormalMemoryThreshold);
        this.sipApplicationDispatcher.setCongestionControlCheckingInterval(this.getCongestionControlCheckingInterval());
        this.sipApplicationDispatcher.setCongestionControlPolicyByName(this.getCongestionControlPolicy());
        this.sipApplicationDispatcher.setQueueSize(this.getSipMessageQueueSize());
        this.sipApplicationDispatcher.setBackToNormalQueueSize(this.backToNormalSipMessageQueueSize);
        this.sipApplicationDispatcher.setGatherStatistics(this.gatherStatistics);
        this.sipApplicationDispatcher.setConcurrencyControlMode(ConcurrencyControlMode.valueOf((String)this.getConcurrencyControlMode()));
        this.sipApplicationDispatcher.setBypassRequestExecutor(this.bypassRequestExecutor);
        this.sipApplicationDispatcher.setBypassResponseExecutor(this.bypassResponseExecutor);
        this.sipApplicationDispatcher.setSipStack(this.sipStack);
        this.sipApplicationDispatcher.init();
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (Connector connector : this.connectors) {
                ProtocolHandler protocolHandler = connector.getProtocolHandler();
                if (!(protocolHandler instanceof SipProtocolHandler)) continue;
                connector.setPort(((SipProtocolHandler)protocolHandler).getPort());
                ((SipProtocolHandler)protocolHandler).setSipStack(this.sipStack);
                ((SipProtocolHandler)protocolHandler).setAttribute(SipApplicationDispatcher.class.getSimpleName(), this.sipApplicationDispatcher);
                this.registerSipConnector(connector);
            }
            // ** MonitorExit[var2_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startInternal() throws LifecycleException {
        super.startInternal();
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (Connector connector : this.connectors) {
                ProtocolHandler protocolHandler = connector.getProtocolHandler();
                Boolean isSipConnector = false;
                if (protocolHandler instanceof SipProtocolHandler) {
                    isSipConnector = (Boolean)((SipProtocolHandler)protocolHandler).getAttribute("isSipConnector");
                }
                if (isSipConnector != null && isSipConnector.booleanValue()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Attaching the sip application dispatcher as a sip listener to connector listening on port " + connector.getPort()));
                    }
                    ((SipProtocolHandler)protocolHandler).setAttribute(SipApplicationDispatcher.class.getSimpleName(), this.sipApplicationDispatcher);
                    ((SipProtocolHandler)protocolHandler).setSipStack(this.sipStack);
                    this.connectorsStartedExternally = true;
                }
                MobicentsExtendedListeningPoint extendedListeningPoint = null;
                if (protocolHandler instanceof SipProtocolHandler) {
                    extendedListeningPoint = (MobicentsExtendedListeningPoint)((SipProtocolHandler)protocolHandler).getAttribute(ExtendedListeningPoint.class.getSimpleName());
                }
                if (extendedListeningPoint == null || this.sipStack == null) continue;
                try {
                    extendedListeningPoint.getSipProvider().addSipListener((SipListener)this.sipApplicationDispatcher);
                    this.sipApplicationDispatcher.getSipNetworkInterfaceManager().addExtendedListeningPoint(extendedListeningPoint);
                    this.connectorsStartedExternally = false;
                }
                catch (TooManyListenersException e) {
                    throw new LifecycleException("Couldn't add the sip application dispatcher " + this.sipApplicationDispatcher + " as a listener to the following listening point provider " + extendedListeningPoint, (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!this.connectorsStartedExternally) {
                this.sipApplicationDispatcher.start();
            }
            if (this.getSipMessageQueueSize() <= 0) {
                throw new LifecycleException("Message queue size can not be 0 or less");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SIP Standard Service Started.");
            }
            return;
        }
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void initSipStack() throws LifecycleException {
        try {
            if (SipStandardService.logger.isDebugEnabled()) {
                SipStandardService.logger.debug((Object)"Initializing SIP stack");
            }
            this.initializeSystemPortProperties();
            catalinaBase = this.getCatalinaBase();
            if (this.sipStackPropertiesFileLocation != null && !this.sipStackPropertiesFileLocation.startsWith("file:///")) {
                this.sipStackPropertiesFileLocation = "file:///" + catalinaBase.replace(File.separatorChar, '/') + "/" + this.sipStackPropertiesFileLocation;
            }
            isPropsLoaded = false;
            if (this.sipStackProperties == null) {
                this.sipStackProperties = new Properties();
            } else {
                isPropsLoaded = true;
            }
            if (SipStandardService.logger.isDebugEnabled()) {
                SipStandardService.logger.debug((Object)("Loading SIP stack properties from following file : " + this.sipStackPropertiesFileLocation));
            }
            if (this.sipStackPropertiesFileLocation != null) {
                sipStackPropertiesFile = null;
                url = null;
                try {
                    url = new URL(this.sipStackPropertiesFileLocation);
                }
                catch (MalformedURLException e) {
                    SipStandardService.logger.fatal((Object)"Cannot find the sip stack properties file ! ", (Throwable)e);
                    throw new IllegalArgumentException("The Default Application Router file Location : " + this.sipStackPropertiesFileLocation + " is not valid ! ", e);
                }
                try {
                    sipStackPropertiesFile = new File(new URI(this.sipStackPropertiesFileLocation));
                }
                catch (URISyntaxException e) {
                    sipStackPropertiesFile = new File(url.getPath());
                }
                sipStackPropertiesInputStream = null;
                try {
                    sipStackPropertiesInputStream = new FileInputStream(sipStackPropertiesFile);
                    this.sipStackProperties.load(sipStackPropertiesInputStream);
                }
                catch (Exception e) {
                    SipStandardService.logger.warn((Object)("Could not find or problem when loading the sip stack properties file : " + this.sipStackPropertiesFileLocation), (Throwable)e);
                }
                finally {
                    if (sipStackPropertiesInputStream != null) {
                        try {
                            sipStackPropertiesInputStream.close();
                        }
                        catch (IOException e) {
                            SipStandardService.logger.error((Object)("fail to close the following file " + sipStackPropertiesFile.getAbsolutePath()), (Throwable)e);
                        }
                    }
                }
                debugLog = this.sipStackProperties.getProperty("gov.nist.javax.sip.DEBUG_LOG");
                if (debugLog != null && debugLog.length() > 0 && !debugLog.startsWith("file:///")) {
                    this.sipStackProperties.setProperty("gov.nist.javax.sip.DEBUG_LOG", catalinaBase + "/" + debugLog);
                }
                if ((serverLog = this.sipStackProperties.getProperty("gov.nist.javax.sip.SERVER_LOG")) != null && serverLog.length() > 0 && !serverLog.startsWith("file:///")) {
                    this.sipStackProperties.setProperty("gov.nist.javax.sip.SERVER_LOG", catalinaBase + "/" + serverLog);
                }
                if (this.sipStackProperties.getProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT") == null) {
                    this.sipStackProperties.setProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", "off");
                }
                this.sipStackProperties.setProperty("gov.nist.javax.sip.LOOSE_DIALOG_VALIDATION", "true");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER", "true");
                isPropsLoaded = true;
            } else {
                SipStandardService.logger.warn((Object)"no sip stack properties file defined ");
            }
            if (!isPropsLoaded) {
                SipStandardService.logger.warn((Object)"loading default Mobicents Sip Servlets sip stack properties");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT", "true");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "32");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.DEBUG_LOG", catalinaBase + "/" + "mss-jsip-" + this.getName() + "-debug.txt");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.SERVER_LOG", catalinaBase + "/" + "mss-jsip-" + this.getName() + "-messages.xml");
                this.sipStackProperties.setProperty("javax.sip.STACK_NAME", "mss-" + this.getName());
                this.sipStackProperties.setProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", "off");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.DELIVER_UNSOLICITED_NOTIFY", "true");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", "64");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.REENTRANT_LISTENER", "true");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.MAX_FORK_TIME_SECONDS", "0");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.LOOSE_DIALOG_VALIDATION", "true");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER", "true");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.AUTOMATIC_DIALOG_ERROR_HANDLING", "false");
                this.sipStackProperties.setProperty("gov.nist.javax.sip.AGGRESSIVE_CLEANUP", "true");
            }
            if (this.sipStackProperties.get("gov.nist.javax.sip.TCP_POST_PARSING_THREAD_POOL_SIZE") == null) {
                this.sipStackProperties.setProperty("gov.nist.javax.sip.TCP_POST_PARSING_THREAD_POOL_SIZE", "30");
            }
            if (this.dnsServerLocatorClass != null && this.dnsServerLocatorClass.trim().length() > 0) {
                if (SipStandardService.logger.isDebugEnabled()) {
                    SipStandardService.logger.debug((Object)("Sip Stack " + this.sipStackProperties.getProperty("javax.sip.STACK_NAME") + " will be using " + this.dnsServerLocatorClass + " as DNSServerLocator"));
                }
                try {
                    paramTypes = new Class[]{};
                    dnsServerLocatorConstructor = Class.forName(this.dnsServerLocatorClass).getConstructor(paramTypes);
                    conArgs = new Object[]{};
                    dnsServerLocator = (DNSServerLocator)dnsServerLocatorConstructor.newInstance(conArgs);
                    this.sipApplicationDispatcher.setDNSServerLocator(dnsServerLocator);
                    this.sipApplicationDispatcher.setDNSTimeout(this.dnsTimeout);
                    if (this.sipStackProperties.getProperty("javax.sip.ROUTER_PATH") != null) ** GOTO lbl115
                    this.sipStackProperties.setProperty("javax.sip.ROUTER_PATH", DNSAwareRouter.class.getCanonicalName());
                }
                catch (Exception e) {
                    SipStandardService.logger.error((Object)("Couldn't set the AddressResolver " + this.addressResolverClass), (Throwable)e);
                    throw e;
                }
            } else if (SipStandardService.logger.isInfoEnabled()) {
                SipStandardService.logger.info((Object)"no DNSServerLocator will be used since none has been specified.");
            }
lbl115:
            // 5 sources

            serverHeaderValue = this.sipStackProperties.getProperty("org.mobicents.servlet.sip.SERVER_HEADER");
            if (serverHeaderValue != null) {
                serverHeaderList = new ArrayList<String>();
                stringTokenizer = new StringTokenizer(serverHeaderValue, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    serverHeaderList.add(stringTokenizer.nextToken());
                }
                serverHeader = this.sipApplicationDispatcher.getSipFactory().getHeaderFactory().createServerHeader(serverHeaderList);
                ((MessageFactoryExt)this.sipApplicationDispatcher.getSipFactory().getMessageFactory()).setDefaultServerHeader(serverHeader);
            }
            if ((userAgent = this.sipStackProperties.getProperty("org.mobicents.servlet.sip.USER_AGENT_HEADER")) != null) {
                userAgentList = new ArrayList<String>();
                stringTokenizer = new StringTokenizer(userAgent, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    userAgentList.add(stringTokenizer.nextToken());
                }
                userAgentHeader = this.sipApplicationDispatcher.getSipFactory().getHeaderFactory().createUserAgentHeader(userAgentList);
                ((MessageFactoryExt)this.sipApplicationDispatcher.getSipFactory().getMessageFactory()).setDefaultUserAgentHeader(userAgentHeader);
            }
            if (this.balancers != null) {
                if (this.sipStackProperties.get("org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName") == null) {
                    this.sipStackProperties.put("org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName", LoadBalancerHeartBeatingServiceImpl.class.getCanonicalName());
                }
                if (this.sipStackProperties.get("org.mobicents.ha.javax.sip.BALANCERS") == null) {
                    this.sipStackProperties.put("org.mobicents.ha.javax.sip.BALANCERS", this.balancers);
                }
            }
            if ((replicationStrategyString = this.sipStackProperties.getProperty("org.mobicents.ha.javax.sip.REPLICATION_STRATEGY")) == null) {
                replicationStrategyString = ReplicationStrategy.ConfirmedDialog.toString();
            }
            replicateApplicationData = false;
            if (replicationStrategyString.equals(ReplicationStrategy.EarlyDialog.toString())) {
                replicateApplicationData = true;
            }
            if (replicationStrategyString != null) {
                this.replicationStrategy = ReplicationStrategy.valueOf((String)replicationStrategyString);
            }
            this.sipStackProperties.put("org.mobicents.ha.javax.sip.REPLICATION_STRATEGY", replicationStrategyString);
            this.sipStackProperties.put("org.mobicents.ha.javax.sip.REPLICATE_APPLICATION_DATA", Boolean.valueOf(replicateApplicationData).toString());
            if (SipStandardService.logger.isInfoEnabled()) {
                SipStandardService.logger.info((Object)("Mobicents Sip Servlets sip stack properties : " + this.sipStackProperties));
            }
            this.sipStack = this.sipApplicationDispatcher.getSipFactory().getJainSipFactory().createSipStack(this.sipStackProperties);
            loadBalancerHeartBeatingService = null;
            if (this.sipStack instanceof ClusteredSipStack) {
                loadBalancerHeartBeatingService = ((ClusteredSipStack)this.sipStack).getLoadBalancerHeartBeatingService();
                if (this.container != null && this.container instanceof Engine && ((Engine)this.container).getJvmRoute() != null && (jvmRoute = ((Engine)this.container).getJvmRoute()) != null) {
                    loadBalancerHeartBeatingService.setJvmRoute(jvmRoute);
                    this.setJvmRoute(jvmRoute);
                }
            }
            if (this.sipApplicationDispatcher != null && loadBalancerHeartBeatingService != null && this.sipApplicationDispatcher instanceof LoadBalancerHeartBeatingListener) {
                loadBalancerHeartBeatingService.addLoadBalancerHeartBeatingListener((LoadBalancerHeartBeatingListener)this.sipApplicationDispatcher);
            }
            if (this.sipStack instanceof SipStackExt && this.addressResolverClass != null && this.addressResolverClass.trim().length() > 0) {
                if (SipStandardService.logger.isDebugEnabled()) {
                    SipStandardService.logger.debug((Object)("Sip Stack " + this.sipStack.getStackName() + " will be using " + this.addressResolverClass + " as AddressResolver"));
                }
                try {
                    paramTypes = new Class[]{SipApplicationDispatcher.class};
                    addressResolverConstructor = Class.forName(this.addressResolverClass).getConstructor(paramTypes);
                    conArgs = new Object[]{this.sipApplicationDispatcher};
                    addressResolver = (AddressResolver)addressResolverConstructor.newInstance(conArgs);
                    ((SipStackExt)this.sipStack).setAddressResolver(addressResolver);
                }
                catch (Exception e) {
                    SipStandardService.logger.error((Object)("Couldn't set the AddressResolver " + this.addressResolverClass), (Throwable)e);
                    throw e;
                }
            } else if (SipStandardService.logger.isInfoEnabled()) {
                SipStandardService.logger.info((Object)"no AddressResolver will be used since none has been specified.");
            }
            if (SipStandardService.logger.isInfoEnabled()) {
                SipStandardService.logger.info((Object)"SIP stack initialized");
            }
        }
        catch (Exception ex) {
            throw new LifecycleException("A problem occured while initializing the SIP Stack", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopInternal() throws LifecycleException {
        super.stopInternal();
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (Connector connector : this.connectors) {
                MobicentsExtendedListeningPoint extendedListeningPoint = null;
                if (connector.getProtocolHandler() instanceof SipProtocolHandler) {
                    extendedListeningPoint = (MobicentsExtendedListeningPoint)((SipProtocolHandler)connector.getProtocolHandler()).getAttribute(ExtendedListeningPoint.class.getSimpleName());
                }
                if (extendedListeningPoint == null) continue;
                extendedListeningPoint.getSipProvider().removeSipListener((SipListener)this.sipApplicationDispatcher);
                this.sipApplicationDispatcher.getSipNetworkInterfaceManager().removeExtendedListeningPoint(extendedListeningPoint);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!this.connectorsStartedExternally) {
                this.sipApplicationDispatcher.stop();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SIP Standard Service Stopped.");
            }
            return;
        }
    }

    public String getSipApplicationDispatcherClassName() {
        return this.sipApplicationDispatcherClassName;
    }

    public void setSipApplicationDispatcherClassName(String sipApplicationDispatcherName) {
        this.sipApplicationDispatcherClassName = sipApplicationDispatcherName;
    }

    public SipApplicationDispatcher getSipApplicationDispatcher() {
        return this.sipApplicationDispatcher;
    }

    public void setSipApplicationDispatcher(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
    }

    public String getDarConfigurationFileLocation() {
        return this.darConfigurationFileLocation;
    }

    public void setDarConfigurationFileLocation(String darConfigurationFileLocation) {
        this.darConfigurationFileLocation = darConfigurationFileLocation;
    }

    public int getSipMessageQueueSize() {
        return this.sipMessageQueueSize;
    }

    public void setSipMessageQueueSize(int sipMessageQueueSize) {
        this.sipMessageQueueSize = sipMessageQueueSize;
    }

    public String getConcurrencyControlMode() {
        return this.concurrencyControlMode;
    }

    public void setConcurrencyControlMode(String concurrencyControlMode) {
        this.concurrencyControlMode = concurrencyControlMode;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setGatherStatistics(boolean skipStatistics) {
        this.gatherStatistics = skipStatistics;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Gathering Statistics set to " + skipStatistics));
        }
    }

    public boolean isGatherStatistics() {
        return this.gatherStatistics;
    }

    public boolean getGatherStatistics() {
        return this.gatherStatistics;
    }

    public void setBackToNormalMemoryThreshold(int backToNormalMemoryThreshold) {
        this.backToNormalMemoryThreshold = backToNormalMemoryThreshold;
    }

    public int getBackToNormalMemoryThreshold() {
        return this.backToNormalMemoryThreshold;
    }

    public void setBackToNormalSipMessageQueueSize(int backToNormalSipMessageQueueSize) {
        this.backToNormalSipMessageQueueSize = backToNormalSipMessageQueueSize;
    }

    public int getBackToNormalSipMessageQueueSize() {
        return this.backToNormalSipMessageQueueSize;
    }

    public void setCongestionControlPolicy(String congestionControlPolicy) {
        this.congestionControlPolicy = congestionControlPolicy;
    }

    public String getCongestionControlPolicy() {
        return this.congestionControlPolicy;
    }

    public void setCongestionControlCheckingInterval(long congestionControlCheckingInterval) {
        this.congestionControlCheckingInterval = congestionControlCheckingInterval;
    }

    public long getCongestionControlCheckingInterval() {
        return this.congestionControlCheckingInterval;
    }

    public String getAdditionalParameterableHeaders() {
        return this.additionalParameterableHeaders;
    }

    public void setAdditionalParameterableHeaders(String additionalParameterableHeaders) {
        String[] headers;
        this.additionalParameterableHeaders = additionalParameterableHeaders;
        for (String header : headers = additionalParameterableHeaders.split(",")) {
            if (header == null || header.length() <= 0) continue;
            JainSipUtils.PARAMETERABLE_HEADER_NAMES.add(header);
        }
    }

    public boolean isBypassResponseExecutor() {
        return this.bypassResponseExecutor;
    }

    public void setBypassResponseExecutor(boolean bypassResponseExecutor) {
        this.bypassResponseExecutor = bypassResponseExecutor;
    }

    public boolean isBypassRequestExecutor() {
        return this.bypassRequestExecutor;
    }

    public void setBypassRequestExecutor(boolean bypassRequestExecutor) {
        this.bypassRequestExecutor = bypassRequestExecutor;
    }

    public boolean isMd5ContactUserPart() {
        return this.md5ContactUserPart;
    }

    public void setMd5ContactUserPart(boolean md5ContactUserPart) {
        this.md5ContactUserPart = md5ContactUserPart;
    }

    public void setUsePrettyEncoding(boolean usePrettyEncoding) {
        this.usePrettyEncoding = usePrettyEncoding;
    }

    public boolean isUsePrettyEncoding() {
        return this.usePrettyEncoding;
    }

    public void setSipPathName(String sipPathName) {
        this.sipPathName = sipPathName;
    }

    public String getSipPathName() {
        return this.sipPathName;
    }

    public void setBaseTimerInterval(int baseTimerInterval) {
        this.baseTimerInterval = baseTimerInterval;
    }

    public int getBaseTimerInterval() {
        return this.baseTimerInterval;
    }

    public OutboundProxy getOutboundProxy() {
        return this.outboundProxy;
    }

    public void setOutboundProxy(String outboundProxy) {
        this.outboundProxy = outboundProxy != null ? new OutboundProxy(outboundProxy) : null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Outbound Proxy : " + outboundProxy));
        }
    }

    public int getDispatcherThreadPoolSize() {
        return this.dispatcherThreadPoolSize;
    }

    public void setDispatcherThreadPoolSize(int dispatcherThreadPoolSize) {
        this.dispatcherThreadPoolSize = dispatcherThreadPoolSize;
    }

    public int getCanceledTimerTasksPurgePeriod() {
        return this.canceledTimerTasksPurgePeriod;
    }

    public void setCanceledTimerTasksPurgePeriod(int purgePeriod) {
        this.canceledTimerTasksPurgePeriod = purgePeriod;
    }

    public void setBalancers(String balancers) {
        this.balancers = balancers;
    }

    public boolean addSipConnector(SipConnector sipConnector) throws Exception {
        if (sipConnector == null) {
            throw new IllegalArgumentException("The sip connector passed is null");
        }
        Connector connectorToAdd = this.findSipConnector(sipConnector.getIpAddress(), sipConnector.getPort(), sipConnector.getTransport());
        if (connectorToAdd == null) {
            Connector connector = new Connector(SipProtocolHandler.class.getName());
            SipProtocolHandler sipProtocolHandler = (SipProtocolHandler)connector.getProtocolHandler();
            sipProtocolHandler.setSipConnector(sipConnector);
            sipProtocolHandler.setSipStack(this.sipStack);
            connector.setService((Service)this);
            connector.init();
            this.addConnector(connector);
            MobicentsExtendedListeningPoint extendedListeningPoint = (MobicentsExtendedListeningPoint)sipProtocolHandler.getAttribute(ExtendedListeningPoint.class.getSimpleName());
            if (extendedListeningPoint != null) {
                try {
                    extendedListeningPoint.getSipProvider().addSipListener((SipListener)this.sipApplicationDispatcher);
                    this.sipApplicationDispatcher.getSipNetworkInterfaceManager().addExtendedListeningPoint(extendedListeningPoint);
                }
                catch (TooManyListenersException e) {
                    logger.error((Object)"Connector.initialize", (Throwable)e);
                    this.removeConnector(connector);
                    return false;
                }
            }
            if (!sipProtocolHandler.isStarted()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Sip Connector couldn't be started, removing it automatically");
                }
                this.removeConnector(connector);
            }
            return sipProtocolHandler.isStarted();
        }
        return false;
    }

    public boolean removeSipConnector(String ipAddress, int port, String transport) throws Exception {
        Connector connectorToRemove = this.findSipConnector(ipAddress, port, transport);
        if (connectorToRemove != null) {
            this.removeConnector(connectorToRemove);
            return true;
        }
        return false;
    }

    private Connector findSipConnector(String ipAddress, int port, String transport) {
        Connector connectorToRemove = null;
        for (Connector connector : this.connectors) {
            SipProtocolHandler sipProtocolHandler;
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            if (!(protocolHandler instanceof SipProtocolHandler) || !(sipProtocolHandler = (SipProtocolHandler)protocolHandler).getIpAddress().equals(ipAddress) || sipProtocolHandler.getPort() != port || !sipProtocolHandler.getSignalingTransport().equalsIgnoreCase(transport)) continue;
            connectorToRemove = connector;
            break;
        }
        return connectorToRemove;
    }

    public SipConnector findSipConnector(String transport) {
        ArrayList sipConnectors = new ArrayList();
        for (Connector connector : this.connectors) {
            SipConnector sc;
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            if (!(protocolHandler instanceof SipProtocolHandler) || !(sc = ((SipProtocolHandler)protocolHandler).getSipConnector()).getTransport().equalsIgnoreCase(transport)) continue;
            return sc;
        }
        return null;
    }

    public SipConnector[] findSipConnectors() {
        ArrayList<SipConnector> sipConnectors = new ArrayList<SipConnector>();
        for (Connector connector : this.connectors) {
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            if (!(protocolHandler instanceof SipProtocolHandler)) continue;
            sipConnectors.add(((SipProtocolHandler)protocolHandler).getSipConnector());
        }
        return sipConnectors.toArray(new SipConnector[sipConnectors.size()]);
    }

    public void initializeSystemPortProperties() {
        for (Connector connector : this.connectors) {
            if (!connector.getProtocol().contains("HTTP")) continue;
            if (connector.getSecure()) {
                System.setProperty("org.mobicents.properties.sslPort", Integer.toString(connector.getPort()));
                continue;
            }
            System.setProperty("org.mobicents.properties.httpPort", Integer.toString(connector.getPort()));
        }
    }

    protected ObjectName createSipConnectorObjectName(Connector connector, String domain, String type) throws MalformedObjectNameException {
        String encodedAddr = null;
        if (connector.getProperty("address") != null) {
            encodedAddr = URLEncoder.encode(connector.getProperty("address").toString());
        }
        String addSuffix = connector.getProperty("address") == null ? "" : ",address=" + encodedAddr;
        ObjectName _oname = new ObjectName(domain + ":type=" + type + ",port=" + connector.getPort() + ",transport=" + connector.getProperty("transport") + addSuffix);
        return _oname;
    }

    public void setT2Interval(int t2Interval) {
        this.t2Interval = t2Interval;
    }

    public int getT2Interval() {
        return this.t2Interval;
    }

    public void setT4Interval(int t4Interval) {
        this.t4Interval = t4Interval;
    }

    public int getT4Interval() {
        return this.t4Interval;
    }

    public void setTimerDInterval(int timerDInterval) {
        this.timerDInterval = timerDInterval;
    }

    public int getTimerDInterval() {
        return this.timerDInterval;
    }

    public void setSipStackPropertiesFile(String sipStackPropertiesFile) {
        this.sipStackPropertiesFileLocation = sipStackPropertiesFile;
    }

    public Properties getSipStackProperties() {
        return this.sipStackProperties;
    }

    public void setSipStackProperties(Properties sipStackProperties) {
        this.sipStackProperties = sipStackProperties;
    }

    public String getSipStackPropertiesFile() {
        return this.sipStackPropertiesFileLocation;
    }

    @Deprecated
    public void setAddressResolverClass(String dnsAddressResolverClass) {
        this.addressResolverClass = dnsAddressResolverClass;
    }

    @Deprecated
    public String getAddressResolverClass() {
        return this.addressResolverClass;
    }

    public boolean isDialogPendingRequestChecking() {
        return this.dialogPendingRequestChecking;
    }

    public void setDialogPendingRequestChecking(boolean dialogPendingRequestChecking) {
        this.dialogPendingRequestChecking = dialogPendingRequestChecking;
    }

    public boolean isHttpFollowsSip() {
        return this.httpFollowsSip;
    }

    public void setHttpFollowsSip(boolean httpFollowsSip) {
        this.httpFollowsSip = httpFollowsSip;
    }

    public int getTagHashMaxLength() {
        return this.tagHashMaxLength;
    }

    public void setTagHashMaxLength(int tagHashMaxLength) {
        this.tagHashMaxLength = tagHashMaxLength;
    }

    public int getCallIdMaxLength() {
        return this.callIdMaxLength;
    }

    public void setCallIdMaxLength(int callIdMaxLength) {
        this.callIdMaxLength = callIdMaxLength;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public void setDnsServerLocatorClass(String dnsServerLocatorClass) {
        this.dnsServerLocatorClass = dnsServerLocatorClass;
    }

    public String getDnsServerLocatorClass() {
        return this.dnsServerLocatorClass;
    }

    public void setDnsResolverClass(String dnsResolverClass) {
        this.dnsResolverClass = dnsResolverClass;
    }

    public String getDnsResolverClass() {
        return this.dnsResolverClass;
    }

    protected String getCatalinaBase() {
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaBase == null) {
            catalinaBase = System.getProperty("catalina.home");
        }
        if (catalinaBase == null) {
            catalinaBase = ".";
        }
        return catalinaBase;
    }

    public ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public String getMobicentsSipServletMessageFactoryClassName() {
        return this.mobicentsSipServletMessageFactoryClassName;
    }

    public void setMobicentsSipServletMessageFactoryClassName(String mobicentsSipServletMessageFactoryClassName) {
        this.mobicentsSipServletMessageFactoryClassName = mobicentsSipServletMessageFactoryClassName;
    }

    public void sendHeartBeat(String localAddress, int localPort, String transport, String remoteIpAddress, int remotePort) throws IOException {
        MobicentsExtendedListeningPoint extendedListeningPoint = this.sipApplicationDispatcher.getSipNetworkInterfaceManager().findMatchingListeningPoint(localAddress, localPort, transport);
        if (extendedListeningPoint != null) {
            extendedListeningPoint.getListeningPoint().sendHeartbeat(remoteIpAddress, remotePort);
        }
    }

    public boolean setKeepAliveTimeout(SipConnector sipConnector, String clientAddress, int clientPort, long timeout) {
        SIPTransactionStack sipStack = (SIPTransactionStack)this.sipApplicationDispatcher.getSipStack();
        return sipStack.setKeepAliveTimeout(sipConnector.getIpAddress(), sipConnector.getPort(), sipConnector.getTransport(), clientAddress, clientPort, timeout);
    }

    public void closeReliableConnection(SipConnector sipConnector, String clientAddress, int clientPort) {
        SIPTransactionStack sipStack = (SIPTransactionStack)this.sipApplicationDispatcher.getSipStack();
        sipStack.closeReliableConnection(sipConnector.getIpAddress(), sipConnector.getPort(), sipConnector.getTransport(), clientAddress, clientPort);
    }

    public void stopGracefully(long timeToWait) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Stopping the Server Gracefully in " + timeToWait + " ms"));
        }
        if (timeToWait == 0L) {
            if (this.gracefulStopFuture != null) {
                this.gracefulStopFuture.cancel(false);
            }
            try {
                this.getServer().stop();
            }
            catch (LifecycleException e) {
                logger.error((Object)"The server couldn't be stopped", (Throwable)e);
            }
        } else {
            this.sipApplicationDispatcher.setGracefulShutdown(true);
            Iterator sipContexts = this.sipApplicationDispatcher.findSipApplications();
            while (sipContexts.hasNext()) {
                SipContext sipContext = (SipContext)sipContexts.next();
                sipContext.stopGracefully(timeToWait);
            }
            this.gracefulStopFuture = this.sipApplicationDispatcher.getAsynchronousScheduledExecutor().scheduleWithFixedDelay(new ServiceGracefulStopTask(this), 30000L, 30000L, TimeUnit.MILLISECONDS);
            if (timeToWait > 0L) {
                this.gracefulStopFuture = this.sipApplicationDispatcher.getAsynchronousScheduledExecutor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        SipStandardService.this.gracefulStopFuture.cancel(false);
                        try {
                            SipStandardService.this.getServer().stop();
                        }
                        catch (LifecycleException e) {
                            logger.error((Object)"The server couldn't be stopped", (Throwable)e);
                        }
                    }
                }, timeToWait, TimeUnit.MILLISECONDS);
            }
        }
    }

    public int getDnsTimeout() {
        return this.dnsTimeout;
    }

    public void setDnsTimeout(int dnsTimeout) {
        this.dnsTimeout = dnsTimeout;
    }

    public String getProxyTimerServiceImplementationType() {
        return this.proxyTimerServiceImplementationType;
    }

    public void setProxyTimerServiceImplementationType(String proxyTimerServiceImplementationType) {
        this.proxyTimerServiceImplementationType = proxyTimerServiceImplementationType;
    }

    public String getSasTimerServiceImplementationType() {
        return this.sasTimerServiceImplementationType;
    }

    public void setSasTimerServiceImplementationType(String sasTimerServiceImplementationType) {
        this.sasTimerServiceImplementationType = sasTimerServiceImplementationType;
    }
}

