/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina;

import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.management.ObjectName;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.modeler.Registry;
import org.mobicents.servlet.sip.catalina.CatalinaSipContext;
import org.mobicents.servlet.sip.catalina.CatalinaSipManager;
import org.mobicents.servlet.sip.catalina.session.ConvergedStandardSession;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipManagerDelegate;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.core.session.SipStandardManagerDelegate;
import org.mobicents.servlet.sip.message.SipFactoryImpl;

public class SipStandardManager
extends StandardManager
implements CatalinaSipManager {
    private static final Logger logger = Logger.getLogger(SipStandardManager.class);
    private SipManagerDelegate sipManagerDelegate = new SipStandardManagerDelegate();
    protected static final String INFO = "SipStandardManager/1.0";
    protected static final String NAME = "SipStandardManager";

    public void initInternal() throws LifecycleException {
        if (this.getState().equals((Object)LifecycleState.INITIALIZED)) {
            return;
        }
        super.initInternal();
        ObjectName oname = super.getObjectName();
        if (oname == null && this.getContainer() instanceof SipContext) {
            CatalinaSipContext ctx = (CatalinaSipContext)this.getContainer();
            String domain = ctx.getEngineName();
            this.distributable = ctx.getDistributable();
            StandardHost hst = (StandardHost)ctx.getParent();
            String path = ctx.getPath();
            if (path.equals("")) {
                path = "/";
            }
            String objectNameString = domain + ":type=SipManager,path=" + path + ",host=" + hst.getName();
            try {
                oname = new ObjectName(objectNameString);
                Registry.getRegistry(null, null).registerComponent((Object)this, oname, null);
            }
            catch (Exception e) {
                throw new IllegalStateException("error registering the mbean " + objectNameString, e);
            }
        }
    }

    protected StandardSession getNewSession() {
        if (this.container instanceof SipContext) {
            return new ConvergedStandardSession(this);
        }
        return super.getNewSession();
    }

    public MobicentsSipFactory getMobicentsSipFactory() {
        return this.sipManagerDelegate.getSipFactoryImpl();
    }

    public void setMobicentsSipFactory(MobicentsSipFactory sipFactoryImpl) {
        this.sipManagerDelegate.setSipFactoryImpl((SipFactoryImpl)sipFactoryImpl);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.container = container;
        if (container instanceof SipContext) {
            this.sipManagerDelegate.setContainer((SipContext)container);
        }
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public MobicentsSipSession removeSipSession(MobicentsSipSessionKey key) {
        return this.sipManagerDelegate.removeSipSession(key);
    }

    public MobicentsSipApplicationSession removeSipApplicationSession(MobicentsSipApplicationSessionKey key) {
        return this.sipManagerDelegate.removeSipApplicationSession(key);
    }

    public MobicentsSipApplicationSession getSipApplicationSession(MobicentsSipApplicationSessionKey key, boolean create) {
        return this.sipManagerDelegate.getSipApplicationSession((SipApplicationSessionKey)key, create);
    }

    public MobicentsSipSession getSipSession(MobicentsSipSessionKey key, boolean create, MobicentsSipFactory sipFactoryImpl, MobicentsSipApplicationSession sipApplicationSessionImpl) {
        return this.sipManagerDelegate.getSipSession((SipSessionKey)key, create, (SipFactoryImpl)sipFactoryImpl, sipApplicationSessionImpl);
    }

    public Iterator<MobicentsSipSession> getAllSipSessions() {
        return this.sipManagerDelegate.getAllSipSessions();
    }

    public Iterator<MobicentsSipApplicationSession> getAllSipApplicationSessions() {
        return this.sipManagerDelegate.getAllSipApplicationSessions();
    }

    public MobicentsSipApplicationSession findSipApplicationSession(HttpSession httpSession) {
        return this.sipManagerDelegate.findSipApplicationSession(httpSession);
    }

    public void dumpSipSessions() {
        this.sipManagerDelegate.dumpSipSessions();
    }

    public void dumpSipApplicationSessions() {
        this.sipManagerDelegate.dumpSipApplicationSessions();
    }

    public void removeAllSessions() {
        this.sipManagerDelegate.removeAllSessions();
    }

    public String getInfo() {
        return INFO;
    }

    public String getName() {
        return NAME;
    }

    public int getMaxActiveSipSessions() {
        return this.sipManagerDelegate.getMaxActiveSipSessions();
    }

    public void setMaxActiveSipSessions(int max) {
        int oldMaxActiveSipSessions = this.sipManagerDelegate.getMaxActiveSipSessions();
        this.sipManagerDelegate.setMaxActiveSipSessions(max);
        this.support.firePropertyChange("maxActiveSipSessions", (Object)oldMaxActiveSipSessions, (Object)this.sipManagerDelegate.getMaxActiveSipSessions());
    }

    public int getMaxActiveSipApplicationSessions() {
        return this.sipManagerDelegate.getMaxActiveSipApplicationSessions();
    }

    public void setMaxActiveSipApplicationSessions(int max) {
        int oldMaxActiveSipApplicationSessions = this.sipManagerDelegate.getMaxActiveSipApplicationSessions();
        this.sipManagerDelegate.setMaxActiveSipApplicationSessions(max);
        this.support.firePropertyChange("maxActiveSipApplicationSessions", (Object)oldMaxActiveSipApplicationSessions, (Object)this.sipManagerDelegate.getMaxActiveSipApplicationSessions());
    }

    public int getRejectedSipSessions() {
        return this.sipManagerDelegate.getRejectedSipSessions();
    }

    public void setRejectedSipSessions(int rejectedSipSessions) {
        this.sipManagerDelegate.setRejectedSipSessions(rejectedSipSessions);
    }

    public int getRejectedSipApplicationSessions() {
        return this.sipManagerDelegate.getRejectedSipApplicationSessions();
    }

    public void setRejectedSipApplicationSessions(int rejectedSipApplicationSessions) {
        this.sipManagerDelegate.setRejectedSipApplicationSessions(rejectedSipApplicationSessions);
    }

    public void setSipSessionCounter(int sipSessionCounter) {
        this.sipManagerDelegate.setSipSessionCounter(sipSessionCounter);
    }

    public int getSipSessionCounter() {
        return this.sipManagerDelegate.getSipSessionCounter();
    }

    public int getActiveSipSessions() {
        return this.sipManagerDelegate.getNumberOfSipSessions();
    }

    public int getSipSessionMaxAliveTime() {
        return this.sipManagerDelegate.getSipSessionMaxAliveTime();
    }

    public void setSipSessionMaxAliveTime(int sipSessionMaxAliveTime) {
        this.sipManagerDelegate.setSipSessionMaxAliveTime(sipSessionMaxAliveTime);
    }

    public int getSipSessionAverageAliveTime() {
        return this.sipManagerDelegate.getSipSessionAverageAliveTime();
    }

    public void setSipSessionAverageAliveTime(int sipSessionAverageAliveTime) {
        this.sipManagerDelegate.setSipSessionAverageAliveTime(sipSessionAverageAliveTime);
    }

    public void setSipApplicationSessionCounter(int sipApplicationSessionCounter) {
        this.sipManagerDelegate.setSipApplicationSessionCounter(sipApplicationSessionCounter);
    }

    public int getSipApplicationSessionCounter() {
        return this.sipManagerDelegate.getSipApplicationSessionCounter();
    }

    public int getActiveSipApplicationSessions() {
        return this.sipManagerDelegate.getNumberOfSipApplicationSessions();
    }

    public int getSipApplicationSessionMaxAliveTime() {
        return this.sipManagerDelegate.getSipApplicationSessionMaxAliveTime();
    }

    public void setSipApplicationSessionMaxAliveTime(int sipApplicationSessionMaxAliveTime) {
        this.sipManagerDelegate.setSipApplicationSessionMaxAliveTime(sipApplicationSessionMaxAliveTime);
    }

    public int getSipApplicationSessionAverageAliveTime() {
        return this.sipManagerDelegate.getSipApplicationSessionAverageAliveTime();
    }

    public void setSipApplicationSessionAverageAliveTime(int sipApplicationSessionAverageAliveTime) {
        this.sipManagerDelegate.setSipApplicationSessionAverageAliveTime(sipApplicationSessionAverageAliveTime);
    }

    public int getExpiredSipSessions() {
        return this.sipManagerDelegate.getExpiredSipSessions();
    }

    public void setExpiredSipSessions(int expiredSipSessions) {
        this.sipManagerDelegate.setExpiredSipSessions(expiredSipSessions);
    }

    public int getExpiredSipApplicationSessions() {
        return this.sipManagerDelegate.getExpiredSipApplicationSessions();
    }

    public void setExpiredSipApplicationSessions(int expiredSipApplicationSessions) {
        this.sipManagerDelegate.setExpiredSipApplicationSessions(expiredSipApplicationSessions);
    }

    public String listSipSessionIds() {
        StringBuffer sb = new StringBuffer();
        Iterator sipSessions = this.sipManagerDelegate.getAllSipSessions();
        while (sipSessions.hasNext()) {
            sb.append(((MobicentsSipSession)sipSessions.next()).getKey()).append(" ");
        }
        return sb.toString();
    }

    public String listSipApplicationSessionIds() {
        StringBuffer sb = new StringBuffer();
        Iterator sipApplicationSessions = this.sipManagerDelegate.getAllSipApplicationSessions();
        while (sipApplicationSessions.hasNext()) {
            sb.append(((MobicentsSipApplicationSession)sipApplicationSessions.next()).getKey()).append(" ");
        }
        return sb.toString();
    }

    public double getNumberOfSipApplicationSessionCreationPerSecond() {
        return this.sipManagerDelegate.getNumberOfSipApplicationSessionCreationPerSecond();
    }

    public double getNumberOfSipSessionCreationPerSecond() {
        return this.sipManagerDelegate.getNumberOfSipSessionCreationPerSecond();
    }

    public void updateStats() {
        this.sipManagerDelegate.updateStats();
    }

    @Override
    public void stopGracefully(long timeToWait) {
        this.sipManagerDelegate.getContainer().stopGracefully(timeToWait);
    }

    @Override
    public boolean isStoppingGracefully() {
        return this.sipManagerDelegate.getContainer().isStoppingGracefully();
    }
}

