/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina;

import gov.nist.javax.sip.ListeningPointExt;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sip.ListeningPoint;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import net.java.stun4j.StunAddress;
import net.java.stun4j.client.NetworkConfigurationDiscoveryProcess;
import net.java.stun4j.client.StunDiscoveryReport;
import org.apache.catalina.Executor;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.modeler.Registry;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingService;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;

public class SipProtocolHandler
implements ProtocolHandler,
MBeanRegistration {
    public static final String IS_SIP_CONNECTOR = "isSipConnector";
    private static final Logger logger = Logger.getLogger((String)SipProtocolHandler.class.getName());
    protected ObjectName tpOname = null;
    protected ObjectName rgOname = null;
    private static Random portNumberGenerator = new Random();
    private Adapter adapter = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private SipStack sipStack;
    public ExtendedListeningPoint extendedListeningPoint;
    private Properties sipStackProperties;
    private boolean started = false;
    private SipConnector sipConnector;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public SipProtocolHandler() {
        this.sipConnector = new SipConnector();
    }

    public SipProtocolHandler(SipConnector connector) {
        this.sipConnector = connector;
    }

    public void destroy() throws Exception {
        SipApplicationDispatcher sipApplicationDispatcher;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Stopping a sip protocol handler");
        }
        if ((sipApplicationDispatcher = (SipApplicationDispatcher)this.getAttribute(SipApplicationDispatcher.class.getSimpleName())) != null && this.extendedListeningPoint != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing the Sip Application Dispatcher as a sip listener for listening point " + this.extendedListeningPoint));
            }
            this.extendedListeningPoint.getSipProvider().removeSipListener((SipListener)sipApplicationDispatcher);
            sipApplicationDispatcher.getSipNetworkInterfaceManager().removeExtendedListeningPoint((MobicentsExtendedListeningPoint)this.extendedListeningPoint);
        }
        if (this.sipStack != null && this.extendedListeningPoint != null) {
            if (this.extendedListeningPoint.getSipProvider().getListeningPoints().length == 1) {
                this.sipStack.deleteSipProvider(this.extendedListeningPoint.getSipProvider());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Removing the sip provider");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removing the following Listening Point " + this.extendedListeningPoint + " from the sip provider"));
                }
                this.extendedListeningPoint.getSipProvider().removeListeningPoint((ListeningPoint)this.extendedListeningPoint.getListeningPoint());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing the following Listening Point " + this.extendedListeningPoint));
            }
            this.sipStack.deleteListeningPoint((ListeningPoint)this.extendedListeningPoint.getListeningPoint());
            if (this.sipConnector.isUseLoadBalancer() && this.sipStack instanceof ClusteredSipStack && ((ClusteredSipStack)this.sipStack).getLoadBalancerHeartBeatingService() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SipConnector " + this.extendedListeningPoint.getListeningPoint() + " remove to use Load Balancer for outbound traffic"));
                }
                LoadBalancerHeartBeatingService loadBalancerHeartBeatingService = ((ClusteredSipStack)this.sipStack).getLoadBalancerHeartBeatingService();
                loadBalancerHeartBeatingService.removeSipConnector((ListeningPoint)this.extendedListeningPoint.getListeningPoint(), this.extendedListeningPoint.getLoadBalancer());
            }
            this.extendedListeningPoint = null;
        }
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
        this.setStarted(false);
        this.sipStack = null;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void init() throws Exception {
        this.setAttribute(IS_SIP_CONNECTOR, Boolean.TRUE);
    }

    public void pause() throws Exception {
    }

    public void resume() throws Exception {
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public void setAttribute(String arg0, Object arg1) {
        this.attributes.put(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting a sip protocol handler");
        }
        Integer portFromConfig = this.sipConnector.getPort();
        String set = System.getProperty("jboss.service.binding.set");
        int setIncrememt = 0;
        if (set != null) {
            int setNumber = set.charAt(set.length() - 1) - 48;
            if (setNumber > 0 && setNumber < 10) {
                setIncrememt = setNumber * 100;
            }
            logger.info((Object)("Computed port increment for MSS SIP ports is " + setIncrememt + " from " + set));
        }
        portFromConfig = portFromConfig + setIncrememt;
        this.sipConnector.setPort(portFromConfig.intValue());
        String ipAddress = this.sipConnector.getIpAddress();
        int port = this.sipConnector.getPort();
        String signalingTransport = this.sipConnector.getTransport();
        try {
            String globalIpAddress = null;
            int globalPort = -1;
            boolean useStun = this.sipConnector.isUseStun();
            if (useStun) {
                if (InetAddress.getByName(ipAddress).isLoopbackAddress()) {
                    logger.warn((Object)"The Ip address provided is the loopback address, stun won't be enabled for it");
                } else {
                    DatagramSocket randomSocket = this.initRandomPortSocket();
                    int randomPort = randomSocket.getLocalPort();
                    randomSocket.disconnect();
                    randomSocket.close();
                    randomSocket = null;
                    StunAddress localStunAddress = new StunAddress(ipAddress, randomPort);
                    StunAddress serverStunAddress = new StunAddress(this.sipConnector.getStunServerAddress(), this.sipConnector.getStunServerPort());
                    NetworkConfigurationDiscoveryProcess addressDiscovery = new NetworkConfigurationDiscoveryProcess(localStunAddress, serverStunAddress);
                    addressDiscovery.start();
                    StunDiscoveryReport report = addressDiscovery.determineAddress();
                    if (report.getPublicAddress() != null) {
                        globalIpAddress = report.getPublicAddress().getSocketAddress().getAddress().getHostAddress();
                        globalPort = report.getPublicAddress().getPort();
                    } else {
                        useStun = false;
                        logger.error((Object)"Stun discovery failed to find a valid public ip address, disabling stun !");
                    }
                    logger.info((Object)("Stun report = " + report));
                    addressDiscovery.shutDown();
                }
            }
            ListeningPointExt listeningPoint = (ListeningPointExt)this.sipStack.createListeningPoint(ipAddress, port, signalingTransport);
            if (useStun) {
                listeningPoint.setSentBy(globalIpAddress + ":" + port);
            }
            boolean createSipProvider = false;
            SipProvider sipProvider = null;
            if (this.sipStack.getSipProviders().hasNext()) {
                sipProvider = (SipProvider)this.sipStack.getSipProviders().next();
                for (StunAddress listeningPointTemp : sipProvider.getListeningPoints()) {
                    if (listeningPointTemp.getIPAddress().equalsIgnoreCase(listeningPoint.getIPAddress()) && listeningPointTemp.getPort() == listeningPoint.getPort()) continue;
                    createSipProvider = true;
                    break;
                }
            } else {
                createSipProvider = true;
            }
            if (createSipProvider) {
                sipProvider = this.sipStack.createSipProvider((ListeningPoint)listeningPoint);
            } else {
                sipProvider.addListeningPoint((ListeningPoint)listeningPoint);
            }
            this.extendedListeningPoint = new ExtendedListeningPoint(sipProvider, listeningPoint, this.sipConnector);
            this.extendedListeningPoint.setUseStaticAddress(false);
            this.extendedListeningPoint.setGlobalIpAddress(globalIpAddress);
            this.extendedListeningPoint.setGlobalPort(globalPort);
            this.extendedListeningPoint.setUseLoadBalancer(this.sipConnector.isUseLoadBalancer());
            LoadBalancerHeartBeatingService loadBalancerHeartBeatingService = null;
            if (this.sipConnector.isUseLoadBalancer() && this.sipStack instanceof ClusteredSipStack && ((ClusteredSipStack)this.sipStack).getLoadBalancerHeartBeatingService() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SipConnector " + listeningPoint + " set to use Load Balancer for outbound traffic"));
                }
                loadBalancerHeartBeatingService = ((ClusteredSipStack)this.sipStack).getLoadBalancerHeartBeatingService();
                if (this.sipConnector.getLoadBalancerAddress() != null && loadBalancerHeartBeatingService != null) {
                    InetAddress loadBalancerAddress = null;
                    try {
                        loadBalancerAddress = InetAddress.getByName(this.sipConnector.getLoadBalancerAddress());
                    }
                    catch (UnknownHostException e) {
                        throw new IllegalArgumentException("Something wrong with load balancer host creation.", e);
                    }
                    SipLoadBalancer loadBalancer = new SipLoadBalancer(loadBalancerHeartBeatingService, loadBalancerAddress, this.sipConnector.getLoadBalancerSipPort(), -1, this.sipConnector.getLoadBalancerRmiPort());
                    this.extendedListeningPoint.setLoadBalancer(loadBalancer);
                    loadBalancerHeartBeatingService.addSipConnector((ListeningPoint)listeningPoint, loadBalancer);
                } else {
                    loadBalancerHeartBeatingService.addSipConnector((ListeningPoint)listeningPoint);
                }
            }
            this.setAttribute(ExtendedListeningPoint.class.getSimpleName(), this.extendedListeningPoint);
            SipApplicationDispatcher sipApplicationDispatcher = (SipApplicationDispatcher)this.getAttribute(SipApplicationDispatcher.class.getSimpleName());
            if (sipApplicationDispatcher != null) {
                if (this.sipConnector.getStaticServerAddress() != null) {
                    sipApplicationDispatcher.addHostName(this.sipConnector.getStaticServerAddress() + ":" + this.sipConnector.getStaticServerPort());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding hostname for IP load balancer " + this.sipConnector.getStaticServerAddress()));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding the Sip Application Dispatcher as a sip listener for connector listening on port " + port));
                }
                sipProvider.addSipListener((SipListener)sipApplicationDispatcher);
                sipApplicationDispatcher.getSipNetworkInterfaceManager().addExtendedListeningPoint((MobicentsExtendedListeningPoint)this.extendedListeningPoint);
            }
            logger.info((Object)("Sip Connector started on ip address : " + ipAddress + ",port " + port + ", transport " + signalingTransport + ", useStun " + useStun + ", stunAddress " + this.sipConnector.getStunServerAddress() + ", stunPort : " + this.sipConnector.getStaticServerPort() + ", useLoadBalancer " + this.sipConnector.isUseLoadBalancer()));
            if (this.domain != null) {
                this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.sipStack, this.rgOname, null);
            }
            this.setStarted(true);
        }
        catch (Exception ex) {
            logger.error((Object)("A problem occured while setting up SIP Connector " + ipAddress + ":" + port + "/" + signalingTransport + "-- check server.xml for tomcat. "), (Throwable)ex);
        }
        finally {
            if (!this.isStarted()) {
                this.destroy();
            }
        }
    }

    private DatagramSocket initRandomPortSocket() {
        int bindRetries = 5;
        int currentlyTriedPort = SipProtocolHandler.getRandomPortNumber(1024, 65535);
        DatagramSocket resultSocket = null;
        for (int i = 0; i < bindRetries; ++i) {
            try {
                resultSocket = new DatagramSocket(currentlyTriedPort);
                break;
            }
            catch (SocketException exc) {
                if (exc.getMessage().indexOf("Address already in use") == -1) {
                    logger.fatal((Object)"An exception occurred while trying to createa local host discovery socket.", (Throwable)exc);
                    return null;
                }
                logger.debug((Object)("Port " + currentlyTriedPort + " seems in use."));
                currentlyTriedPort = SipProtocolHandler.getRandomPortNumber(1024, 65535);
                logger.debug((Object)("Retrying bind on port " + currentlyTriedPort));
                continue;
            }
        }
        return resultSocket;
    }

    public static int getRandomPortNumber(int min, int max) {
        return portNumberGenerator.nextInt(max - min) + min;
    }

    public String getSignalingTransport() {
        return this.sipConnector.getTransport();
    }

    public void setSignalingTransport(String transport) throws Exception {
        this.sipConnector.setTransport(transport);
        if (this.isStarted()) {
            this.destroy();
            this.start();
        }
    }

    public int getPort() {
        return this.sipConnector.getPort();
    }

    public void setPort(int port) throws Exception {
        this.sipConnector.setPort(port);
        if (this.isStarted()) {
            this.destroy();
            this.start();
        }
    }

    public void setIpAddress(String ipAddress) throws Exception {
        this.sipConnector.setIpAddress(ipAddress);
        if (this.isStarted()) {
            this.destroy();
            this.start();
        }
    }

    public String getIpAddress() {
        return this.sipConnector.getIpAddress();
    }

    public String getStunServerAddress() {
        return this.sipConnector.getStunServerAddress();
    }

    public void setStunServerAddress(String stunServerAddress) {
        this.sipConnector.setStunServerAddress(stunServerAddress);
    }

    public int getStunServerPort() {
        return this.sipConnector.getStunServerPort();
    }

    public void setStunServerPort(int stunServerPort) {
        this.sipConnector.setStunServerPort(stunServerPort);
    }

    public boolean isUseLoadBalancer() {
        return this.sipConnector.isUseLoadBalancer();
    }

    public void setUseLoadBalancer(boolean useLoadBalancer) {
        this.sipConnector.setUseLoadBalancer(useLoadBalancer);
    }

    public boolean isUseStun() {
        return this.sipConnector.isUseStun();
    }

    public void setUseStun(boolean useStun) {
        this.sipConnector.setUseStun(useStun);
    }

    public String getStaticServerAddress() {
        return this.sipConnector.getStaticServerAddress();
    }

    public void setStaticServerAddress(String staticServerAddress) {
        this.sipConnector.setStaticServerAddress(staticServerAddress);
    }

    public int getStaticServerPort() {
        return this.sipConnector.getStaticServerPort();
    }

    public void setStaticServerPort(int staticServerPort) {
        this.sipConnector.setStaticServerPort(staticServerPort);
    }

    public boolean isUseStaticAddress() {
        return this.sipConnector.isUseStaticAddress();
    }

    public void setUseStaticAddress(boolean useStaticAddress) {
        this.sipConnector.setUseStaticAddress(useStaticAddress);
    }

    public String getHostNames() {
        return this.sipConnector.getHostNames();
    }

    public void setHostNames(String hostNames) {
        this.sipConnector.setHostNames(hostNames);
    }

    public String getAddress() {
        return this.getName();
    }

    public InetAddress getInetIpAddress() {
        try {
            return InetAddress.getByName(this.sipConnector.getIpAddress());
        }
        catch (UnknownHostException e) {
            logger.error((Object)"unexpected exception while getting the ipaddress of the sip protocol handler", (Throwable)e);
            return null;
        }
    }

    public void setInetIpAddress(InetAddress ia) {
        this.sipConnector.setIpAddress(ia.getHostAddress());
    }

    public String getTransport() {
        return this.sipConnector.getTransport();
    }

    public Properties getSipStackProperties() {
        return this.sipStackProperties;
    }

    public void setSipStackProperties(Properties sipStackProperties) {
        this.sipStackProperties = sipStackProperties;
    }

    public boolean isReplaceStaticServerAddressForInternalRoutingRequest() {
        return this.sipConnector.isReplaceStaticServerAddressForInternalRoutingRequest();
    }

    public void setReplaceStaticServerAddressForInternalRoutingRequest(boolean value) {
        this.sipConnector.setReplaceStaticServerAddressForInternalRoutingRequest(value);
    }

    public void setSipConnector(SipConnector sipConnector) {
        this.sipConnector = sipConnector;
    }

    public SipConnector getSipConnector() {
        return this.sipConnector;
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getInetIpAddress() != null) {
            encodedAddr = "" + this.getInetIpAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "sip-" + this.getTransport() + "-" + encodedAddr + this.getPort();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public Executor getExecutor() {
        return null;
    }

    public void stop() throws Exception {
        this.destroy();
    }

    public boolean isAprRequired() {
        return false;
    }
}

