/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.util.ContextName;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.catalina.annotations.SipApplicationAnnotationUtils;

public class SipHostConfig
extends HostConfig {
    private static final String WAR_EXTENSION = ".war";
    private static final String SAR_EXTENSION = ".sar";
    public static final String SIP_CONTEXT_CLASS = "org.mobicents.servlet.sip.startup.SipStandardContext";
    public static final String SIP_CONTEXT_CONFIG_CLASS = "org.mobicents.servlet.sip.startup.SipContextConfig";
    private static final Logger logger = Logger.getLogger(SipHostConfig.class);

    protected void deployApps() {
        super.deployApps();
    }

    protected void deployApps(String name) {
        File sar;
        File appBase = this.appBase();
        File configBase = this.configBase();
        ContextName cn = new ContextName(name);
        String baseName = cn.getBaseName();
        if (this.deploymentExists(baseName)) {
            return;
        }
        File xml = new File(configBase, baseName + ".xml");
        if (xml.exists()) {
            this.deployDescriptor(cn, xml);
            return;
        }
        File war = new File(appBase, baseName + WAR_EXTENSION);
        if (war.exists()) {
            boolean isSipServletApplication = this.isSipServletArchive(war);
            if (isSipServletApplication) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WEB-INF/sip.xml found in " + baseName + ". Enabling sip servlet archive deployment"));
                }
                this.deploySAR(cn, war);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WEB-INF/sip.xml not found in " + baseName + ". Not Enabling sip servlet archive deployment"));
                }
                this.deployWAR(cn, war);
            }
            return;
        }
        File dir = new File(appBase, baseName);
        if (dir.exists()) {
            this.deployDirectory(cn, dir);
        }
        if ((sar = new File(appBase, baseName + SAR_EXTENSION)).exists()) {
            this.deploySAR(cn, sar);
        }
    }

    private void deploySAR(ContextName cn, File sar) {
        if (this.deploymentExists(cn.getName())) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WEB-INF/sip.xml found in " + sar + ". Enabling sip servlet archive deployment"));
        }
        String initialConfigClass = this.configClass;
        String initialContextClass = this.contextClass;
        this.host.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
        this.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
        this.setContextClass(SIP_CONTEXT_CLASS);
        this.deployWAR(cn, sar);
        this.host.setConfigClass(initialConfigClass);
        this.configClass = initialConfigClass;
        this.contextClass = initialContextClass;
    }

    protected void deployWAR(ContextName cn, File dir) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Context class used to deploy the WAR : " + this.contextClass));
            logger.debug((Object)("Context config class used to deploy the WAR : " + this.configClass));
        }
        super.deployWAR(cn, dir);
    }

    protected void deployDirectory(ContextName cn, File dir) {
        if (this.deploymentExists(cn.getName())) {
            return;
        }
        boolean isSipServletApplication = this.isSipServletDirectory(dir);
        if (isSipServletApplication) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WEB-INF/sip.xml found in " + dir + ". Enabling sip servlet archive deployment"));
            }
            String initialConfigClass = this.configClass;
            String initialContextClass = this.contextClass;
            this.host.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
            this.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
            this.setContextClass(SIP_CONTEXT_CLASS);
            super.deployDirectory(cn, dir);
            this.host.setConfigClass(initialConfigClass);
            this.configClass = initialConfigClass;
            this.contextClass = initialContextClass;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WEB-INF/sip.xml not found in " + dir + ". Not Enabling sip servlet archive deployment"));
            }
            this.digester = SipHostConfig.createDigester((String)StandardContext.class.getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Context class used to deploy the directory : " + this.contextClass));
                logger.debug((Object)("Context config class used to deploy the directory : " + this.configClass));
            }
            super.deployDirectory(cn, dir);
        }
    }

    protected void deployDescriptor(ContextName cn, File contextXml) {
        super.deployDescriptor(cn, contextXml);
    }

    protected void deployWARs(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF")) continue;
            File dir = new File(appBase, files[i]);
            boolean isSipServletApplication = this.isSipServletArchive(dir);
            if (isSipServletApplication) {
                ContextName cn;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WEB-INF/sip.xml found in " + files[i] + ". Enabling sip servlet archive deployment"));
                }
                if (this.isServiced((cn = new ContextName(files[i])).getName())) continue;
                String initialConfigClass = this.configClass;
                String initialContextClass = this.contextClass;
                this.host.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
                this.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
                this.setContextClass(SIP_CONTEXT_CLASS);
                this.deploySAR(cn, dir);
                this.host.setConfigClass(initialConfigClass);
                this.configClass = initialConfigClass;
                this.contextClass = initialContextClass;
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WEB-INF/sip.xml not found in " + files[i] + ". Not Enabling sip servlet archive deployment"));
            }
            this.setContextClass(StandardContext.class.getName());
        }
        super.deployWARs(appBase, files);
    }

    private boolean isSipServletArchive(File file) {
        if (file.getName().toLowerCase().endsWith(SAR_EXTENSION)) {
            return true;
        }
        if (file.getName().toLowerCase().endsWith(WAR_EXTENSION)) {
            block5: {
                try {
                    JarFile jar = new JarFile(file);
                    JarEntry entry = jar.getJarEntry("WEB-INF/sip.xml");
                    if (entry != null) {
                        return true;
                    }
                }
                catch (IOException e) {
                    if (!logger.isInfoEnabled()) break block5;
                    logger.info((Object)("couldn't find WEB-INF/sip.xml in " + file + " checking for package-info.class"));
                }
            }
            return SipApplicationAnnotationUtils.findPackageInfoInArchive(file);
        }
        return false;
    }

    private boolean isSipServletDirectory(File dir) {
        if (dir.isDirectory()) {
            File sipXmlFile = new File(dir.getAbsoluteFile(), "WEB-INF/sip.xml");
            if (sipXmlFile.exists()) {
                return true;
            }
            if (SipApplicationAnnotationUtils.findPackageInfoinDirectory(dir)) {
                return true;
            }
        }
        return false;
    }

    public void manageApp(Context arg0) {
        super.manageApp(arg0);
    }
}

