/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina;

import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardService;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.catalina.SipStandardService;
import org.mobicents.servlet.sip.core.SipService;

public class ServiceGracefulStopTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(ServiceGracefulStopTask.class);
    StandardService sipService;

    public ServiceGracefulStopTask(StandardService sipService) {
        this.sipService = sipService;
    }

    @Override
    public void run() {
        int numberOfSipApplicationsDeployed = ((SipService)this.sipService).getSipApplicationDispatcher().findInstalledSipApplications().length;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ServiceGracefulStopTask running, number of Sip Application still running " + numberOfSipApplicationsDeployed));
        }
        if (numberOfSipApplicationsDeployed <= 0) {
            try {
                ((SipStandardService)this.sipService).getServer().stop();
            }
            catch (LifecycleException e) {
                logger.error((Object)"Couldn't gracefully stop service", (Throwable)e);
            }
        }
    }
}

