/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina;

import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.SipContext;

public class ContextGracefulStopTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(ContextGracefulStopTask.class);
    Context sipContext;
    long timeToWait;
    long startTime;

    public ContextGracefulStopTask(Context context, long timeToWait) {
        this.sipContext = context;
        this.timeToWait = timeToWait;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        int numberOfActiveSipApplicationSessions = ((SipContext)this.sipContext).getSipManager().getActiveSipApplicationSessions();
        int numberOfActiveHttpSessions = this.sipContext.getManager().getActiveSessions();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ContextGracefulStopTask running for context " + this.sipContext.getName() + ", number of Sip Application Sessions still active " + numberOfActiveSipApplicationSessions + " number of HTTP Sessions still active " + numberOfActiveHttpSessions));
        }
        boolean stopPrematuraly = false;
        long currentTime = System.currentTimeMillis();
        if (this.timeToWait > 0L && currentTime - this.startTime > this.timeToWait) {
            stopPrematuraly = true;
        }
        if (numberOfActiveSipApplicationSessions <= 0 && numberOfActiveHttpSessions <= 0 || stopPrematuraly) {
            try {
                ((StandardContext)this.sipContext).stop();
            }
            catch (LifecycleException e) {
                logger.error((Object)("Couldn't gracefully stop context " + this.sipContext.getName()), (Throwable)e);
            }
        }
    }
}

