/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallBlockingSipServlet
extends SipServlet
implements SipErrorListener,
Servlet {
    private static Log logger = LogFactory.getLog(CallBlockingSipServlet.class);
    List<String> blockedUris = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the call blocking sip servlet has been started");
        super.init(servletConfig);
        this.blockedUris = new ArrayList();
        this.blockedUris.add("sip:blocked-sender@sip-servlets.com");
        this.blockedUris.add("sip:blocked-sender@127.0.0.1");
    }

    public boolean isUriBlocked(String uri) {
        for (String blockedUri : this.blockedUris) {
            if (uri.indexOf(blockedUri) < 0) continue;
            return true;
        }
        return false;
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got request:\n" + request.toString()));
        String fromUri = request.getFrom().getURI().toString();
        logger.info((Object)fromUri);
        if (this.isUriBlocked(fromUri)) {
            logger.info((Object)(fromUri + " has been blocked !"));
            SipServletResponse sipServletResponse = request.createResponse(403);
            sipServletResponse.send();
        } else {
            logger.info((Object)(fromUri + " has not been blocked."));
        }
    }

    protected void doBye(SipServletRequest req) throws ServletException, IOException {
        logger.info((Object)"Call Blocking doesn't handle BYE requests");
    }

    public void noAckReceived(SipErrorEvent ee) {
        logger.error((Object)"noAckReceived.");
    }

    public void noPrackReceived(SipErrorEvent ee) {
        logger.error((Object)"noPrackReceived.");
    }
}

