/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;

public class B2BUASipServlet
extends SipServlet {
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = Logger.getLogger(B2BUASipServlet.class);

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got request:\n" + request));
        if (((SipURI)request.getFrom().getURI()).getUser().contains("generateResponses")) {
            SipServletResponse ringing = request.createResponse(180);
            SipServletResponse ok = request.createResponse(200);
            ringing.send();
            ok.send();
        }
        HashMap headers = new HashMap();
        ArrayList<String> toHeaderList = new ArrayList<String>();
        toHeaderList.add("sip:aa@sip-servlets.com");
        headers.put("To", toHeaderList);
        B2buaHelper helper = request.getB2buaHelper();
        SipServletRequest forkedRequest = helper.createRequest(request, true, headers);
        SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        SipURI sipUri = (SipURI)sipFactory.createURI("sip:aa@127.0.0.1:5059");
        if (request.getTo().toString().contains("cancel-no-response")) {
            sipUri = (SipURI)sipFactory.createURI("sip:cancel-no-respo-receiver@127.0.0.1:9368");
        }
        forkedRequest.setRequestURI((URI)sipUri);
        if (request.getTo().toString().contains("cancel-no-response")) {
            forkedRequest.send();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            forkedRequest.createCancel().send();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("forkedRequest = " + forkedRequest));
        }
        if (forkedRequest.getParameterableHeaders("Contact").hasNext()) {
            forkedRequest.getSession().setAttribute("originalRequest", (Object)request);
            forkedRequest.send();
        } else {
            request.createResponse(500, "Contact not present in newly created request").send();
        }
    }

    protected void doResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
        logger.info((Object)("Got : " + sipServletResponse.getStatus() + " " + sipServletResponse.getMethod()));
        if (sipServletResponse.getStatus() == 200) {
            if (sipServletResponse.getMethod().equalsIgnoreCase("INVITE")) {
                SipServletRequest ackRequest = sipServletResponse.createAck();
                ackRequest.send();
                if (!((SipURI)sipServletResponse.getTo().getURI()).getUser().contains("generateResponses")) {
                    B2buaHelper helper = sipServletResponse.getRequest().getB2buaHelper();
                    SipSession originalSession = helper.getLinkedSession(sipServletResponse.getSession());
                    SipServletResponse responseToOriginalRequest = helper.createResponseToOriginalRequest(originalSession, sipServletResponse.getStatus(), "OK");
                    responseToOriginalRequest.send();
                }
            }
        } else {
            super.doResponse(sipServletResponse);
        }
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got BYE: " + request.getMethod()));
        SipServletResponse response = request.createResponse(200);
        response.send();
        SipSession session = request.getSession();
        SipSession linkedSession = request.getB2buaHelper().getLinkedSession(session);
        SipServletRequest newRequest = linkedSession.createRequest("BYE");
        logger.info((Object)newRequest);
        newRequest.send();
    }

    protected void doCancel(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got CANCEL: " + request.toString()));
        SipSession session = request.getSession();
        B2buaHelper b2buaHelper = request.getB2buaHelper();
        SipSession linkedSession = b2buaHelper.getLinkedSession(session);
        SipServletRequest originalRequest = (SipServletRequest)linkedSession.getAttribute("originalRequest");
        SipServletRequest cancelRequest = b2buaHelper.getLinkedSipServletRequest(originalRequest).createCancel();
        logger.info((Object)("forkedRequest = " + cancelRequest));
        cancelRequest.send();
    }
}

