/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.Resource;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.annotation.SipApplicationKey;
import javax.servlet.sip.annotation.SipListener;
import javax.servlet.sip.annotation.SipServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;

@SipListener
@SipServlet(loadOnStartup=1)
public class AnnotatedServlet
extends javax.servlet.sip.SipServlet
implements Servlet,
SipServletListener {
    @Resource
    SipFactory sipFactory;
    @Resource
    SipSessionsUtil sipSessionsUtil;
    @Resource
    TimerService timerService;
    private static Log logger = LogFactory.getLog(AnnotatedServlet.class);

    public void init(ServletConfig servletConfig) throws ServletException {
        TimerService timerServiceJndi;
        SipSessionsUtil sipSessionsUtilJndi;
        SipFactory sipFactoryJndi;
        super.init(servletConfig);
        logger.info((Object)"the simple sip servlet has been started");
        logger.info((Object)("SipFactory injected resource " + this.sipFactory));
        logger.info((Object)("SipSessionsUtil injected resource " + this.sipSessionsUtil));
        logger.info((Object)("TimerService injected resource " + this.timerService));
        if (this.sipFactory == null || this.sipSessionsUtil == null || this.timerService == null) {
            throw new ServletException("Impossible to get one of the annotated resource");
        }
        try {
            Properties jndiProps = new Properties();
            InitialContext initCtx = new InitialContext(jndiProps);
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            sipFactoryJndi = (SipFactory)envCtx.lookup("sip/org.mobicents.servlet.sip.testsuite.AnnotatedApplication/SipFactory");
            sipSessionsUtilJndi = (SipSessionsUtil)envCtx.lookup("sip/org.mobicents.servlet.sip.testsuite.AnnotatedApplication/SipSessionsUtil");
            timerServiceJndi = (TimerService)envCtx.lookup("sip/org.mobicents.servlet.sip.testsuite.AnnotatedApplication/TimerService");
            logger.info((Object)("SipFactory injected resource" + this.sipFactory));
            logger.info((Object)("SipSessionsUtil injected resource" + this.sipSessionsUtil));
            logger.info((Object)("TimerService injected resource" + this.timerService));
            logger.info((Object)("Sip Factory ref from JNDI : " + this.sipFactory));
        }
        catch (NamingException e) {
            throw new ServletException("Uh oh -- JNDI problem !", (Throwable)e);
        }
        if (sipFactoryJndi == null || sipSessionsUtilJndi == null || timerServiceJndi == null) {
            throw new ServletException("Impossible to get one of the annotated resource");
        }
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got request: " + request.getMethod()));
        SipServletResponse sipServletResponse = request.createResponse(180);
        sipServletResponse.send();
        sipServletResponse = request.createResponse(200);
        sipServletResponse.send();
        logger.info((Object)("SipFactory injected resource" + this.sipFactory));
        logger.info((Object)("SipSessionsUtil injected resource" + this.sipSessionsUtil));
        logger.info((Object)("TimerService injected resource" + this.timerService));
        try {
            SipApplicationSession appSession = this.sipFactory.createApplicationSession();
            SipServletRequest req = this.sipFactory.createRequest(appSession, "INVITE", "sip:from@127.0.0.1:5070", "sip:to@127.0.0.1:5058");
            req.send();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got BYE request: " + request));
        SipServletResponse sipServletResponse = request.createResponse(200);
        sipServletResponse.send();
    }

    public void servletInitialized(SipServletContextEvent ce) {
        ConcurrencyControlMode concurrencyControlMode = (ConcurrencyControlMode)ce.getServletContext().getAttribute(ConcurrencyControlMode.class.getCanonicalName());
        logger.info((Object)("concurrency control mode set to " + concurrencyControlMode));
        if (!ConcurrencyControlMode.SipApplicationSession.equals((Object)concurrencyControlMode)) {
            throw new IllegalArgumentException("@ConcurrencyControl annotation badly parsed");
        }
        try {
            SipFactory sipFactory = (SipFactory)ce.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
            SipApplicationSession appSession = sipFactory.createApplicationSession();
            SipServletRequest req = sipFactory.createRequest(appSession, "INVITE", "sip:from@127.0.0.1:5070", "sip:to@127.0.0.1:5070");
            req.send();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doSuccessResponse(SipServletResponse response) throws ServletException, IOException {
        logger.info((Object)("Got response: " + response));
        response.createAck().send();
    }

    @SipApplicationKey
    public static String key(SipServletRequest request) {
        return "working";
    }
}

