/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.seam.media.framework;

import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.SipSession;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.events.MsEventIdentifier;
import org.mobicents.mscontrol.events.dtmf.MsDtmfNotifyEvent;
import org.mobicents.mscontrol.events.pkg.DTMF;
import org.mobicents.mscontrol.events.pkg.MsAnnouncement;
import org.mobicents.mscontrol.events.pkg.MsAudio;
import org.mobicents.servlet.sip.seam.entrypoint.media.MediaEvent;
import org.mobicents.servlet.sip.seam.media.framework.MediaSessionStore;

@Name(value="mediaEventDispatcher")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
@AutoCreate
public class MediaEventDispatcher {
    @In(required=false)
    MediaSessionStore mediaSessionStore;
    @Logger
    Log log;
    @In(required=false)
    SipSession sipSession;
    private static ConcurrentHashMap<Object, StringBuffer> dtmfBuffer = new ConcurrentHashMap();

    private void addNumber(Object object, String number) {
        if (dtmfBuffer.get(object) == null) {
            dtmfBuffer.put(object, new StringBuffer());
        }
        dtmfBuffer.get(object).append(number);
    }

    public void reset(Object object) {
        dtmfBuffer.put(object, new StringBuffer());
    }

    public String getDtmfArchive(Object object) {
        return dtmfBuffer.get(object).toString();
    }

    public String getDtmfArchive(Object object, int digits) {
        String stringDigits = this.getDtmfArchive(object);
        int numDigits = stringDigits.length();
        return stringDigits.substring(numDigits - digits, numDigits);
    }

    @Observer(value={"mediaEvent"})
    public void doMediaEvent(MediaEvent mediaEvent) {
        MsEventIdentifier identifier = mediaEvent.getMsNotifyEvent().getEventID();
        if (identifier.equals(DTMF.TONE)) {
            MsDtmfNotifyEvent event = (MsDtmfNotifyEvent)mediaEvent.getMsNotifyEvent();
            String signal = event.getSequence();
            this.addNumber(mediaEvent.getLink(), signal);
            this.addNumber(mediaEvent.getEndpoint(), signal);
            this.addNumber(mediaEvent.getSipSession(), signal);
            Events.instance().raiseEvent("DTMF", new Object[]{signal});
        } else if (identifier.equals(MsAnnouncement.COMPLETED)) {
            Events.instance().raiseEvent("announcementComplete", new Object[0]);
        } else if (identifier.equals(MsAnnouncement.FAILED)) {
            Events.instance().raiseEvent("announcementFailed", new Object[0]);
        } else if (identifier.equals(MsAudio.FAILED)) {
            Events.instance().raiseEvent("audioFailed", new Object[0]);
        }
    }

    @Observer(value={"preLinkConnected"})
    public void doLinkConnected(MsLinkEvent linkEvent) {
        this.mediaSessionStore.setMsLink(linkEvent.getSource());
        this.mediaSessionStore.setMsEndpoint(linkEvent.getSource().getEndpoints()[0]);
        Events.instance().raiseEvent("linkConnected", new Object[]{linkEvent});
        Events.instance().raiseEvent("storeLinkConnected", new Object[]{linkEvent});
    }

    @Observer(value={"connectionOpen"})
    public void doConnectionOpen(MsConnectionEvent connectionEvent) {
        this.mediaSessionStore.setMsConnection(connectionEvent.getConnection());
        this.mediaSessionStore.setMsEndpoint(connectionEvent.getConnection().getEndpoint());
        Events.instance().raiseEvent("storeConnectionOpen", new Object[]{connectionEvent});
    }

    @Observer(value={"preConnectionHalfOpen"})
    public void doConnectionHalfOpen(MsConnectionEvent connectionEvent) {
        this.log.info((Object)("PRECONNECTION for " + this.sipSession.toString()), new Object[0]);
        this.mediaSessionStore.setMsConnection(connectionEvent.getConnection());
        this.mediaSessionStore.setMsEndpoint(connectionEvent.getConnection().getEndpoint());
        Events.instance().raiseEvent("connectionHalfOpen", new Object[]{connectionEvent});
    }

    @Observer(value={"sipSessionDestroyed"})
    public void doSipSessionDestroyed(SipSession sipSession) {
        dtmfBuffer.remove(sipSession);
    }

    @Observer(value={"linkDisconnected"})
    public void doLinkDisconnected(MsLinkEvent linkEvent) {
        dtmfBuffer.remove(linkEvent.getSource());
    }

    @Observer(value={"connectionDisconnected"})
    public void doConnectionDisconnected(MsConnectionEvent connectionEvent) {
        dtmfBuffer.remove(connectionEvent.getConnection());
    }
}

