/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.seam.media.framework;

import javax.servlet.sip.SipSession;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.events.MsEventAction;
import org.mobicents.mscontrol.events.MsEventFactory;
import org.mobicents.mscontrol.events.MsRequestedEvent;
import org.mobicents.mscontrol.events.MsRequestedSignal;
import org.mobicents.mscontrol.events.ann.MsPlayRequestedSignal;
import org.mobicents.mscontrol.events.audio.MsRecordRequestedSignal;
import org.mobicents.mscontrol.events.dtmf.MsDtmfRequestedEvent;
import org.mobicents.mscontrol.events.pkg.DTMF;
import org.mobicents.mscontrol.events.pkg.MsAnnouncement;
import org.mobicents.mscontrol.events.pkg.MsAudio;
import org.mobicents.servlet.sip.seam.entrypoint.media.MediaController;
import org.mobicents.servlet.sip.seam.entrypoint.media.MsProviderContainer;
import org.mobicents.servlet.sip.seam.media.framework.MediaSessionStore;

public class IVRHelper {
    SipSession sipSession;
    MsEventFactory eventFactory;
    MediaController mediaController;
    MediaSessionStore mediaSessionStore;

    public IVRHelper(SipSession sipSession, MediaSessionStore mediaSessionStore, MediaController mediaController) {
        this.sipSession = sipSession;
        this.mediaSessionStore = mediaSessionStore;
        this.mediaController = mediaController;
        this.eventFactory = MsProviderContainer.msProvider.getEventFactory();
    }

    public void playAnnouncement(String file) {
        MsRequestedEvent onCompleted = this.eventFactory.createRequestedEvent(MsAnnouncement.COMPLETED);
        onCompleted.setEventAction(MsEventAction.NOTIFY);
        MsRequestedEvent onFailed = this.eventFactory.createRequestedEvent(MsAnnouncement.FAILED);
        onFailed.setEventAction(MsEventAction.NOTIFY);
        MsPlayRequestedSignal play = (MsPlayRequestedSignal)this.eventFactory.createRequestedSignal(MsAnnouncement.PLAY);
        play.setURL(file);
        MsRequestedSignal[] requestedSignals = new MsRequestedSignal[]{play};
        MsRequestedEvent[] requestedEvents = new MsRequestedEvent[]{onCompleted, onFailed};
        MsLink msLink = this.mediaSessionStore.getMsLink();
        MsConnection msConnection = this.mediaSessionStore.getMsConnection();
        if (msLink != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msLink);
        } else if (msConnection != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msConnection);
        }
    }

    public void playAnnouncementWithDtmf(String file) {
        MsRequestedEvent onCompleted = this.eventFactory.createRequestedEvent(MsAnnouncement.COMPLETED);
        onCompleted.setEventAction(MsEventAction.NOTIFY);
        MsRequestedEvent onFailed = this.eventFactory.createRequestedEvent(MsAnnouncement.FAILED);
        onFailed.setEventAction(MsEventAction.NOTIFY);
        MsPlayRequestedSignal play = (MsPlayRequestedSignal)this.eventFactory.createRequestedSignal(MsAnnouncement.PLAY);
        play.setURL(file);
        MsDtmfRequestedEvent dtmf = (MsDtmfRequestedEvent)this.eventFactory.createRequestedEvent(DTMF.TONE);
        MsRequestedSignal[] requestedSignals = new MsRequestedSignal[]{play};
        MsRequestedEvent[] requestedEvents = new MsRequestedEvent[]{onCompleted, onFailed, dtmf};
        MsLink msLink = this.mediaSessionStore.getMsLink();
        MsConnection msConnection = this.mediaSessionStore.getMsConnection();
        if (msLink != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msLink);
        } else if (msConnection != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msConnection);
        }
    }

    public void detectDtmf() {
        MsDtmfRequestedEvent dtmf = (MsDtmfRequestedEvent)this.eventFactory.createRequestedEvent(DTMF.TONE);
        MsRequestedSignal[] requestedSignals = new MsRequestedSignal[]{};
        MsRequestedEvent[] requestedEvents = new MsRequestedEvent[]{dtmf};
        MsLink msLink = this.mediaSessionStore.getMsLink();
        MsConnection msConnection = this.mediaSessionStore.getMsConnection();
        if (msLink != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msLink);
        } else if (msConnection != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msConnection);
        }
    }

    public void record(String file) {
        MsDtmfRequestedEvent dtmf = (MsDtmfRequestedEvent)this.eventFactory.createRequestedEvent(DTMF.TONE);
        MsRecordRequestedSignal record = (MsRecordRequestedSignal)this.eventFactory.createRequestedSignal(MsAudio.RECORD);
        record.setFile(file);
        MsRequestedEvent onFailed = this.eventFactory.createRequestedEvent(MsAudio.FAILED);
        onFailed.setEventAction(MsEventAction.NOTIFY);
        MsRequestedSignal[] requestedSignals = new MsRequestedSignal[]{record};
        MsRequestedEvent[] requestedEvents = new MsRequestedEvent[]{dtmf, onFailed};
        MsLink msLink = this.mediaSessionStore.getMsLink();
        MsConnection msConnection = this.mediaSessionStore.getMsConnection();
        if (msLink != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msLink);
        } else if (msConnection != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msConnection);
        }
    }

    public void endAll() {
        MsRequestedSignal[] requestedSignals = new MsRequestedSignal[]{};
        MsRequestedEvent[] requestedEvents = new MsRequestedEvent[]{};
        MsLink msLink = this.mediaSessionStore.getMsLink();
        MsConnection msConnection = this.mediaSessionStore.getMsConnection();
        if (msLink != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msLink);
        } else if (msConnection != null) {
            this.mediaController.execute(this.mediaSessionStore.getMsEndpoint(), requestedSignals, requestedEvents, msConnection);
        }
    }
}

