/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.seam.entrypoint.media;

import javax.servlet.sip.SipSession;
import org.apache.log4j.Logger;
import org.jboss.seam.core.Events;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.servlet.sip.seam.entrypoint.SeamEntrypointUtils;

public class ConnectionListener
implements MsConnectionListener {
    private static Logger log = Logger.getLogger(ConnectionListener.class);
    private SipSession sipSession;

    public ConnectionListener(SipSession sipSession) {
        this.sipSession = sipSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEvent(String eventName, MsConnectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Before posting Event from listener: " + eventName + ", session=" + this.sipSession.toString()));
        }
        log.info((Object)("Before posting Event from listener: " + eventName + ", session=" + this.sipSession.toString()));
        SeamEntrypointUtils.beginEvent(this.sipSession);
        try {
            Events.instance().raiseEvent(eventName, new Object[]{event});
            SeamEntrypointUtils.endEvent();
        }
        catch (Throwable t) {
            log.error((Object)("Error delivering event " + eventName + ", session=" + this.sipSession.toString()), t);
            Events.instance().raiseEvent("org.mobicents.media.unhandledException", new Object[]{t});
        }
        finally {
            SeamEntrypointUtils.endEvent();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("After posting Event from listener: " + eventName + ", session=" + this.sipSession.toString()));
        }
    }

    public void connectionCreated(MsConnectionEvent arg0) {
        this.postEvent("connectionCreated", arg0);
    }

    public void connectionDisconnected(MsConnectionEvent arg0) {
        this.postEvent("connectionDisconnected", arg0);
    }

    public void connectionFailed(MsConnectionEvent arg0) {
        this.postEvent("connectionFailed", arg0);
    }

    public void connectionHalfOpen(MsConnectionEvent arg0) {
        this.postEvent("preConnectionHalfOpen", arg0);
    }

    public void connectionModeRecvOnly(MsConnectionEvent arg0) {
        this.postEvent("connectionModeRecvOnly", arg0);
    }

    public void connectionModeSendOnly(MsConnectionEvent arg0) {
        this.postEvent("connectionModeSendOnly", arg0);
    }

    public void connectionModeSendRecv(MsConnectionEvent arg0) {
        this.postEvent("connectionModeSendRecv", arg0);
    }

    public void connectionOpen(MsConnectionEvent arg0) {
        this.postEvent("connectionOpen", arg0);
    }
}

