/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.seam.entrypoint.media;

import java.util.HashMap;
import javax.servlet.sip.SipSession;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsEndpoint;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsLinkMode;
import org.mobicents.mscontrol.MsNotificationListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.events.MsRequestedEvent;
import org.mobicents.mscontrol.events.MsRequestedSignal;
import org.mobicents.servlet.sip.seam.entrypoint.media.ConnectionListener;
import org.mobicents.servlet.sip.seam.entrypoint.media.LinkListener;
import org.mobicents.servlet.sip.seam.entrypoint.media.NotificationListener;

@Name(value="mediaController")
@Scope(value=ScopeType.APPLICATION)
@Install(precedence=10)
@Startup
public class MediaController {
    @In(required=false)
    private SipSession sipSession;
    @In(required=false)
    private MsSession msSession;
    private HashMap<Object, MsNotificationListener> listenerMap = new HashMap();

    public MsConnection createConnection(String endpoint) {
        MsConnection msConnection = this.msSession.createNetworkConnection(endpoint);
        msConnection.addConnectionListener((MsConnectionListener)new ConnectionListener(this.sipSession));
        return msConnection;
    }

    public MsLink createLink(MsLinkMode mode) {
        MsLink link = this.msSession.createLink(mode);
        link.addLinkListener((MsLinkListener)new LinkListener(this.sipSession));
        return link;
    }

    public void execute(MsEndpoint endpoint, MsRequestedSignal[] signals, MsRequestedEvent[] events) {
        endpoint.execute(signals, events);
        if (this.listenerMap.get(endpoint) == null) {
            NotificationListener newListener = new NotificationListener(this.sipSession, this.msSession, endpoint, null);
            this.listenerMap.put(endpoint, newListener);
            endpoint.addNotificationListener((MsNotificationListener)newListener);
        }
    }

    public void execute(MsEndpoint endpoint, MsRequestedSignal[] signals, MsRequestedEvent[] events, MsConnection connection) {
        endpoint.execute(signals, events, connection);
        if (this.listenerMap.get(connection) == null) {
            NotificationListener newListener = new NotificationListener(this.sipSession, this.msSession, endpoint, connection);
            this.listenerMap.put(connection, newListener);
            connection.addNotificationListener((MsNotificationListener)newListener);
        }
    }

    public void execute(MsEndpoint endpoint, MsRequestedSignal[] signals, MsRequestedEvent[] events, MsLink link) {
        endpoint.execute(signals, events, link);
        if (this.listenerMap.get(link) == null) {
            NotificationListener newListener = new NotificationListener(this.sipSession, this.msSession, endpoint, link);
            this.listenerMap.put(link, newListener);
            link.addNotificationListener((MsNotificationListener)newListener);
        }
    }
}

