/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.seam.entrypoint;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipSession;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.ApplicationContext;
import org.jboss.seam.contexts.BasicContext;
import org.jboss.seam.contexts.BusinessProcessContext;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.SessionContext;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;
import org.jboss.seam.util.Id;
import org.mobicents.servlet.sip.seam.entrypoint.SipSeamRequestSessionMap;
import org.mobicents.servlet.sip.seam.entrypoint.SipSeamSessionMap;

public class SeamEntrypointUtils {
    public static void setContext(String ctxName, Context newctx) {
        Field field = null;
        try {
            field = Contexts.class.getDeclaredField(ctxName);
            field.setAccessible(true);
            ThreadLocal ctx = (ThreadLocal)field.get(null);
            ctx.set(newctx);
            field.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void beginEvent(SipServletMessage message) {
        BasicContext eventContext = new BasicContext(ScopeType.EVENT);
        eventContext.set("sipServletMessage", (Object)message);
        SeamEntrypointUtils.setContext("applicationContext", (Context)new ApplicationContext(Lifecycle.getApplication()));
        SeamEntrypointUtils.setContext("eventContext", (Context)eventContext);
        SeamEntrypointUtils.setContext("sessionContext", (Context)new SessionContext((Map)new SipSeamRequestSessionMap(message)));
        SeamEntrypointUtils.setContext("conversationContext", (Context)new SessionContext((Map)new SipSeamRequestSessionMap(message)));
        SeamEntrypointUtils.setContext("businessProcessContext", (Context)new BusinessProcessContext());
        SeamEntrypointUtils.simulateConversation(message.getSession());
    }

    public static void beginEvent(SipSession sipSession) {
        SeamEntrypointUtils.setContext("applicationContext", (Context)new ApplicationContext(Lifecycle.getApplication()));
        SeamEntrypointUtils.setContext("eventContext", (Context)new BasicContext(ScopeType.EVENT));
        SeamEntrypointUtils.setContext("sessionContext", (Context)new SessionContext((Map)new SipSeamSessionMap(sipSession)));
        SeamEntrypointUtils.setContext("conversationContext", (Context)new SessionContext((Map)new SipSeamSessionMap(sipSession)));
        SeamEntrypointUtils.setContext("businessProcessContext", (Context)new BusinessProcessContext());
        SeamEntrypointUtils.simulateConversation(sipSession);
    }

    private static void simulateConversation(SipSession session) {
        if (!session.isValid()) {
            return;
        }
        String cid = (String)session.getAttribute("org.mobicents.servlet.sip.conversationId");
        if (cid == null) {
            cid = Id.nextId();
            ArrayList<String> stack = new ArrayList<String>();
            stack.add(cid);
            Manager.instance().setCurrentConversationId(cid);
            Manager.instance().setCurrentConversationIdStack(stack);
            ConversationEntries.instance().createConversationEntry(cid, stack);
            Manager.instance().setLongRunningConversation(true);
            cid = Conversation.instance().getId();
            session.setAttribute("org.mobicents.servlet.sip.conversationId", (Object)cid);
        }
        ConversationEntries entries = ConversationEntries.instance();
        ConversationEntry ce = entries.getConversationEntry(cid);
        Manager.instance().setCurrentConversationIdStack(ce.getConversationIdStack());
        Manager.instance().setCurrentConversationId(ce.getId());
    }

    private static void cleanupConversation(SipSession session) {
        String cid = (String)session.getAttribute("org.mobicents.servlet.sip.conversationId");
        ConversationEntries.instance().removeConversationEntry(cid);
    }

    public static void endEvent() {
        Lifecycle.endRequest();
    }
}

