/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.seam.entrypoint;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.TimerService;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Init;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.mock.MockHttpServletRequest;
import org.jboss.seam.mock.MockHttpSession;
import org.mobicents.servlet.sip.seam.entrypoint.SeamEntrypointUtils;
import org.mobicents.servlet.sip.seam.entrypoint.SipSeamSessionMap;
import org.mobicents.servlet.sip.seam.entrypoint.media.MsProviderContainer;

public class SeamEntryPointServlet
extends SipServlet
implements SipSessionListener {
    private LogProvider log = Logging.getLogProvider(SeamEntryPointServlet.class);

    public void sessionCreated(SipSessionEvent arg0) {
        arg0.getSession().setAttribute("msSession", (Object)MsProviderContainer.msProvider.createSession());
        arg0.getSession().setAttribute("sipSession", (Object)arg0.getSession());
        Lifecycle.beginSession((Map)new SipSeamSessionMap(arg0.getSession()));
        SeamEntrypointUtils.beginEvent(arg0.getSession());
        Contexts.getSessionContext().set("sipSession", (Object)arg0.getSession());
        Contexts.getSessionContext().set("msSession", (Object)MsProviderContainer.msProvider.createSession());
        Contexts.getApplicationContext().set("eventFactory", (Object)MsProviderContainer.msProvider.getEventFactory());
        Events.instance().raiseEvent("sipSessionCreated", new Object[]{arg0.getSession()});
        SeamEntrypointUtils.endEvent();
        this.log.info((Object)"SEAM SIP SESSION CREATED");
    }

    public void sessionDestroyed(SipSessionEvent arg0) {
        SeamEntrypointUtils.beginEvent(arg0.getSession());
        Events.instance().raiseEvent("sipSessionDestroyed", new Object[]{arg0.getSession()});
        SeamEntrypointUtils.endEvent();
        Lifecycle.endSession((Map)new SipSeamSessionMap(arg0.getSession()));
        this.log.info((Object)"SEAM SIP SESSION DESTROYED");
    }

    public void sessionReadyToInvalidate(SipSessionEvent arg0) {
    }

    protected void doRequest(SipServletRequest request) throws ServletException, IOException {
        ServletContext ctx = request.getSession().getServletContext();
        Init init = (Init)ctx.getAttribute(Seam.getComponentName(Init.class));
        if (init != null && init.isDebug()) {
            MockHttpSession session = new MockHttpSession(ctx);
            MockHttpServletRequest r = new MockHttpServletRequest((HttpSession)session);
            try {
                new Initialization(ctx).redeploy((HttpServletRequest)r);
            }
            catch (Exception e) {
                this.log.error((Object)"Unexpected exception while movking the servlet context", (Throwable)e);
            }
        }
        SeamEntrypointUtils.beginEvent((SipServletMessage)request);
        Contexts.getApplicationContext().set("sipFactory", (Object)((SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory")));
        Contexts.getApplicationContext().set("sipSessionsUtil", (Object)((SipSessionsUtil)this.getServletContext().getAttribute("javax.servlet.sip.SipSessionsUtil")));
        Contexts.getApplicationContext().set("timerService", (Object)((TimerService)this.getServletContext().getAttribute("javax.servlet.sip.TimerService")));
        Events.instance().raiseEvent(request.getMethod().toUpperCase(), new Object[]{request});
        SeamEntrypointUtils.endEvent();
    }

    protected void doResponse(SipServletResponse response) throws ServletException, IOException {
        SeamEntrypointUtils.beginEvent((SipServletMessage)response);
        Contexts.getApplicationContext().set("sipFactory", (Object)((SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory")));
        Contexts.getApplicationContext().set("sipSessionsUtil", (Object)((SipSessionsUtil)this.getServletContext().getAttribute("javax.servlet.sip.SipSessionsUtil")));
        Contexts.getApplicationContext().set("timerService", (Object)((TimerService)this.getServletContext().getAttribute("javax.servlet.sip.TimerService")));
        Events.instance().raiseEvent("RESPONSE", new Object[]{response});
        SeamEntrypointUtils.endEvent();
    }
}

