/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.xdm.server.appusage.oma.userprofile;

import javax.xml.validation.Validator;
import org.mobicents.xdm.common.util.dom.DomUtils;
import org.mobicents.xdm.server.appusage.AppUsage;
import org.mobicents.xdm.server.appusage.AppUsageDataSource;
import org.mobicents.xdm.server.appusage.AuthorizationPolicy;
import org.mobicents.xdm.server.appusage.oma.userprofile.OMAUserProfileAuthorizationPolicy;
import org.openxdm.xcap.common.error.ConstraintFailureConflictException;
import org.openxdm.xcap.common.error.InternalServerErrorException;
import org.openxdm.xcap.common.error.UniquenessFailureConflictException;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OMAUserProfileAppUsage
extends AppUsage {
    public static final String ID = "org.openmobilealliance.user-profile";
    public static final String DEFAULT_DOC_NAMESPACE = "urn:oma:xml:xdm:user-profile";
    public static final String MIMETYPE = "application/vnd.oma.user-profile+xml";
    private static final String USER_PROFILE_ELEMENT_NAME = "user-profile";
    private static final String URI_ATTRIBUTE_NAME = "uri";
    private static final String ERROR_PHRASE = "Wrong User Profile URI";

    public OMAUserProfileAppUsage(Validator schemaValidator) {
        this(ID, schemaValidator, new OMAUserProfileAuthorizationPolicy());
    }

    protected OMAUserProfileAppUsage(String auid, Validator schemaValidator, AuthorizationPolicy authorizationPolicy) {
        super(auid, DEFAULT_DOC_NAMESPACE, MIMETYPE, schemaValidator, authorizationPolicy);
    }

    public void checkConstraintsOnPut(Document document, String xcapRoot, DocumentSelector documentSelector, AppUsageDataSource dataSource) throws UniquenessFailureConflictException, InternalServerErrorException, ConstraintFailureConflictException {
        if (!documentSelector.isUserDocument()) {
            return;
        }
        String xui = documentSelector.getUser();
        Element userProfiles = document.getDocumentElement();
        NodeList userProfilesChildNodeList = userProfiles.getChildNodes();
        for (int i = 0; i < userProfilesChildNodeList.getLength(); ++i) {
            Element userProfileElement;
            String userProfileUri;
            Node userProfilesChildNode = userProfilesChildNodeList.item(i);
            if (!DomUtils.isElementNamed((Node)userProfilesChildNode, (String)USER_PROFILE_ELEMENT_NAME) || xui.equals(userProfileUri = (userProfileElement = (Element)userProfilesChildNode).getAttributeNode(URI_ATTRIBUTE_NAME).getNodeValue())) continue;
            throw new ConstraintFailureConflictException(ERROR_PHRASE);
        }
    }
}

