/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.data;

import java.io.Serializable;
import javax.slee.facilities.TimerID;
import org.mobicents.slee.sipevent.server.subscription.data.Notifier;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;

public class Subscription
implements Serializable {
    private static final long serialVersionUID = 8020033417766370446L;
    private final SubscriptionKey key;
    private final String subscriber;
    private final Notifier notifier;
    private Status status;
    private final long creationDate;
    private long lastRefreshDate;
    private int expires;
    private final String subscriberDisplayName;
    private Event lastEvent;
    private TimerID timerID;
    private int version;
    private boolean resourceList;
    private transient SubscriptionControlDataSource dataSource;
    private transient boolean created = false;

    public Subscription(SubscriptionKey key, String subscriber, Notifier notifier, Status status, String subscriberDisplayName, int expires, boolean resourceList, SubscriptionControlDataSource dataSource) {
        this.key = key;
        this.subscriber = subscriber;
        this.notifier = notifier;
        this.status = status;
        if (status.equals((Object)Status.active)) {
            this.lastEvent = Event.approved;
        } else if (status.equals((Object)Status.pending)) {
            this.lastEvent = Event.subscribe;
        }
        this.creationDate = System.currentTimeMillis();
        this.created = true;
        this.lastRefreshDate = this.creationDate;
        this.expires = expires;
        this.subscriberDisplayName = subscriberDisplayName;
        this.version = 0;
        this.resourceList = resourceList;
        this.dataSource = dataSource;
    }

    public int getRemainingExpires() {
        long remainingExpires = (long)this.expires - (System.currentTimeMillis() - this.lastRefreshDate) / 1000L;
        if (remainingExpires < 0L) {
            return 0;
        }
        return (int)remainingExpires;
    }

    public int getSubscriptionDuration() {
        return (int)((System.currentTimeMillis() - this.creationDate) / 1000L);
    }

    public void refresh(int expires) {
        this.lastRefreshDate = System.currentTimeMillis();
        this.expires = expires;
    }

    public boolean changeStatus(Event event) {
        Status oldStatus = this.status;
        if (this.status == Status.active) {
            if (event == Event.noresource || event == Event.rejected || event == Event.deactivated || event == Event.probation || event == Event.timeout) {
                this.status = Status.terminated;
            }
        } else if (this.status == Status.pending) {
            if (event == Event.approved) {
                this.status = Status.active;
            } else if (event == Event.timeout) {
                this.status = Status.waiting;
            } else if (event == Event.noresource || event == Event.rejected || event == Event.deactivated || event == Event.probation || event == Event.giveup) {
                this.status = Status.terminated;
            }
        } else if (this.status == Status.waiting && (event == Event.noresource || event == Event.rejected || event == Event.giveup || event == Event.approved)) {
            this.status = Status.terminated;
        }
        if (this.status != oldStatus) {
            this.lastEvent = event;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((Subscription)obj).key.equals(this.key);
        }
        return false;
    }

    public SubscriptionKey getKey() {
        return this.key;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public long getLastRefreshDate() {
        return this.lastRefreshDate;
    }

    public void setLastRefreshDate(long lastRefreshDate) {
        this.lastRefreshDate = lastRefreshDate;
    }

    public int getExpires() {
        return this.expires;
    }

    public void setExpires(int expires) {
        this.expires = expires;
    }

    public String getSubscriberDisplayName() {
        return this.subscriberDisplayName;
    }

    public Event getLastEvent() {
        return this.lastEvent;
    }

    public void setLastEvent(Event lastEvent) {
        this.lastEvent = lastEvent;
    }

    public TimerID getTimerID() {
        return this.timerID;
    }

    public void setTimerID(TimerID timerID) {
        if (this.timerID != null) {
            this.dataSource.removeTimerReference((Serializable)this.timerID);
        }
        this.timerID = timerID;
        this.dataSource.addTimerReference(this.key, (Serializable)this.timerID);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void incrementVersion() {
        ++this.version;
    }

    public boolean isInternalSubscription() {
        return this.key.isInternalSubscription();
    }

    public boolean isWInfoSubscription() {
        return this.key.isWInfoSubscription();
    }

    public boolean isResourceList() {
        return this.resourceList;
    }

    public void setResourceList(boolean resourceList) {
        this.resourceList = resourceList;
    }

    public String toString() {
        return "subscription: subscriber=" + this.subscriber + ",notifier=" + this.notifier + ",resourceList=" + this.resourceList + ",eventPackage=" + this.key.getEventPackage() + ",eventId=" + this.key.getEventId() + ",status=" + (Object)((Object)this.status);
    }

    public SubscriptionControlDataSource getDataSource() {
        return this.dataSource;
    }

    void setDataSource(SubscriptionControlDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void store() {
        if (this.created) {
            this.dataSource.add(this);
            this.created = false;
        } else {
            this.dataSource.update(this);
        }
    }

    public void remove() {
        this.dataSource.remove(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        noresource,
        rejected,
        deactivated,
        probation,
        timeout,
        approved,
        giveup,
        subscribe;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        active,
        pending,
        waiting,
        terminated;

    }
}

