/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.data;

import java.io.Serializable;

public class SubscriptionKey
implements Serializable {
    private static final long serialVersionUID = -6638892043798746768L;
    public static final String NO_DIALOG_ID = "_";
    private final String dialogId;
    private final String eventPackage;
    private final String eventId;
    private transient Boolean internalSubscription;
    private transient Boolean wInfoSubscription;
    private transient int hashCode = 0;
    private transient String toString = null;
    private static final String WINFO = ".winfo";

    public SubscriptionKey(String dialogId, String eventPackage, String eventId) {
        if (dialogId == null) {
            throw new NullPointerException("null dialog id");
        }
        this.dialogId = dialogId;
        this.eventPackage = eventPackage;
        this.eventId = eventId;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getEventPackage() {
        return this.eventPackage;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = this.dialogId.hashCode();
            result = 31 * result + this.eventPackage.hashCode();
            if (this.eventId != null) {
                result = 31 * result + this.eventId.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionKey other = (SubscriptionKey)obj;
        return this.toString().equals(other.toString());
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder(this.dialogId).append('@').append(this.eventPackage);
            if (this.eventId != null) {
                sb.append('@').append(this.eventId);
            }
            this.toString = sb.toString();
        }
        return this.toString;
    }

    public boolean isInternalSubscription() {
        if (this.internalSubscription == null) {
            this.internalSubscription = this.dialogId.equals(NO_DIALOG_ID);
        }
        return this.internalSubscription;
    }

    public boolean isWInfoSubscription() {
        if (this.wInfoSubscription == null) {
            this.wInfoSubscription = this.eventPackage.endsWith(WINFO);
        }
        return this.wInfoSubscription;
    }
}

