/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.event.CacheStartedEvent;
import org.mobicents.cache.MobicentsCache;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener(sync=false)
public class SubscriptionControlDataSource {
    private final Cache jbcache;
    private Node subRoot;
    private Node timersRoot;
    private Node notifiersRoot;
    private static final String NO_EVENT_ID = "";
    private static final List<Subscription> NO_RESULT = Collections.emptyList();

    public SubscriptionControlDataSource(MobicentsCache cache) {
        this.jbcache = cache.getJBossCache();
        if (this.jbcache.getCacheStatus() != CacheStatus.STARTED) {
            this.jbcache.addCacheListener((Object)this);
        } else {
            this.initNodes();
        }
    }

    @CacheStarted
    public void onCacheStartedEvent(CacheStartedEvent event) {
        this.initNodes();
    }

    private void initNodes() {
        Node root = this.jbcache.getRoot();
        this.subRoot = this.jbcache.getRoot().addChild(Fqn.fromElements((Object[])new String[]{"msps-sub"}));
        this.notifiersRoot = this.jbcache.getRoot().addChild(Fqn.fromElements((Object[])new String[]{"msps-sub-notifiers"}));
        this.timersRoot = this.jbcache.getRoot().addChild(Fqn.fromElements((Object[])new String[]{"msps-sub-timers"}));
    }

    void add(Subscription s) {
        String eventId;
        Node eventIdNode;
        Node eventPackageNode;
        SubscriptionKey sk = s.getKey();
        Node dialogIdNode = this.subRoot.getChild((Object)sk.getDialogId());
        if (dialogIdNode == null) {
            dialogIdNode = this.subRoot.addChild(Fqn.fromElements((Object[])new String[]{sk.getDialogId()}));
        }
        if ((eventPackageNode = dialogIdNode.getChild((Object)sk.getEventPackage())) == null) {
            eventPackageNode = dialogIdNode.addChild(Fqn.fromElements((Object[])new String[]{sk.getEventPackage()}));
        }
        if ((eventIdNode = eventPackageNode.getChild((Object)(eventId = sk.getEventId() == null ? NO_EVENT_ID : sk.getEventId()))) != null) {
            throw new IllegalStateException("subscription " + sk + " already exists");
        }
        eventIdNode = eventPackageNode.addChild(Fqn.fromElements((Object[])new String[]{eventId}));
        eventIdNode.put((Object)Boolean.TRUE, (Object)s);
        this.notifiersRoot.addChild(Fqn.fromElements((Object[])new Serializable[]{s.getNotifier().getUri(), sk}));
        s.setDataSource(this);
    }

    private Node getSubscriptionNode(SubscriptionKey sk) {
        Node dialogIdNode = this.subRoot.getChild((Object)sk.getDialogId());
        if (dialogIdNode == null) {
            return null;
        }
        Node eventPackageNode = dialogIdNode.getChild((Object)sk.getEventPackage());
        if (eventPackageNode == null) {
            return null;
        }
        String eventId = sk.getEventId() == null ? NO_EVENT_ID : sk.getEventId();
        return eventPackageNode.getChild((Object)eventId);
    }

    public Subscription get(SubscriptionKey sk) {
        Node subscriptionNode = this.getSubscriptionNode(sk);
        if (subscriptionNode == null) {
            return null;
        }
        Subscription s = (Subscription)subscriptionNode.get((Object)Boolean.TRUE);
        s.setDataSource(this);
        return s;
    }

    public Subscription getFromTimerID(Serializable timerID) {
        Node timerIDNode = this.timersRoot.getChild((Object)timerID);
        if (timerIDNode == null) {
            return null;
        }
        return this.get((SubscriptionKey)timerIDNode.get((Object)Boolean.TRUE));
    }

    public List<Subscription> getSubscriptionsByNotifierAndEventPackage(String notifier, String eventPackage) {
        List<Subscription> result = null;
        Node notifierNode = this.notifiersRoot.getChild((Object)notifier);
        if (notifierNode == null) {
            result = NO_RESULT;
        } else {
            result = new ArrayList<Subscription>();
            Subscription s = null;
            for (SubscriptionKey sk : notifierNode.getChildrenNames()) {
                if (eventPackage != null && !eventPackage.equals(sk.getEventPackage()) || (s = this.get(sk)) == null) continue;
                s.setDataSource(this);
                result.add(s);
            }
        }
        return result;
    }

    public List<Subscription> getSubscriptionsByNotifier(String notifier) {
        return this.getSubscriptionsByNotifierAndEventPackage(notifier, null);
    }

    public List<Subscription> getSubscriptionsByDialog(String dialogId) {
        List<Subscription> result = null;
        Node dialogIdNode = this.subRoot.getChild((Object)dialogId);
        if (dialogIdNode == null) {
            result = NO_RESULT;
        } else {
            result = new ArrayList<Subscription>();
            Subscription s = null;
            for (Node eventPackageNode : dialogIdNode.getChildren()) {
                for (Node eventIdNode : eventPackageNode.getChildren()) {
                    s = (Subscription)eventIdNode.get((Object)Boolean.TRUE);
                    s.setDataSource(this);
                }
            }
        }
        return result;
    }

    void update(Subscription s) {
        Node subscriptionNode = this.getSubscriptionNode(s.getKey());
        if (subscriptionNode == null) {
            throw new IllegalStateException("original subscription " + s.getKey() + " not found");
        }
        subscriptionNode.put((Object)Boolean.TRUE, (Object)s);
    }

    void addTimerReference(SubscriptionKey sk, Serializable timerId) {
        this.timersRoot.addChild(Fqn.fromElements((Object[])new Serializable[]{timerId})).put((Object)Boolean.TRUE, (Object)sk);
    }

    void removeTimerReference(Serializable timerId) {
        this.timersRoot.removeChild((Object)timerId);
    }

    void remove(Subscription s) {
        SubscriptionKey sk = s.getKey();
        Node dialogIdNode = this.subRoot.getChild((Object)sk.getDialogId());
        if (dialogIdNode == null) {
            return;
        }
        Node eventPackageNode = dialogIdNode.getChild((Object)sk.getEventPackage());
        if (eventPackageNode == null) {
            return;
        }
        String eventId = sk.getEventId() == null ? NO_EVENT_ID : sk.getEventId();
        eventPackageNode.removeChild((Object)eventId);
        if (eventPackageNode.isLeaf()) {
            dialogIdNode.removeChild((Object)sk.getEventPackage());
        }
        if (dialogIdNode.isLeaf()) {
            this.subRoot.removeChild((Object)sk.getDialogId());
        }
        this.removeTimerReference((Serializable)s.getTimerID());
        Node notifierNode = this.notifiersRoot.getChild((Object)s.getNotifier().getUri());
        if (notifierNode == null) {
            return;
        }
        notifierNode.removeChild((Object)sk);
        if (notifierNode.isLeaf()) {
            this.notifiersRoot.removeChild((Object)s.getNotifier().getUri());
        }
    }
}

