/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.tts.ra;

import java.io.Serializable;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.tts.ra.TTSActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.tts.ra.TTSProviderImpl;
import org.mobicents.slee.resource.tts.ratype.TTSActivityContextInterfaceFactory;
import org.mobicents.slee.resource.tts.ratype.TTSProvider;

public class TTSResourceAdaptor
implements ResourceAdaptor,
Serializable {
    private static transient Logger logger = Logger.getLogger(TTSResourceAdaptor.class);
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient HashMap activities = null;
    private transient TTSProvider raProvider = null;
    private transient TTSActivityContextInterfaceFactory acif = null;

    public void activityEnded(ActivityHandle activityHandle) {
        this.activities.remove(activityHandle);
        logger.debug((Object)"TTSResourceAdaptor.activityEnded() called.");
    }

    public void activityUnreferenced(ActivityHandle arg0) {
        logger.debug((Object)"TTSResourceAdaptor.activityUnreferenced() called.");
    }

    public void entityActivated() throws ResourceException {
        logger.debug((Object)"TTSResourceAdaptor.entityActivated() called.");
        try {
            logger.debug((Object)"Starting ");
            try {
                this.raProvider = new TTSProviderImpl(this);
                this.initializeNamingContext();
            }
            catch (Exception ex) {
                logger.error((Object)"TTSResourceAdaptor.start(): Exception caught! ");
                ex.printStackTrace();
                throw new ResourceException(ex.getMessage());
            }
            this.activities = new HashMap();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("TTSResourceAdaptor.entityActivated(): Failed to activate TTS Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        logger.debug((Object)"TTSResourceAdaptor.entityCreated() called.");
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
    }

    public void entityDeactivated() {
        logger.debug((Object)"TTSResourceAdaptor.entityDeactivated() called.");
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind naming context");
        }
        logger.debug((Object)"TTS Resource Adaptor stopped.");
    }

    public void entityDeactivating() {
        logger.debug((Object)"TTSResourceAdaptor.entityDeactivating() called.");
    }

    public void entityRemoved() {
        logger.debug((Object)"TTSResourceAdaptor.entityRemoved() called.");
    }

    public void eventProcessingFailed(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4, FailureReason arg5) {
        logger.debug((Object)"TTSResourceAdaptor.eventProcessingFailed() called.");
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4) {
        logger.debug((Object)"TTSResourceAdaptor.eventProcessingSuccessful() called.");
    }

    public Object getActivity(ActivityHandle activityHandle) {
        logger.debug((Object)"TTSResourceAdaptor.getActivity() called.");
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        logger.debug((Object)"TTSResourceAdaptor.getActivityHandle(obj) called.");
        return null;
    }

    public Marshaler getMarshaler() {
        logger.debug((Object)"TTSResourceAdaptor.getMarshaler() called.");
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String str) {
        logger.debug((Object)("TTSResourceAdaptor.getSBBResourceAdapterInterface(" + str + ") called."));
        return this.raProvider;
    }

    public void queryLiveness(ActivityHandle arg0) {
        logger.debug((Object)"TTSResourceAdaptor.queryLifeness() called.");
    }

    public void serviceActivated(String arg0) {
        logger.debug((Object)"TTSResourceAdaptor.serviceActivated() called.");
    }

    public void serviceDeactivated(String arg0) {
        logger.debug((Object)"TTSResourceAdaptor.serviceDeactivated() called.");
    }

    public void serviceInstalled(String arg0, int[] arg1, String[] arg2) {
        logger.debug((Object)"TTSResourceAdaptor.serviceInstalled() called.");
    }

    public void serviceUninstalled(String arg0) {
        logger.debug((Object)"TTSResourceAdaptor.serviceUninstalled() called.");
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new TTSActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                logger.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)e);
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                logger.debug((Object)("JNDI name to unregister: " + javaJNDIName));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.debug((Object)"JNDI name unregistered.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)e);
        }
    }

    SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }
}

