/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resources.smpp;

import net.java.slee.resources.smpp.pdu.SmppRequest;
import org.mobicents.slee.resources.smpp.SmppResourceAdaptor;
import org.mobicents.slee.resources.smpp.pdu.AlertNotificationImpl;
import org.mobicents.slee.resources.smpp.pdu.CancelSMImpl;
import org.mobicents.slee.resources.smpp.pdu.DataSMImpl;
import org.mobicents.slee.resources.smpp.pdu.DeliverSMImpl;
import org.mobicents.slee.resources.smpp.pdu.QuerySMImpl;
import org.mobicents.slee.resources.smpp.pdu.ReplaceSMImpl;
import org.mobicents.slee.resources.smpp.pdu.SubmitMultiImpl;
import org.mobicents.slee.resources.smpp.pdu.SubmitSMImpl;

public class Utils {
    protected static final String ALERT_NOTIFICATION = "net.java.slee.resources.smpp.ALERT_NOTIFICATION";
    protected static final String GENERIC_NACK = "net.java.slee.resources.smpp.GENERIC_NACK";
    protected static final String DELIVER_SM = "net.java.slee.resources.smpp.DELIVER_SM";
    protected static final String DELIVER_SM_RESP = "net.java.slee.resources.smpp.DELIVER_SM_RESP";
    protected static final String DELIVERY_REPORT = "net.java.slee.resources.smpp.DELIVERY_REPORT";
    protected static final String SUBMIT_SM = "net.java.slee.resources.smpp.SUBMIT_SM";
    protected static final String SUBMIT_SM_RESP = "net.java.slee.resources.smpp.SUBMIT_SM_RESP";
    protected static final String DATA_SM = "net.java.slee.resources.smpp.DATA_SM";
    protected static final String DATA_SM_RESP = "net.java.slee.resources.smpp.DATA_SM_RESP";
    protected static final String SUBMIT_MULTI = "net.java.slee.resources.smpp.SUBMIT_MULTI";
    protected static final String SUBMIT_MULTI_RESP = "net.java.slee.resources.smpp.SUBMIT_MULTI_RESP";
    protected static final String QUERY_SM = "net.java.slee.resources.smpp.QUERY_SM";
    protected static final String QUERY_SM_RESP = "net.java.slee.resources.smpp.QUERY_SM_RESP";
    protected static final String CANCEL_SM = "net.java.slee.resources.smpp.CANCEL_SM";
    protected static final String CANCEL_SM_RESP = "net.java.slee.resources.smpp.CANCEL_SM_RESP";
    protected static final String REPLACE_SM = "net.java.slee.resources.smpp.REPLACE_SM";
    protected static final String REPLACE_SM_RESP = "net.java.slee.resources.smpp.REPLACE_SM_RESP";
    protected static final String SMPP_TIMEOUT_RESPONSE_SENT = "net.java.slee.resources.smpp.SMPP_TIMEOUT_RESPONSE_SENT";
    protected static final String SMPP_TIMEOUT_RESPONSE_RECEIVED = "net.java.slee.resources.smpp.SMPP_TIMEOUT_RESPONSE_RECEIVED";
    protected static final String BROADCAST_SM = "net.java.slee.resources.smpp.BROADCAST_SM";
    protected static final String BROADCAST_SM_RESP = "net.java.slee.resources.smpp.BROADCAST_SM_RESP";
    protected static final String CANCEL_BROADCAST_SM = "net.java.slee.resources.smpp.CANCEL_BROADCAST_SM";
    protected static final String CANCEL_BROADCAST_SM_RESP = "net.java.slee.resources.smpp.CANCEL_BROADCAST_SM_RESP";
    protected static final String QUERY_BROADCAST_SM = "net.java.slee.resources.smpp.QUERY_BROADCAST_SM";
    protected static final String QUERY_BROADCAST_SM_RESP = "net.java.slee.resources.smpp.QUERY_BROADCAST_SM_RESP";
    private SmppResourceAdaptor smppResourceAdaptor;

    protected Utils(SmppResourceAdaptor smppResourceAdaptor) {
        this.smppResourceAdaptor = smppResourceAdaptor;
    }

    protected String getAddressForEventFire(SmppRequest smppRequest) {
        long commandId = smppRequest.getCommandId();
        if (commandId == 258L) {
            return ((AlertNotificationImpl)smppRequest).getEsmeAddress().getAddress();
        }
        if (commandId == 8L) {
            return ((CancelSMImpl)smppRequest).getSourceAddress().getAddress();
        }
        if (commandId == 259L) {
            return ((DataSMImpl)smppRequest).getSourceAddress().getAddress();
        }
        if (commandId == 5L) {
            return ((DeliverSMImpl)smppRequest).getDestAddress().getAddress();
        }
        if (commandId == 3L) {
            return ((QuerySMImpl)smppRequest).getSourceAddress().getAddress();
        }
        if (commandId == 7L) {
            return ((ReplaceSMImpl)smppRequest).getSourceAddress().getAddress();
        }
        if (commandId == 33L) {
            return ((SubmitMultiImpl)smppRequest).getSourceAddress().getAddress();
        }
        if (commandId == 4L) {
            return ((SubmitSMImpl)smppRequest).getSourceAddress().getAddress();
        }
        return null;
    }

    protected String statusMessage(int status) {
        switch (status) {
            case 0: {
                return "No Error";
            }
            case 1: {
                return "Message Length is invalid";
            }
            case 2: {
                return "Command Length is invalid";
            }
            case 3: {
                return "Invalid Command ID";
            }
            case 4: {
                return "Incorrect BIND Status for given command";
            }
            case 5: {
                return "ESME Already in Bound State";
            }
            case 6: {
                return "Invalid Priority Flag";
            }
            case 7: {
                return "Invalid Registered Delivery Flag";
            }
            case 8: {
                return "System Error";
            }
            case 10: {
                return "Invalid Source Address";
            }
            case 11: {
                return "Invalid Dest Addr";
            }
            case 12: {
                return "Message ID is invalid";
            }
            case 13: {
                return "Bind Failed";
            }
            case 14: {
                return "Invalid Password";
            }
            case 15: {
                return "Invalid System ID";
            }
            case 17: {
                return "Cancel SM Failed";
            }
            case 19: {
                return "Replace SM Failed";
            }
            case 20: {
                return "Message Queue Full";
            }
            case 21: {
                return "Invalid Service Type";
            }
            case 51: {
                return "Invalid number of destinations";
            }
            case 52: {
                return "Invalid Distribution List name";
            }
            case 64: {
                return "Destination flag is invalid (submit_multi)";
            }
            case 66: {
                return "Invalid \u201a\u00c4\u00f2submit with replace\u201a\u00c4\u00f4 request (i.e. submit_sm with replace_if_present_flag set)";
            }
            case 67: {
                return "Invalid esm_class field data";
            }
            case 68: {
                return "Cannot Submit to Distribution List";
            }
            case 69: {
                return "submit_sm or submit_multi failed";
            }
            case 72: {
                return "Invalid Source address TON";
            }
            case 73: {
                return "Invalid Source address NPI";
            }
            case 80: {
                return "Invalid Destination address TON";
            }
            case 81: {
                return "Invalid Destination address NPI";
            }
            case 83: {
                return "Invalid system_type field";
            }
            case 84: {
                return "Invalid replace_if_present flag";
            }
            case 85: {
                return "Invalid number of messages";
            }
            case 88: {
                return "Throttling error (ESME has exceeded allowed message limits)";
            }
            case 97: {
                return "Invalid Scheduled Delivery Time";
            }
            case 98: {
                return "Invalid message validity period (Expiry time)";
            }
            case 99: {
                return "Predefined Message Invalid or Not Found";
            }
            case 100: {
                return "ESME Receiver Temporary App Error Code";
            }
            case 101: {
                return "ESME Receiver Permanent App Error Code";
            }
            case 102: {
                return "ESME Receiver Reject Message Error Code";
            }
            case 103: {
                return "query_sm request failed";
            }
            case 254: {
                return "Delivery   Failure (used for data_sm_resp)";
            }
            case 255: {
                return "Unknown Error";
            }
            case -1: {
                return "Some exception occured. Look at log files";
            }
        }
        return "Unknonw ststus code " + status;
    }
}

