/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.RouteHeader;
import org.mobicents.slee.resource.sip11.DialogWithoutIdActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.wrappers.ClientDialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogForkState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientDialogWrapperData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ClientDialogWrapper owner;
    private boolean routeSetOnRequest = false;
    private SipURI requestURI;
    private AtomicLong localSequenceNumber = new AtomicLong(0L);
    private DialogWithoutIdActivityHandle forkInitialActivityHandle;
    private DialogForkState forkState = DialogForkState.AWAIT_FIRST_TAG;
    private transient ArrayList<RouteHeader> localRouteSet;
    private transient ConcurrentHashMap<String, DialogWithoutIdActivityHandle> toTag2DialogHandle;
    private Address fromAddress;
    private Address toAddress;
    private CallIdHeader customCallId = null;
    private String localRemoteTag = null;
    private SipActivityHandle[] EMPTY_HANDLE_ARRAY = new SipActivityHandle[0];
    private RouteHeader[] EMPTY_RH_ARRAY = new RouteHeader[0];

    public ClientDialogWrapperData(ClientDialogWrapper owner) {
        this.owner = owner;
        this.localRouteSet = new ArrayList();
        this.toTag2DialogHandle = new ConcurrentHashMap();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.isInForkedActions()) {
            SipActivityHandle[] childDialogHandles = this.toTag2DialogHandle.values().toArray(this.EMPTY_HANDLE_ARRAY);
            stream.writeObject(childDialogHandles);
            RouteHeader[] routeHeaders = this.localRouteSet.toArray(this.EMPTY_RH_ARRAY);
            stream.writeObject(routeHeaders);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.localRouteSet = new ArrayList();
        this.toTag2DialogHandle = new ConcurrentHashMap();
        if (this.isInForkedActions()) {
            for (SipActivityHandle sipActivityHandle : (SipActivityHandle[])stream.readObject()) {
                DialogWithoutIdActivityHandle dwiah = (DialogWithoutIdActivityHandle)sipActivityHandle;
                this.toTag2DialogHandle.put(dwiah.getRemoteTag(), dwiah);
            }
            for (SipActivityHandle sipActivityHandle : (RouteHeader[])stream.readObject()) {
                this.localRouteSet.add((RouteHeader)sipActivityHandle);
            }
        }
    }

    public ClientDialogWrapper getOwner() {
        return this.owner;
    }

    public void setOwner(ClientDialogWrapper owner) {
        this.owner = owner;
    }

    public boolean isRouteSetOnRequest() {
        return this.routeSetOnRequest;
    }

    public void setRouteSetOnRequest(boolean routeSetOnRequest) {
        this.routeSetOnRequest = routeSetOnRequest;
    }

    public SipURI getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(SipURI requestURI) {
        this.requestURI = requestURI;
    }

    public AtomicLong getLocalSequenceNumber() {
        return this.localSequenceNumber;
    }

    public void setLocalSequenceNumber(AtomicLong localSequenceNumber) {
        this.localSequenceNumber = localSequenceNumber;
    }

    public DialogWithoutIdActivityHandle getForkInitialActivityHandle() {
        return this.forkInitialActivityHandle;
    }

    public void setForkInitialActivityHandle(DialogWithoutIdActivityHandle forkInitialActivityHandle) {
        this.forkInitialActivityHandle = forkInitialActivityHandle;
    }

    public DialogForkState getForkState() {
        return this.forkState;
    }

    public void setForkState(DialogForkState forkState) {
        this.forkState = forkState;
    }

    public Address getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
    }

    public Address getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(Address toAddress) {
        this.toAddress = toAddress;
    }

    public CallIdHeader getCustomCallId() {
        return this.customCallId;
    }

    public void setCustomCallId(CallIdHeader callIdToReUse) {
        this.customCallId = callIdToReUse;
    }

    public String getLocalRemoteTag() {
        return this.localRemoteTag;
    }

    public void setLocalRemoteTag(String localRemoteTag) {
        this.localRemoteTag = localRemoteTag;
    }

    public boolean isInForkedActions() {
        return this.forkInitialActivityHandle != null || this.forkState == DialogForkState.AWAIT_FINAL;
    }

    public List<RouteHeader> getRouteSet() {
        return new ArrayList<RouteHeader>(this.localRouteSet);
    }

    public Set<String> getTagsMappedToDialogs() {
        return this.toTag2DialogHandle.keySet();
    }

    public DialogWithoutIdActivityHandle getDialogMappedToTag(String tag) {
        return this.toTag2DialogHandle.get(tag);
    }

    public DialogWithoutIdActivityHandle unmapDialogMappedToTag(String tag) {
        return this.toTag2DialogHandle.remove(tag);
    }

    public void addToRouteSet(RouteHeader routeHeader) {
        this.localRouteSet.add(routeHeader);
    }

    public void addAlltoRouteSet(List<RouteHeader> routeList) {
        this.localRouteSet.addAll(routeList);
    }

    public void clearRouteSet() {
        this.localRouteSet.clear();
    }

    public void mapTagToDialog(String tag, DialogWithoutIdActivityHandle handle) {
        this.toTag2DialogHandle.put(tag, handle);
    }

    public boolean tagIsMapped(String tag) {
        return this.toTag2DialogHandle.containsKey(tag);
    }
}

