/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import java.util.concurrent.ConcurrentHashMap;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.facilities.EventLookupFacility;

public class EventIDCache {
    private static final String OUT_OF_DIALOG_REQUEST_EVENT_PREFIX = "javax.sip.message.Request.";
    private static final String RESPONSE_EVENT_PREFIX = "javax.sip.message.Response.";
    private static final String INDIALOG_REQUEST_EVENT_PREFIX = "javax.sip.Dialog.";
    private static final String SIP_EXTENSION_REQUEST_EVENT_NAME_SUFIX = "SIP_EXTENSION";
    private static final String VENDOR = "net.java.slee";
    private static final String VERSION = "1.2";
    private static final String TRANSACTION_TIMEOUT_EVENTNAME = "javax.sip.Timeout.TRANSACTION";
    private static final String DIALOG_TIMEOUT_EVENTNAME = "javax.sip.Timeout.Dialog";
    private static final String DIALOG_FORKED_EVENTNAME = "javax.sip.Dialog.FORKED";
    private ConcurrentHashMap<String, Integer> eventIds = new ConcurrentHashMap();

    public int getEventId(EventLookupFacility eventLookupFacility, Request request, boolean inDialogActivity) {
        String requestMethod = request.getMethod();
        if (requestMethod.equals("CANCEL")) {
            inDialogActivity = false;
        }
        int eventID = -1;
        if (inDialogActivity) {
            eventID = this.getEventId(eventLookupFacility, INDIALOG_REQUEST_EVENT_PREFIX + requestMethod);
            if (eventID == -1) {
                eventID = this.getEventId(eventLookupFacility, "javax.sip.Dialog.SIP_EXTENSION");
            }
        } else {
            eventID = this.getEventId(eventLookupFacility, OUT_OF_DIALOG_REQUEST_EVENT_PREFIX + requestMethod);
            if (eventID == -1) {
                eventID = this.getEventId(eventLookupFacility, "javax.sip.message.Request.SIP_EXTENSION");
            }
        }
        return eventID;
    }

    public int getEventId(EventLookupFacility eventLookupFacility, Response response) {
        String statusCodeName = null;
        int responseStatus = response.getStatusCode();
        statusCodeName = responseStatus == 100 ? "TRYING" : (100 < responseStatus && responseStatus < 200 ? "PROVISIONAL" : (responseStatus < 300 ? "SUCCESS" : (responseStatus < 400 ? "REDIRECT" : (responseStatus < 500 ? "CLIENT_ERROR" : (responseStatus < 600 ? "SERVER_ERROR" : "GLOBAL_FAILURE")))));
        return this.getEventId(eventLookupFacility, RESPONSE_EVENT_PREFIX + statusCodeName);
    }

    public int getTransactionTimeoutEventId(EventLookupFacility eventLookupFacility, boolean inDialog) {
        return this.getEventId(eventLookupFacility, TRANSACTION_TIMEOUT_EVENTNAME);
    }

    public int getDialogTimeoutEventId(EventLookupFacility eventLookupFacility) {
        return this.getEventId(eventLookupFacility, DIALOG_TIMEOUT_EVENTNAME);
    }

    public int getDialogForkEventId(EventLookupFacility eventLookupFacility) {
        return this.getEventId(eventLookupFacility, DIALOG_FORKED_EVENTNAME);
    }

    private int getEventId(EventLookupFacility eventLookupFacility, String eventName) {
        Integer integer = this.eventIds.get(eventName);
        if (integer == null) {
            try {
                integer = eventLookupFacility.getEventID(eventName, VENDOR, VERSION);
            }
            catch (Exception e) {
                integer = -1;
            }
            this.eventIds.put(eventName, integer);
        }
        return integer;
    }
}

