/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.fw.access;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.fw.fw_access.trust_and_security.IpClientAPILevelAuthenticationPOA;
import org.mobicents.slee.resource.parlay.fw.access.TSMBean;
import org.mobicents.slee.resource.parlay.util.Convert;
import org.mobicents.slee.resource.parlay.util.crypto.CHAPUtil;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtil;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtilException;
import org.omg.PortableServer.POA;

public class IpClientAPILevelAuthenticationImpl
extends IpClientAPILevelAuthenticationPOA {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final Log logger = LogFactory.getLog(IpClientAPILevelAuthenticationImpl.class);
    private static final String RECEIVED = "Received ";
    private static final String EXITING = "Exiting ";
    private static final String CLIENTAPILEVELAUTHENTICATION = "org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication";
    private static final String AUTHENTICATE = ".authenticate()";
    private static final String CHALLENGE = ".challenge()";
    private static final String AUTHENTICATION_SUCCEEDED = ".authenticationSucceeded()";
    private static final String ABORT_AUTHENTICATION = ".abortAuthentication()";
    private TSMBean tsmBean = null;
    private boolean clean = false;
    boolean isClient = false;
    POA _poa = null;
    private CHAPUtil chapUtil = null;

    public IpClientAPILevelAuthenticationImpl(POA the_poa) {
        this._poa = the_poa;
        this.chapUtil = new CHAPUtil();
    }

    public IpClientAPILevelAuthenticationImpl() {
        this.chapUtil = new CHAPUtil();
    }

    public static IpClientAPILevelAuthenticationImpl _create(POA the_poa) {
        return new IpClientAPILevelAuthenticationImpl(the_poa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] authenticate(byte[] challenge) {
        byte[] response = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication.authenticate()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Challenge = <<" + Convert.toHexString(challenge) + ">>"));
        }
        try {
            Object object = this.tsmBean.getAuthenticationMonitor();
            synchronized (object) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Attempting to decrypt framework authentication challenge");
                }
                String decryptionMethod = this.tsmBean.getEncryptionMethod();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Decryption method = " + decryptionMethod));
                }
                response = this.decryptChallenge(challenge, decryptionMethod);
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Unexpected exception decrypting challenge.", (Throwable)ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication.authenticate()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Response = <<" + Convert.toHexString(response) + ">>"));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] challenge(byte[] chapChallenge) {
        byte[] response = null;
        byte[] challenge = null;
        byte[] hashChallenge = null;
        int VALUE_SIZE = 4;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication.challenge()");
            logger.debug((Object)("ChapChallenge: " + Convert.toHexString(chapChallenge)));
        }
        challenge = new byte[chapChallenge[VALUE_SIZE]];
        for (int i = 0; i < chapChallenge[VALUE_SIZE]; ++i) {
            challenge[i] = chapChallenge[i + VALUE_SIZE + 1];
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Challenge = <<" + Convert.toHexString(challenge) + ">>"));
        }
        try {
            Object i = this.tsmBean.getAuthenticationMonitor();
            synchronized (i) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Attempting to decrypt framework authentication challenge");
                }
                String hashMechanism = this.tsmBean.getFwProperties().getAuthenticationHash();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Hash Mechanism = " + hashMechanism));
                }
                if (hashMechanism.equalsIgnoreCase("P_OSA_MD5")) {
                    hashChallenge = this.chapUtil.generateMD5HashChallenge(chapChallenge[1], this.tsmBean.getFwProperties().getSharedSecret(), challenge);
                } else {
                    logger.error((Object)"The Authentication Mechanism was not recognised, hashing cannot continue!");
                }
                response = this.chapUtil.generateCHAPResponsePacket(chapChallenge[1], hashChallenge, this.tsmBean.getFwProperties().getResponseName().getBytes());
            }
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error((Object)"Exception decrypting challenge: Cryptographic algorithm requested not available in the environment.", (Throwable)ex);
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Unexpected exception decrypting challenge.", (Throwable)ex);
            ex.printStackTrace();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication.challenge()");
            logger.debug((Object)("Response = <<" + Convert.toHexString(response) + ">>"));
        }
        return response;
    }

    public void abortAuthentication() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication.abortAuthentication()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication.abortAuthentication()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticationSucceeded() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication.authenticationSucceeded()");
        }
        Object object = this.tsmBean.getAuthenticationMonitor();
        synchronized (object) {
            this.tsmBean.setFwAuthenticationSucceeded(true);
            this.tsmBean.getAuthenticationMonitor().notify();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting org::csapi::fw::fwaccess::trust_and_security::IpClientAPILevelAuthentication.authenticationSucceeded()");
        }
    }

    public void setTSMBean(TSMBean tsmBean) {
        this.tsmBean = tsmBean;
    }

    private byte[] decryptChallenge(byte[] challenge, String decryptionMethod) {
        byte[] decryptedChallenge = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Decrypting challenge.");
        }
        int keySize = 0;
        PrivateKey privateKey = null;
        try {
            if (decryptionMethod.startsWith("P_RSA")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RSA Dencryption.");
                }
                if (decryptionMethod.equals("P_RSA_1024")) {
                    keySize = 1024;
                } else if (decryptionMethod.equals("P_RSA_512")) {
                    keySize = 512;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Key Size = " + keySize));
                }
                privateKey = RSAUtil.getPrivateKey(this.tsmBean.getClientID());
                decryptedChallenge = RSAUtil.decryptMessage(challenge, privateKey, this.tsmBean.getFwProperties().getDecryptionCipherAlgorithm());
            } else if (decryptionMethod.equals("NULL")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No decryption transform needed.");
                }
                decryptedChallenge = challenge;
            }
        }
        catch (RSAUtilException ex) {
            logger.error((Object)("Could not decrypt framework challenge " + ex.toString()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Decrypted challenge :" + new String(decryptedChallenge) + lineSeparator));
        }
        return decryptedChallenge;
    }

    public String toString() {
        StringBuffer value = new StringBuffer("ClientAPILevelAuthenticationImpl");
        value.append(lineSeparator);
        return value.toString();
    }

    public synchronized void cleanup() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning up " + this.toString()));
        }
        if (!this.clean) {
            this.tsmBean = null;
            this.clean = true;
        }
    }

    public POA _default_POA() {
        if (this._poa != null) {
            return this._poa;
        }
        return super._default_POA();
    }
}

