/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.ui.eventHandlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.ui.TpUIFault;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui.AbstractUI;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManager;

public class UserInteractionFaultDetectedHandler
implements Runnable {
    private static final Log logger = LogFactory.getLog(UserInteractionFaultDetectedHandler.class);
    private final transient UIManager uiManager;
    private final transient int userInteractionSessionID;
    private final transient TpUIFault fault;

    public UserInteractionFaultDetectedHandler(UIManager uiManager, int userInteractionSessionID, TpUIFault fault) {
        this.uiManager = uiManager;
        this.userInteractionSessionID = userInteractionSessionID;
        this.fault = fault;
    }

    public void run() {
        try {
            if (this.uiManager != null) {
                AbstractUI ui = this.uiManager.getAbstractUI(this.userInteractionSessionID);
                if (ui != null) {
                    ui.userInteractionFaultDetected(this.userInteractionSessionID, this.fault);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"AbstractUI activity no longer exists.");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"UIManager activity no longer exists.");
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"UserInteractionFaultDetectedHandler failed", (Throwable)e);
        }
    }
}

