/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycallcontrolmanager;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.IpInterface;
import org.csapi.P_INVALID_ADDRESS;
import org.csapi.P_INVALID_ASSIGNMENT_ID;
import org.csapi.P_INVALID_CRITERIA;
import org.csapi.P_INVALID_EVENT_TYPE;
import org.csapi.P_INVALID_INTERFACE_TYPE;
import org.csapi.P_UNSUPPORTED_ADDRESS_PLAN;
import org.csapi.TpAddressRange;
import org.csapi.TpCommonExceptions;
import org.csapi.cc.TpCallLoadControlMechanism;
import org.csapi.cc.TpCallNotificationInfo;
import org.csapi.cc.TpCallNotificationRequest;
import org.csapi.cc.TpCallTreatment;
import org.csapi.cc.TpNotificationRequested;
import org.csapi.cc.TpNotificationRequestedSetEntry;
import org.csapi.cc.mpccs.IpAppMultiPartyCall;
import org.csapi.cc.mpccs.IpAppMultiPartyCallControlManager;
import org.csapi.cc.mpccs.IpAppMultiPartyCallControlManagerHelper;
import org.csapi.cc.mpccs.IpAppMultiPartyCallHelper;
import org.csapi.cc.mpccs.IpMultiPartyCallControlManager;
import org.csapi.cc.mpccs.TpCallLegIdentifier;
import org.csapi.cc.mpccs.TpMultiPartyCallIdentifier;
import org.mobicents.csapi.jr.slee.TpServiceIdentifier;
import org.mobicents.csapi.jr.slee.cc.mpccs.CallAbortedEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.CallOverloadCeasedEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.CallOverloadEncounteredEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.IpMultiPartyCallConnection;
import org.mobicents.csapi.jr.slee.cc.mpccs.ManagerInterruptedEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.ManagerResumedEvent;
import org.mobicents.csapi.jr.slee.cc.mpccs.ReportNotificationEvent;
import org.mobicents.slee.resource.parlay.csapi.jr.ParlayServiceActivityHandle;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.IpAppMultiPartyCallControlManagerImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.IpAppMultiPartyCallImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.IpMultiPartyCallConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.MpccsListener;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.callleg.CallLeg;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.callleg.CallLegImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycall.MultiPartyCall;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycall.MultiPartyCallImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycallcontrolmanager.MultiPartyCallControlManager;
import org.mobicents.slee.resource.parlay.fw.FwSession;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.ResourceIDFactory;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;
import org.mobicents.slee.resource.parlay.util.corba.POAFactory;
import org.mobicents.slee.resource.parlay.util.corba.PolicyFactory;
import org.mobicents.slee.resource.parlay.util.corba.ServantActivationHelper;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public final class MultiPartyCallControlManagerImpl
implements MultiPartyCallControlManager {
    private static final Log logger = LogFactory.getLog(MultiPartyCallControlManagerImpl.class);
    private transient FwSession fwSession = null;
    private transient IpMultiPartyCallControlManager ipMultiPartyCallControlManager;
    private transient IpAppMultiPartyCallControlManagerImpl ipAppMultiPartyCallControlManagerImpl;
    private transient IpAppMultiPartyCallControlManager ipAppMultiPartyCallControlManager;
    private transient IpAppMultiPartyCallImpl ipAppMultiPartyCallImpl;
    private transient IpAppMultiPartyCall ipAppMultiPartyCall = null;
    private final transient ActivityManager activityManager;
    private transient MpccsListener eventListener;
    private final transient TpServiceIdentifier serviceIdentifier;
    private final transient ActivityHandle activityHandle;
    private transient POA ipAppMultiPartyCallControlManagerPOA;
    private transient POA ipAppMultiPartyCallPOA;
    private transient POA ipAppCallLegPOA;
    private final transient Map multiPartyCallMap;
    private final transient Executor ipAppMultiPartyCallControlManagerExecutor;
    private final transient Executor[] ipAppMultiPartyCallExecutors;
    private final transient ThreadFactory threadFactory;
    private static final int NUM_EXECUTORS = 20;
    private static final int THREAD_POOL_SIZE = 20;

    public MultiPartyCallControlManagerImpl(TpServiceIdentifier serviceIdentifier, IpMultiPartyCallControlManager ipMultiPartyCallControlManager, FwSession fwSession, ActivityManager activityManager, MpccsListener eventListener) {
        this.ipMultiPartyCallControlManager = ipMultiPartyCallControlManager;
        this.fwSession = fwSession;
        this.activityManager = activityManager;
        this.eventListener = eventListener;
        this.serviceIdentifier = serviceIdentifier;
        this.activityHandle = new ParlayServiceActivityHandle(serviceIdentifier);
        this.multiPartyCallMap = new HashMap();
        this.threadFactory = new ThreadFactory(){
            ThreadGroup threadGroup = new ThreadGroup("MPCCS-ThreadGroup");
            final SynchronizedInt i = new SynchronizedInt(0);

            public Thread newThread(Runnable runnable) {
                return new Thread(this.threadGroup, runnable, "MPCCS-Thread-" + this.i.increment());
            }
        };
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Initialising threadpool with size 20");
        }
        this.ipAppMultiPartyCallControlManagerExecutor = new PooledExecutor(20);
        ((PooledExecutor)this.ipAppMultiPartyCallControlManagerExecutor).setThreadFactory(this.threadFactory);
        ((PooledExecutor)this.ipAppMultiPartyCallControlManagerExecutor).setKeepAliveTime(-1L);
        this.ipAppMultiPartyCallExecutors = new Executor[20];
        for (int i = 0; i < 20; ++i) {
            this.ipAppMultiPartyCallExecutors[i] = new QueuedExecutor();
            ((QueuedExecutor)this.ipAppMultiPartyCallExecutors[i]).setThreadFactory(this.threadFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ResourceException {
        Policy[] policies = PolicyFactory.createTransientPoaPolicies(this.fwSession.getRootPOA());
        MultiPartyCallControlManagerImpl multiPartyCallControlManagerImpl = this;
        synchronized (multiPartyCallControlManagerImpl) {
            this.createPOAs(policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activating servants.");
            }
            this.activateIpAppMultiPartyCall();
            this.activateIpAppMultiPartyCallControlManager();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Setting callback.");
                }
                this.ipMultiPartyCallControlManager.setCallback((IpInterface)this.ipAppMultiPartyCallControlManager);
            }
            catch (TpCommonExceptions e) {
                logger.error((java.lang.Object)"Failed to set manager callback.", (Throwable)e);
                throw new ResourceException("Failed to set manager callback.", (Throwable)e);
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)("Invalid interface exception on setCallback." + ParlayExceptionUtil.stringify(e)), (Throwable)e);
                throw new IllegalArgumentException("Invalid interface exception on setCallback.");
            }
            this.activityManager.add(this.activityHandle, this.serviceIdentifier);
            this.activityManager.activityStartedSuspended(this.activityHandle);
        }
    }

    protected void createPOAs(Policy[] policies) throws ResourceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Creating MPCCS POAs.");
            }
            this.ipAppMultiPartyCallControlManagerPOA = POAFactory.createPOA(this.fwSession.getRootPOA(), "ipAppMultiPartyCallControlManagerPOA_" + this.serviceIdentifier.getServiceID(), this.fwSession.getRootPOA().the_POAManager(), policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Created ipAppMultiPartyCallControlManagerPOA_" + this.serviceIdentifier.getServiceID()));
            }
            this.ipAppMultiPartyCallPOA = POAFactory.createPOA(this.fwSession.getRootPOA(), "ipAppMultiPartyCallPOA_" + this.serviceIdentifier.getServiceID(), this.fwSession.getRootPOA().the_POAManager(), policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Created ipAppMultiPartyCallPOA_" + this.serviceIdentifier.getServiceID()));
            }
            this.ipAppCallLegPOA = POAFactory.createPOA(this.fwSession.getRootPOA(), "ipAppCallLegPOA_" + this.serviceIdentifier.getServiceID(), this.fwSession.getRootPOA().the_POAManager(), policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Created ipAppCallLegPOA_" + this.serviceIdentifier.getServiceID()));
            }
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to initialise POAs.", (Throwable)e);
            throw new ResourceException("Failed to initialise POAs.", (Throwable)e);
        }
    }

    protected void activateIpAppMultiPartyCallControlManager() throws ResourceException {
        this.ipAppMultiPartyCallControlManagerImpl = new IpAppMultiPartyCallControlManagerImpl(this, this.ipAppMultiPartyCallControlManagerPOA, this.ipAppMultiPartyCallControlManagerExecutor);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activating servants.");
            }
            Object tmpRef = ServantActivationHelper.activateServant(this.ipAppMultiPartyCallControlManagerPOA, (Servant)this.ipAppMultiPartyCallControlManagerImpl);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activated ipAppMultiPartyCallControlManager.");
            }
            this.ipAppMultiPartyCallControlManager = IpAppMultiPartyCallControlManagerHelper.narrow((Object)tmpRef);
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to activate ipAppMultiPartyCallControlManager.", (Throwable)e);
            throw new ResourceException("Failed to activate ipAppMultiPartyCallControlManager.", (Throwable)e);
        }
    }

    protected void activateIpAppMultiPartyCall() throws ResourceException {
        this.ipAppMultiPartyCallImpl = new IpAppMultiPartyCallImpl(this, this.ipAppMultiPartyCallControlManagerPOA, this.ipAppMultiPartyCallExecutors);
        try {
            Object tmpRef = ServantActivationHelper.activateServant(this.ipAppMultiPartyCallPOA, (Servant)this.ipAppMultiPartyCallImpl);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activated ipAppMultiPartyCall.");
            }
            this.ipAppMultiPartyCall = IpAppMultiPartyCallHelper.narrow((Object)tmpRef);
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to activate ipAppMultiPartyCall.", (Throwable)e);
            throw new ResourceException("Failed to activate ipAppMultiPartyCall.", (Throwable)e);
        }
    }

    public int getType() {
        return 0;
    }

    public TpServiceIdentifier getTpServiceIdentifier() {
        return this.serviceIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        MultiPartyCallControlManagerImpl multiPartyCallControlManagerImpl = this;
        synchronized (multiPartyCallControlManagerImpl) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Disposing of MpccsSession");
            }
            this.ipMultiPartyCallControlManager = null;
            Collection calls = this.multiPartyCallMap.values();
            for (MultiPartyCall multiPartyCall : calls) {
                multiPartyCall.dispose();
            }
            this.multiPartyCallMap.clear();
            this.deactivateIpAppMultiPartyCall();
            this.deactivateIpAppMultiPartyCallControlManager();
            this.destroyPOAs();
            this.eventListener = null;
            this.fwSession = null;
        }
    }

    private void destroyPOAs() {
        if (this.ipAppCallLegPOA != null) {
            POAFactory.destroyPOA(this.ipAppCallLegPOA);
            this.ipAppCallLegPOA = null;
        }
        if (this.ipAppMultiPartyCallPOA != null) {
            POAFactory.destroyPOA(this.ipAppMultiPartyCallPOA);
            this.ipAppMultiPartyCallPOA = null;
        }
        if (this.ipAppMultiPartyCallControlManagerPOA != null) {
            POAFactory.destroyPOA(this.ipAppMultiPartyCallControlManagerPOA);
            this.ipAppMultiPartyCallControlManagerPOA = null;
        }
    }

    protected void deactivateIpAppMultiPartyCallControlManager() {
        if (this.ipAppMultiPartyCallControlManagerImpl != null) {
            try {
                ServantActivationHelper.deactivateServant((Servant)this.ipAppMultiPartyCallControlManagerImpl);
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to deactivate IpAppMultiPartyCallControlManager servant.", (Throwable)e);
            }
            this.ipAppMultiPartyCallControlManagerImpl.dispose();
            this.ipAppMultiPartyCallControlManager = null;
            this.ipAppMultiPartyCallControlManagerImpl = null;
        }
    }

    protected void deactivateIpAppMultiPartyCall() {
        if (this.ipAppMultiPartyCallImpl != null) {
            try {
                ServantActivationHelper.deactivateServant((Servant)this.ipAppMultiPartyCallImpl);
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to deactivate IpAppMultiPartyCall servant.", (Throwable)e);
            }
            this.ipAppMultiPartyCallImpl.dispose();
            this.ipAppMultiPartyCall = null;
            this.ipAppMultiPartyCallImpl = null;
        }
    }

    public IpAppMultiPartyCall getIpAppMultiPartyCall() {
        return this.ipAppMultiPartyCall;
    }

    public IpAppMultiPartyCallControlManager getIpAppMultiPartyCallControlManager() {
        return this.ipAppMultiPartyCallControlManager;
    }

    public IpAppMultiPartyCallControlManagerImpl getIpAppMultiPartyCallControlManagerImpl() {
        return this.ipAppMultiPartyCallControlManagerImpl;
    }

    public IpAppMultiPartyCallImpl getIpAppMultiPartyCallImpl() {
        return this.ipAppMultiPartyCallImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpMultiPartyCallControlManager getIpMultiPartyCallControlManager() {
        MultiPartyCallControlManagerImpl multiPartyCallControlManagerImpl = this;
        synchronized (multiPartyCallControlManagerImpl) {
            return this.ipMultiPartyCallControlManager;
        }
    }

    public POA getIpAppCallLegPOA() {
        return this.ipAppCallLegPOA;
    }

    public MultiPartyCall getMultiPartyCall(int callSessionID) {
        return (MultiPartyCall)this.multiPartyCallMap.get(new Integer(callSessionID));
    }

    public MultiPartyCall removeMultiPartyCall(int callSessionID) {
        return (MultiPartyCall)this.multiPartyCallMap.remove(new Integer(callSessionID));
    }

    public void addMultiPartyCall(int callSessionID, MultiPartyCall multiPartyCall) {
        this.multiPartyCallMap.put(new Integer(callSessionID), multiPartyCall);
    }

    public org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier createCall() throws TpCommonExceptions, ResourceException {
        org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier result = null;
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            try {
                TpMultiPartyCallIdentifier multiPartyCallIdentifier = multiPartyCallControlManager.createCall(this.getIpAppMultiPartyCall());
                MultiPartyCall call = this.createCall(multiPartyCallIdentifier);
                result = call.getTpMultiPartyCallIdentifier();
                this.activityManager.add(call.getActivityHandle(), call.getTpMultiPartyCallIdentifier());
                this.activityManager.activityStartedSuspended(call.getActivityHandle());
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                throw new ResourceException("Unexpected Parlay exception", (Throwable)e);
            }
        }
        return result;
    }

    public int createNotification(TpCallNotificationRequest arg1) throws TpCommonExceptions, P_INVALID_CRITERIA, P_INVALID_EVENT_TYPE, ResourceException {
        int result = 0;
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            try {
                result = multiPartyCallControlManager.createNotification(this.getIpAppMultiPartyCallControlManager(), arg1);
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                throw new ResourceException("Unexpected Parlay exception", (Throwable)e);
            }
        }
        return result;
    }

    public void destroyNotification(int arg0) throws TpCommonExceptions, P_INVALID_ASSIGNMENT_ID {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            multiPartyCallControlManager.destroyNotification(arg0);
        }
    }

    public void changeNotification(int arg0, TpCallNotificationRequest arg1) throws TpCommonExceptions, P_INVALID_ASSIGNMENT_ID, P_INVALID_CRITERIA, P_INVALID_EVENT_TYPE {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            multiPartyCallControlManager.changeNotification(arg0, arg1);
        }
    }

    public TpNotificationRequested[] getNotification() throws TpCommonExceptions {
        TpNotificationRequested[] result = null;
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            result = multiPartyCallControlManager.getNotification();
        }
        return result;
    }

    public int setCallLoadControl(int arg0, TpCallLoadControlMechanism arg1, TpCallTreatment arg2, TpAddressRange arg3) throws TpCommonExceptions, P_INVALID_ADDRESS, P_UNSUPPORTED_ADDRESS_PLAN {
        int result = 0;
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            result = multiPartyCallControlManager.setCallLoadControl(arg0, arg1, arg2, arg3);
        }
        return result;
    }

    public int enableNotifications() throws TpCommonExceptions {
        int result = 0;
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            result = multiPartyCallControlManager.enableNotifications(this.getIpAppMultiPartyCallControlManager());
        }
        return result;
    }

    public void disableNotifications() throws TpCommonExceptions {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            multiPartyCallControlManager.disableNotifications();
        }
    }

    public TpNotificationRequestedSetEntry getNextNotification(boolean arg0) throws TpCommonExceptions {
        TpNotificationRequestedSetEntry result = null;
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            result = multiPartyCallControlManager.getNextNotification(arg0);
        }
        return result;
    }

    public void reportNotification(org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier arg0, org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier[] arg1, TpCallNotificationInfo arg2, int arg3) {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            MultiPartyCall call = this.getMultiPartyCall(arg0.getCallSessionID());
            if (call != null) {
                this.activityManager.add(call.getActivityHandle(), call.getTpMultiPartyCallIdentifier());
                this.activityManager.activityStarted(call.getActivityHandle());
                for (int i = 0; i < arg1.length; ++i) {
                    CallLeg callLeg = call.getCallLeg(arg1[i].getCallLegSessionID());
                    if (callLeg == null) continue;
                    this.activityManager.add(callLeg.getActivityHandle(), callLeg.getTpCallLegIdentifier());
                    this.activityManager.activityStarted(callLeg.getActivityHandle());
                }
            }
            ReportNotificationEvent event = new ReportNotificationEvent(this.serviceIdentifier, arg0, arg1, arg2, arg3);
            this.eventListener.onReportNotificationEvent(event);
        }
    }

    public void callAborted(int arg0) {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            CallAbortedEvent event = null;
            MultiPartyCall call = this.getMultiPartyCall(arg0);
            if (call != null) {
                event = new CallAbortedEvent(this.serviceIdentifier, call.getTpMultiPartyCallIdentifier());
                this.eventListener.onCallAbortedEvent(event);
                this.activityManager.remove(call.getActivityHandle(), call.getTpMultiPartyCallIdentifier());
                this.activityManager.activityEnding(call.getActivityHandle());
                call.dispose();
            }
        }
    }

    public void managerInterrupted() {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            ManagerInterruptedEvent event = new ManagerInterruptedEvent(this.serviceIdentifier);
            this.eventListener.onManagerInterruptedEvent(event);
        }
    }

    public void managerResumed() {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            ManagerResumedEvent event = new ManagerResumedEvent(this.serviceIdentifier);
            this.eventListener.onManagerResumedEvent(event);
        }
    }

    public void callOverloadEncountered(int arg0) {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            CallOverloadEncounteredEvent event = new CallOverloadEncounteredEvent(this.serviceIdentifier, arg0);
            this.eventListener.onCallOverloadEncounteredEvent(event);
        }
    }

    public void callOverloadCeased(int arg0) {
        IpMultiPartyCallControlManager multiPartyCallControlManager = this.getIpMultiPartyCallControlManager();
        if (multiPartyCallControlManager != null) {
            CallOverloadCeasedEvent event = new CallOverloadCeasedEvent(this.serviceIdentifier, arg0);
            this.eventListener.onCallOverloadCeasedEvent(event);
        }
    }

    public MultiPartyCall createCall(TpMultiPartyCallIdentifier corbaCallIdentifier) {
        int callID = ResourceIDFactory.getNextID();
        org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier multiPartyCallIdentifier = new org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier(callID, corbaCallIdentifier.CallSessionID);
        MultiPartyCallImpl multiPartyCall = new MultiPartyCallImpl(this, multiPartyCallIdentifier, corbaCallIdentifier.CallReference, corbaCallIdentifier.CallSessionID, this.activityManager, this.eventListener, this.ipAppMultiPartyCallExecutors);
        multiPartyCall.init();
        this.addMultiPartyCall(corbaCallIdentifier.CallSessionID, multiPartyCall);
        return multiPartyCall;
    }

    public CallLeg createCallLeg(MultiPartyCall call, TpCallLegIdentifier identifier) {
        int callLegReferenceID = ResourceIDFactory.getNextID();
        org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier callLegIdentifier = new org.mobicents.csapi.jr.slee.cc.mpccs.TpCallLegIdentifier(callLegReferenceID, identifier.CallLegSessionID);
        CallLegImpl callLeg = new CallLegImpl(this, call, callLegIdentifier, identifier.CallLegReference, identifier.CallLegSessionID, this.activityManager, this.eventListener);
        callLeg.init();
        call.addCallLeg(identifier.CallLegSessionID, callLeg);
        return callLeg;
    }

    public IpMultiPartyCallConnection getIpMultiPartyCallConnection(org.mobicents.csapi.jr.slee.cc.mpccs.TpMultiPartyCallIdentifier multiPartyCallIdentifier) throws ResourceException {
        MultiPartyCall multiPartyCall = this.getMultiPartyCall(multiPartyCallIdentifier.getCallSessionID());
        if (multiPartyCall != null) {
            return new IpMultiPartyCallConnectionImpl(multiPartyCall);
        }
        throw new ResourceException("Unrecognized TpMultiPartyCallIdentifier");
    }

    public void closeConnection() throws ResourceException {
    }
}

