/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.jdbc;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.transaction.SleeTransactionManager;
import javax.sql.DataSource;
import org.mobicents.slee.resource.jdbc.JdbcActivityImpl;
import org.mobicents.slee.resource.jdbc.JdbcResourceAdaptorMarshaller;
import org.mobicents.slee.resource.jdbc.JdbcResourceAdaptorSbbInterfaceImpl;
import org.mobicents.slee.resource.jdbc.JdbcTaskContextImpl;
import org.mobicents.slee.resource.jdbc.event.JdbcTaskExecutionThrowableEvent;
import org.mobicents.slee.resource.jdbc.event.JdbcTaskExecutionThrowableEventImpl;
import org.mobicents.slee.resource.jdbc.task.JdbcTask;
import org.mobicents.slee.resource.jdbc.task.JdbcTaskContext;
import org.mobicents.slee.resource.jdbc.task.JdbcTaskResult;
import org.mobicents.slee.resource.jdbc.task.simple.SimpleJdbcTaskResultEvent;

public class JdbcResourceAdaptor
implements ResourceAdaptor {
    private ResourceAdaptorContext context;
    private static final String DATASOURCE_JNDI_NAME_CONFIG_PROPERTY = "DATASOURCE_JNDI_NAME";
    private String datasourceName;
    private static final String EXECUTOR_SERVICE_THREADS_CONFIG_PROPERTY = "EXECUTOR_SERVICE_THREADS";
    private int executorServiceThreads;
    private static final String RA_SBB_INTERFACE_CONNECTION_GETTERS_ON_CONFIG_PROPERTY = "RA_SBB_INTERFACE_CONNECTION_GETTERS_ON";
    private boolean raSbbInterfaceConnectionGettersOn;
    private JdbcResourceAdaptorSbbInterfaceImpl sbbInterface = new JdbcResourceAdaptorSbbInterfaceImpl(this);
    private JdbcResourceAdaptorMarshaller marshaller = new JdbcResourceAdaptorMarshaller(this);
    private Tracer tracer;
    private DataSource datasource;
    private ExecutorService executorService;
    private FireableEventType simpleJdbcTaskResultEventType;
    private FireableEventType jdbcTaskExecutionThrowableEventType;
    private SleeTransactionManager txManager;
    private EventLookupFacility eventLookupFacility;

    public ResourceAdaptorContext getContext() {
        return this.context;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public SleeTransactionManager getTxManager() {
        return this.txManager;
    }

    public void activityEnded(ActivityHandle activityHandle) {
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void administrativeRemove(ActivityHandle activityHandle) {
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, FireableEventType eventType, Object eventObject, Address address, ReceivableService service, int eventFlags, FailureReason reason) {
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, FireableEventType eventType, Object eventObject, Address address, ReceivableService service, int eventFlags) {
    }

    public void eventUnreferenced(ActivityHandle activityHandle, FireableEventType eventType, Object eventObject, Address address, ReceivableService service, int eventFlags) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return activityHandle;
    }

    public ActivityHandle getActivityHandle(Object activityObject) {
        if (activityObject instanceof JdbcActivityImpl) {
            JdbcActivityImpl jdbcActivity = (JdbcActivityImpl)activityObject;
            if (jdbcActivity.getRaEntityName().equals(this.getContext().getEntityName())) {
                return jdbcActivity;
            }
            return null;
        }
        return null;
    }

    public Marshaler getMarshaler() {
        return this.marshaller;
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.sbbInterface;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public void raActive() {
        try {
            this.datasource = (DataSource)InitialContext.doLookup(this.datasourceName);
        }
        catch (NamingException e) {
            this.tracer.severe("failed to retrieve the data source", (Throwable)e);
        }
        this.executorService = Executors.newFixedThreadPool(this.executorServiceThreads);
    }

    public void raConfigurationUpdate(ConfigProperties configuration) {
    }

    public void raConfigure(ConfigProperties configuration) {
        this.datasourceName = (String)configuration.getProperty(DATASOURCE_JNDI_NAME_CONFIG_PROPERTY).getValue();
        this.executorServiceThreads = (Integer)configuration.getProperty(EXECUTOR_SERVICE_THREADS_CONFIG_PROPERTY).getValue();
        this.raSbbInterfaceConnectionGettersOn = (Boolean)configuration.getProperty(RA_SBB_INTERFACE_CONNECTION_GETTERS_ON_CONFIG_PROPERTY).getValue();
        this.sbbInterface.setRaSbbInterfaceConnectionGettersOn(this.raSbbInterfaceConnectionGettersOn);
    }

    public void raInactive() {
        this.datasource = null;
        this.executorService = null;
    }

    public void raStopping() {
    }

    public void raUnconfigure() {
        this.datasourceName = null;
        this.executorServiceThreads = 0;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        String datasourceName = (String)properties.getProperty(DATASOURCE_JNDI_NAME_CONFIG_PROPERTY).getValue();
        try {
            InitialContext.doLookup(datasourceName);
        }
        catch (NamingException e) {
            throw new InvalidConfigurationException("bad datasource name", (Throwable)e);
        }
        Integer executorServiceThreads = (Integer)properties.getProperty(EXECUTOR_SERVICE_THREADS_CONFIG_PROPERTY).getValue();
        if (executorServiceThreads < 1) {
            throw new InvalidConfigurationException("executor service threads must be a positive integer");
        }
    }

    public void serviceActive(ReceivableService service) {
    }

    public void serviceInactive(ReceivableService service) {
    }

    public void serviceStopping(ReceivableService service) {
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.context = context;
        this.tracer = context.getTracer(this.getClass().getSimpleName());
        this.txManager = context.getSleeTransactionManager();
        this.eventLookupFacility = context.getEventLookupFacility();
        try {
            this.simpleJdbcTaskResultEventType = this.eventLookupFacility.getFireableEventType(SimpleJdbcTaskResultEvent.EVENT_TYPE_ID);
            this.jdbcTaskExecutionThrowableEventType = this.eventLookupFacility.getFireableEventType(JdbcTaskExecutionThrowableEvent.EVENT_TYPE_ID);
        }
        catch (Throwable e) {
            this.tracer.severe("Failed to retrieve fireable event types", e);
        }
    }

    public void unsetResourceAdaptorContext() {
        this.context = null;
        this.tracer = null;
        this.jdbcTaskExecutionThrowableEventType = null;
        this.simpleJdbcTaskResultEventType = null;
    }

    JdbcActivityImpl createActivity() {
        JdbcActivityImpl activity = new JdbcActivityImpl(this, UUID.randomUUID().toString());
        try {
            this.context.getSleeEndpoint().startActivitySuspended((ActivityHandle)activity, (Object)activity, 1);
        }
        catch (Exception e) {
            this.tracer.severe("failed to start activity " + activity.getId(), (Throwable)e);
        }
        return activity;
    }

    void endActivity(JdbcActivityImpl activity) {
        try {
            this.context.getSleeEndpoint().endActivityTransacted((ActivityHandle)activity);
        }
        catch (Exception e) {
            this.tracer.severe("failed to end activity", (Throwable)e);
        }
    }

    private void fireEvent(FireableEventType eventType, Object event, ActivityHandle activity, int eventFlags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("firing event: eventType = " + eventType + " , event = " + event + " , activity = " + activity + ", eventFlags = " + eventFlags);
        }
        try {
            this.context.getSleeEndpoint().fireEvent(activity, eventType, event, null, null, eventFlags);
        }
        catch (Throwable e) {
            this.tracer.severe("failed to fire event " + eventType + " in handle " + activity, e);
        }
    }

    public void execute(final JdbcTask jdbcTask, final JdbcActivityImpl activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("execute( task = " + jdbcTask + " , activity = " + activity + " )");
        }
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                JdbcTaskContextImpl context = new JdbcTaskContextImpl(JdbcResourceAdaptor.this);
                try {
                    JdbcTaskResult taskResult = jdbcTask.execute((JdbcTaskContext)context);
                    if (JdbcResourceAdaptor.this.txManager.getTransaction() != null) {
                        JdbcResourceAdaptor.this.txManager.commit();
                    }
                    if (taskResult == null) {
                        if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                            JdbcResourceAdaptor.this.tracer.fine("execution of task " + jdbcTask + " in activity " + activity + " returned null result.");
                        }
                        return;
                    }
                    FireableEventType eventType = null;
                    eventType = taskResult.getEventTypeID() == SimpleJdbcTaskResultEvent.EVENT_TYPE_ID ? JdbcResourceAdaptor.this.simpleJdbcTaskResultEventType : JdbcResourceAdaptor.this.eventLookupFacility.getFireableEventType(taskResult.getEventTypeID());
                    JdbcResourceAdaptor.this.fireEvent(eventType, taskResult.getEventObject(), activity, 0);
                }
                catch (Throwable e) {
                    if (JdbcResourceAdaptor.this.tracer.isFineEnabled()) {
                        JdbcResourceAdaptor.this.tracer.fine("failed to complete task execution", e);
                    }
                    JdbcTaskExecutionThrowableEventImpl event = new JdbcTaskExecutionThrowableEventImpl(e, jdbcTask);
                    JdbcResourceAdaptor.this.fireEvent(JdbcResourceAdaptor.this.jdbcTaskExecutionThrowableEventType, event, activity, 0);
                }
                finally {
                    block21: {
                        if (context.connection != null) {
                            try {
                                if (!context.connection.isClosed()) {
                                    context.connection.close();
                                }
                            }
                            catch (Exception e) {
                                if (!JdbcResourceAdaptor.this.tracer.isFineEnabled()) break block21;
                                JdbcResourceAdaptor.this.tracer.fine("failure in connection closing procedure", (Throwable)e);
                            }
                        }
                    }
                }
            }
        };
        this.executorService.submit(task);
    }
}

