/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.protocols.xcap.diff;

import org.mobicents.protocols.xcap.diff.component.AttributePatchComponentBuilder;
import org.mobicents.protocols.xcap.diff.component.DocumentPatchComponentBuilder;
import org.mobicents.protocols.xcap.diff.component.ElementPatchComponentBuilder;
import org.mobicents.protocols.xml.patch.XmlPatchOperationsBuilder;

/**
 * 
 * Builds XCAP DIFF Patches, and exposes the patch component builders, which are
 * used to build the patch components used in the final patch building.
 * 
 * @author baranowb
 * @author martins
 * 
 * @param <P>
 *            the patch type, defines what is the concrete type of finalized
 *            XCAP DIFF patch
 * @param <C>
 *            the component type, defines what is the concrete type of each
 *            patch component, to be aggregated in a XCAP DIFF patch
 * @param <D>
 *            the document type, defines what is the concrete type of XML
 *            documents used
 * @param <E>
 *            the element type, defines what is the concrete type of XML
 *            elements used
 * 
 * @param <N>
 *            the xml patch ops node type, defines what is the concrete type of
 *            XML patch ops node params used by
 *            {@link XmlPatchOperationsBuilder}
 */
public interface XcapDiffPatchBuilder<P, C, D, E, N> {

	/**
	 * Builds a XCAP DIFF patch, from the provided patch components, and the
	 * specified xcap root.
	 * 
	 * @param xcapRoot
	 *            the patch xcap root
	 * @param components
	 *            the patch components
	 * @return
	 * @throws BuildPatchException
	 *             if an exception occurred while building the patch, the
	 *             concrete exception is the exception's cause.
	 */
	public P buildPatch(String xcapRoot, C[] components)
			throws BuildPatchException;

	/**
	 * Retrieves the attribute patch component builder.
	 * 
	 * @return
	 */
	public AttributePatchComponentBuilder<C> getAttributePatchComponentBuilder();

	/**
	 * Retrieves the element patch component builder.
	 * 
	 * @return
	 */
	public ElementPatchComponentBuilder<C, E> getElementPatchComponentBuilder();

	/**
	 * Retrieves the document patch component builder.
	 * 
	 * @return
	 */
	public DocumentPatchComponentBuilder<C, D, E, N> getDocumentPatchComponentBuilder();

}
