/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.parameter;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.indicator.EncodingScheme;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0011
extends GlobalTitle {
    private static final GlobalTitleIndicator gti = GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME;
    private int tt;
    private NumberingPlan np;
    private EncodingScheme es;
    private String digits;
    protected static final XMLFormat<GT0011> XML = new XMLFormat<GT0011>(GT0011.class){

        public void write(GT0011 ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("tt", ai.tt);
            xml.setAttribute("es", ai.es.getValue());
            xml.setAttribute("np", ai.np.getValue());
            xml.setAttribute("digits", ai.digits);
        }

        public void read(XMLFormat.InputElement xml, GT0011 ai) throws XMLStreamException {
            ai.tt = xml.getAttribute("tt").toInt();
            ai.es = EncodingScheme.valueOf(xml.getAttribute("es").toInt());
            ai.np = NumberingPlan.valueOf(xml.getAttribute("np").toInt());
            ai.digits = xml.getAttribute("digits").toString();
        }
    };

    public GT0011() {
        this.digits = "";
    }

    public GT0011(int tt, NumberingPlan np, String digits) {
        this.tt = tt;
        this.np = np;
        this.digits = digits;
        this.es = digits.length() % 2 == 0 ? EncodingScheme.BCD_EVEN : EncodingScheme.BCD_ODD;
    }

    public int getTranslationType() {
        return this.tt;
    }

    public NumberingPlan getNp() {
        return this.np;
    }

    public String getDigits() {
        return this.digits;
    }

    public GlobalTitleIndicator getIndicator() {
        return gti;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GlobalTitle)) {
            return false;
        }
        GlobalTitle gt = (GlobalTitle)other;
        if (gt.getIndicator() != gti) {
            return false;
        }
        GT0011 gt1 = (GT0011)gt;
        return gt1.tt == this.tt && gt1.np == this.np && gt1.digits.equals(this.digits);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.tt;
        hash = 41 * hash + (this.np != null ? this.np.hashCode() : 0);
        hash = 41 * hash + (this.digits != null ? this.digits.hashCode() : 0);
        return hash;
    }
}

