/*
 * JBoss, Home of Professional Open Source
 * Copyright XXXX, Red Hat Middleware LLC, and individual contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a full listing
 * of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU General Public License, v. 2.0.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License,
 * v. 2.0 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */
package org.mobicents.protocols.ss7.sccp.parameter;

/**
 * Protocol class
 * 
 * The "protocol class" parameter field is a one-octet parameter and is structured as follows:
 * Bits 1-4 indicating protocol class are coded as follows:
 * 4321
 * 0000 class 0
 * 0001 class 1
 * 0010 class 2
 * 0011 class 3
 * 
 * @author baranowb
 * @author kulikov
 */
public interface ProtocolClass extends Parameter{
	
	public static final int PARAMETER_CODE = 0x05;
	
	public static final int HANDLING_RET_ERR = 0x08;
    /**
     * The value of protocol class.
     * 
     * @return protocol class code
     */
    public int getValue();
    
    /**
     * Gets the message handling value
     * 
     * @return message handling value.
     */
    public int getHandling();
}
