/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.parameter;

import org.mobicents.protocols.ss7.indicator.AddressIndicator;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class SccpAddress {
    private GlobalTitle gt;
    private int pc;
    private int ssn;
    private AddressIndicator ai;

    public SccpAddress(GlobalTitle gt, int ssn) {
        this.gt = gt;
        this.ssn = ssn;
        this.ai = new AddressIndicator(false, ssn != 0, RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, gt.getIndicator());
    }

    public SccpAddress(int pc, int ssn) {
        this.pc = pc;
        this.ssn = ssn;
        this.ai = new AddressIndicator(pc != 0, ssn != 0, RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, this.gt.getIndicator());
    }

    public AddressIndicator getAddressIndicator() {
        return this.ai;
    }

    public int getSignalingPointCode() {
        return this.pc;
    }

    public int getSubsystemNumber() {
        return this.ssn;
    }

    public GlobalTitle getGlobalTitle() {
        return this.gt;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SccpAddress)) {
            return false;
        }
        SccpAddress address = (SccpAddress)other;
        boolean res = false;
        if (address.gt != null) {
            boolean bl = res = this.gt != null && address.gt.equals(this.gt);
        }
        if (!res) {
            return false;
        }
        return address.ssn == this.ssn && address.pc == this.pc;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.gt != null ? this.gt.hashCode() : 0);
        hash = 37 * hash + this.pc;
        hash = 37 * hash + this.ssn;
        return hash;
    }

    public String toString() {
        return "pc=" + this.pc + ",ssn=" + this.ssn + ",gt=" + this.gt;
    }
}

