/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;

public class GT0001
extends GlobalTitle {
    private GlobalTitleIndicator gti = GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY;
    private NatureOfAddress nai;
    private String digits;
    private boolean odd = false;

    public GT0001() {
        this.digits = "";
    }

    public GT0001(NatureOfAddress nai, String digits) {
        this.nai = nai;
        this.digits = digits;
    }

    public void decode(InputStream in) throws IOException {
        int b = in.read() & 0xFF;
        this.nai = NatureOfAddress.valueOf(b & 0x7F);
        boolean bl = this.odd = (b & 0x80) == 128;
        while (in.available() > 0) {
            b = in.read() & 0xFF;
            this.digits = this.digits + Integer.toHexString(b & 0xF) + Integer.toHexString((b & 0xF0) >> 4);
        }
        if (this.odd) {
            this.digits = this.digits.substring(1, this.digits.length() - 1);
        }
    }

    public void encode(OutputStream out) throws IOException {
        this.odd = this.digits.length() % 2 != 0;
        int b = 0;
        if (this.odd) {
            b |= 0xFFFFFF80;
        }
        out.write((byte)(b |= (byte)this.nai.getValue()));
        int count = this.odd ? this.digits.length() - 1 : this.digits.length();
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = this.digits.substring(i, i + 1);
            String ds2 = this.digits.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            b = (byte)(d2 << 4 | d1);
            out.write(b);
        }
        if (this.odd) {
            String ds1 = this.digits.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            b = (byte)(d & 0xF);
            out.write(b);
        }
    }

    public NatureOfAddress getNoA() {
        return this.nai;
    }

    public String getDigits() {
        return this.digits;
    }

    public GlobalTitleIndicator getIndicator() {
        return this.gti;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GlobalTitle)) {
            return false;
        }
        GlobalTitle gt = (GlobalTitle)other;
        if (gt.getIndicator() != this.gti) {
            return false;
        }
        GT0001 gt1 = (GT0001)gt;
        return gt1.nai == this.nai && gt1.digits.equals(this.digits);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.gti != null ? this.gti.hashCode() : 0);
        hash = 53 * hash + (this.digits != null ? this.digits.hashCode() : 0);
        return hash;
    }
}

