/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.smstpdu;

import org.mobicents.protocols.ss7.map.api.smstpdu.ApplicationPortAddressing16BitAddress;

public class ApplicationPortAddressing16BitAddressImpl
implements ApplicationPortAddressing16BitAddress {
    private int destinationPort;
    private int originatorPort;

    public ApplicationPortAddressing16BitAddressImpl(int destinationPort, int originatorPort) {
        this.destinationPort = destinationPort;
        this.originatorPort = originatorPort;
    }

    public ApplicationPortAddressing16BitAddressImpl(byte[] encodedInformationElementData) {
        if (encodedInformationElementData == null || encodedInformationElementData.length != 4) {
            return;
        }
        this.destinationPort = ((encodedInformationElementData[0] & 0xFF) << 8) + (encodedInformationElementData[1] & 0xFF);
        this.originatorPort = ((encodedInformationElementData[2] & 0xFF) << 8) + (encodedInformationElementData[3] & 0xFF);
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public int getOriginatorPort() {
        return this.originatorPort;
    }

    public int getEncodedInformationElementIdentifier() {
        return 5;
    }

    public byte[] getEncodedInformationElementData() {
        byte[] res = new byte[]{(byte)((this.destinationPort & 0xFF00) >> 8), (byte)(this.destinationPort & 0xFF), (byte)((this.originatorPort & 0xFF00) >> 8), (byte)(this.originatorPort & 0xFF)};
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplicationPortAddressing16BitAddress [");
        sb.append("destinationPort=");
        sb.append(this.destinationPort);
        sb.append(", originatorPort=");
        sb.append(this.originatorPort);
        sb.append("]");
        return sb.toString();
    }
}

