/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.supplementary.CallBarringInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ForwardingInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSData;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.supplementary.CallBarringInfoImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ForwardingInfoImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSDataImpl;

public class SSInfoImpl
implements SSInfo,
MAPAsnPrimitive {
    public static final int _TAG_forwardingInfo = 0;
    public static final int _TAG_callBarringInfo = 1;
    public static final int _TAG_ssData = 3;
    public static final String _PrimitiveName = "SSInfo";
    private ForwardingInfo forwardingInfo;
    private CallBarringInfo callBarringInfo;
    private SSData ssData;

    public SSInfoImpl() {
    }

    public SSInfoImpl(ForwardingInfo forwardingInfo) {
        this.forwardingInfo = forwardingInfo;
    }

    public SSInfoImpl(CallBarringInfo callBarringInfo) {
        this.callBarringInfo = callBarringInfo;
    }

    public SSInfoImpl(SSData ssData) {
        this.ssData = ssData;
    }

    public ForwardingInfo getForwardingInfo() {
        return this.forwardingInfo;
    }

    public CallBarringInfo getCallBarringInfo() {
        return this.callBarringInfo;
    }

    public SSData getSsData() {
        return this.ssData;
    }

    public int getTag() throws MAPException {
        if (this.forwardingInfo != null) {
            return 0;
        }
        if (this.callBarringInfo != null) {
            return 1;
        }
        if (this.ssData != null) {
            return 3;
        }
        throw new MAPException("No of choices are supplied");
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SSInfo: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SSInfo: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SSInfo: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SSInfo: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.forwardingInfo = null;
        this.callBarringInfo = null;
        this.ssData = null;
        if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding SSInfo: bad tag class or is primitive: TagClass=" + ais.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 0: {
                this.forwardingInfo = new ForwardingInfoImpl();
                ((ForwardingInfoImpl)this.forwardingInfo).decodeData(ais, length);
                break;
            }
            case 1: {
                this.callBarringInfo = new CallBarringInfoImpl();
                ((CallBarringInfoImpl)this.callBarringInfo).decodeData(ais, length);
                break;
            }
            case 3: {
                this.ssData = new SSDataImpl();
                ((SSDataImpl)this.ssData).decodeData(ais, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while SSInfo: bad tag: " + ais.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SSInfo: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        int cnt = 0;
        if (this.forwardingInfo != null) {
            ++cnt;
        }
        if (this.callBarringInfo != null) {
            ++cnt;
        }
        if (this.ssData != null) {
            ++cnt;
        }
        if (cnt == 0) {
            throw new MAPException("Error while encoding SSInfo: no option is set.");
        }
        if (cnt > 1) {
            throw new MAPException("Error while encoding SSInfo: more than 1 option is set.");
        }
        if (this.forwardingInfo != null) {
            ((ForwardingInfoImpl)this.forwardingInfo).encodeData(asnOs);
        }
        if (this.callBarringInfo != null) {
            ((CallBarringInfoImpl)this.callBarringInfo).encodeData(asnOs);
        }
        if (this.ssData != null) {
            ((SSDataImpl)this.ssData).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.forwardingInfo != null) {
            sb.append("forwardingInfo=");
            sb.append(this.forwardingInfo.toString());
            sb.append(", ");
        }
        if (this.callBarringInfo != null) {
            sb.append("callBarringInfo=");
            sb.append(this.callBarringInfo.toString());
            sb.append(", ");
        }
        if (this.ssData != null) {
            sb.append("ssData=");
            sb.append(this.ssData.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

