/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SupplementaryCodeValue;
import org.mobicents.protocols.ss7.map.primitives.OctetStringLength1Base;

public class SSCodeImpl
extends OctetStringLength1Base
implements SSCode {
    private static final String SUPPLEMENTARY_CODE_VALUE = "supplementaryCodeValue";
    private static final String DATA = "data";
    protected static final XMLFormat<SSCodeImpl> SS_CODE = new XMLFormat<SSCodeImpl>(SSCodeImpl.class){

        public void read(XMLFormat.InputElement xml, SSCodeImpl ssCode) throws XMLStreamException {
            ssCode.data = (Integer)xml.get(SSCodeImpl.DATA, Integer.class);
            String str = (String)xml.get(SSCodeImpl.SUPPLEMENTARY_CODE_VALUE, String.class);
        }

        public void write(SSCodeImpl ssCode, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.add((Object)ssCode.getData(), SSCodeImpl.DATA, Integer.class);
            if (ssCode.getSupplementaryCodeValue() != null) {
                xml.add((Object)ssCode.getSupplementaryCodeValue().toString(), SSCodeImpl.SUPPLEMENTARY_CODE_VALUE, String.class);
            }
        }
    };

    public SSCodeImpl() {
        super("SSCode");
    }

    public SSCodeImpl(int data) {
        super("SSCode", data);
    }

    public SSCodeImpl(SupplementaryCodeValue value) {
        super("SSCode", value != null ? value.getCode() : 0);
    }

    public int getData() {
        return this.data;
    }

    public SupplementaryCodeValue getSupplementaryCodeValue() {
        return SupplementaryCodeValue.getInstance((int)this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        SupplementaryCodeValue scv = this.getSupplementaryCodeValue();
        if (scv != null) {
            sb.append("SupplementaryCodeValue=" + scv);
            sb.append(", ");
        }
        sb.append("Data=" + this.data);
        sb.append("]");
        return sb.toString();
    }
}

