/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.supplementary.DeactivateSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSForBSCode;
import org.mobicents.protocols.ss7.map.service.supplementary.SSForBSCodeImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SupplementaryMessageImpl;

public class DeactivateSSRequestImpl
extends SupplementaryMessageImpl
implements DeactivateSSRequest {
    public static final String _PrimitiveName = "DeactivateSSRequest";
    private SSForBSCode ssForBSCode;

    public DeactivateSSRequestImpl() {
    }

    public DeactivateSSRequestImpl(SSForBSCode ssForBSCode) {
        this.ssForBSCode = ssForBSCode;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.deactivateSS_Request;
    }

    public int getOperationCode() {
        return 13;
    }

    public SSForBSCode getSsForBSCode() {
        return this.ssForBSCode;
    }

    public int getTag() throws MAPException {
        if (this.ssForBSCode != null) {
            return ((SSForBSCodeImpl)this.ssForBSCode).getTag();
        }
        throw new MAPException("ssForBSCode is not defined");
    }

    public int getTagClass() {
        if (this.ssForBSCode != null) {
            return ((SSForBSCodeImpl)this.ssForBSCode).getTagClass();
        }
        return 0;
    }

    public boolean getIsPrimitive() {
        if (this.ssForBSCode != null) {
            return ((SSForBSCodeImpl)this.ssForBSCode).getIsPrimitive();
        }
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding DeactivateSSRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding DeactivateSSRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding DeactivateSSRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding DeactivateSSRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssForBSCode = null;
        this.ssForBSCode = new SSForBSCodeImpl();
        ((SSForBSCodeImpl)this.ssForBSCode).decodeData(ais, length);
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding DeactivateSSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ssForBSCode == null) {
            throw new MAPException("Error while encoding DeactivateSSRequest: ssForBSCode parameter is not defined.");
        }
        if (this.ssForBSCode != null) {
            ((SSForBSCodeImpl)this.ssForBSCode).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.ssForBSCode != null) {
            sb.append("ssForBSCode=");
            sb.append(this.ssForBSCode);
        }
        sb.append("]");
        return sb.toString();
    }
}

