/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.sms.SM_RP_OA;
import org.mobicents.protocols.ss7.map.primitives.AddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SM_RP_OAImpl
implements SM_RP_OA,
MAPAsnPrimitive {
    private static final int _TAG_Msisdn = 2;
    private static final int _TAG_ServiceCentreAddressOA = 4;
    private static final int _TAG_noSM_RP_OA = 5;
    public static final String _PrimitiveName = "SM_RP_OA";
    private ISDNAddressString msisdn;
    private AddressString serviceCentreAddressOA;

    public void setMsisdn(ISDNAddressString msisdn) {
        this.msisdn = msisdn;
    }

    public void setServiceCentreAddressOA(AddressString serviceCentreAddressOA) {
        this.serviceCentreAddressOA = serviceCentreAddressOA;
    }

    public ISDNAddressString getMsisdn() {
        return this.msisdn;
    }

    public AddressString getServiceCentreAddressOA() {
        return this.serviceCentreAddressOA;
    }

    public int getTagClass() {
        return 2;
    }

    public int getTag() {
        if (this.msisdn != null) {
            return 2;
        }
        if (this.serviceCentreAddressOA != null) {
            return 4;
        }
        return 5;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_OA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_OA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SM_RP_OA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SM_RP_OA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.msisdn = null;
        this.serviceCentreAddressOA = null;
        if (ansIS.getTagClass() != 2 || !ansIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding SM_RP_OA: bad tag class or is not primitive: TagClass=" + ansIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ansIS.getTag()) {
            case 2: {
                this.msisdn = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.msisdn).decodeData(ansIS, length);
                break;
            }
            case 4: {
                this.serviceCentreAddressOA = new AddressStringImpl();
                ((AddressStringImpl)this.serviceCentreAddressOA).decodeData(ansIS, length);
                break;
            }
            case 5: {
                try {
                    ansIS.readNullData(length);
                    break;
                }
                catch (AsnException e) {
                    throw new MAPParsingComponentException("AsnException when decoding SM_RP_OA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                catch (IOException e) {
                    throw new MAPParsingComponentException("IOException when decoding SM_RP_OA: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
                }
            }
            default: {
                throw new MAPParsingComponentException("Error while SM_RP_OA: bad tag: " + ansIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 2, this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SM_RP_OA: " + e.getMessage(), (Throwable)e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.msisdn != null) {
            ((ISDNAddressStringImpl)this.msisdn).encodeData(asnOs);
        } else if (this.serviceCentreAddressOA != null) {
            ((AddressStringImpl)this.serviceCentreAddressOA).encodeData(asnOs);
        } else {
            asnOs.writeNullData();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.msisdn != null) {
            sb.append("msisdn=");
            sb.append(this.msisdn.toString());
        }
        if (this.serviceCentreAddressOA != null) {
            sb.append("serviceCentreAddressOA=");
            sb.append(this.serviceCentreAddressOA.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

