/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.oam;

import org.mobicents.protocols.ss7.map.api.service.oam.BssRecordType;
import org.mobicents.protocols.ss7.map.api.service.oam.HlrRecordType;
import org.mobicents.protocols.ss7.map.api.service.oam.MscRecordType;
import org.mobicents.protocols.ss7.map.api.service.oam.TraceType;
import org.mobicents.protocols.ss7.map.api.service.oam.TraceTypeInvokingEvent;
import org.mobicents.protocols.ss7.map.primitives.OctetStringLength1Base;

public class TraceTypeImpl
extends OctetStringLength1Base
implements TraceType {
    public TraceTypeImpl() {
        super("TraceType");
    }

    public TraceTypeImpl(int data) {
        super("TraceType", data);
    }

    public TraceTypeImpl(BssRecordType bssRecordType, MscRecordType mscRecordType, TraceTypeInvokingEvent traceTypeInvokingEvent, boolean priorityIndication) {
        super("TraceType");
        int mscRecordTypeInt = 3;
        if (mscRecordType != null) {
            mscRecordTypeInt = mscRecordType.getCode();
        }
        int bssRecordTypeInt = 3;
        if (bssRecordType != null) {
            bssRecordTypeInt = bssRecordType.getCode();
        }
        int traceTypeInvokingEventInt = 0;
        if (traceTypeInvokingEvent != null) {
            traceTypeInvokingEventInt = traceTypeInvokingEvent.getCode();
        }
        this.data = bssRecordTypeInt << 4 | mscRecordTypeInt << 2 | traceTypeInvokingEventInt | (priorityIndication ? 128 : 0);
    }

    public TraceTypeImpl(HlrRecordType hlrRecordType, TraceTypeInvokingEvent traceTypeInvokingEvent, boolean priorityIndication) {
        super("TraceType");
        int hlrRecordTypeInt = 3;
        if (hlrRecordType != null) {
            hlrRecordTypeInt = hlrRecordType.getCode();
        }
        int traceTypeInvokingEventInt = 0;
        if (traceTypeInvokingEvent != null) {
            traceTypeInvokingEventInt = traceTypeInvokingEvent.getCode();
        }
        this.data = hlrRecordTypeInt << 2 | traceTypeInvokingEventInt | (priorityIndication ? 128 : 0);
    }

    public int getData() {
        return this.data;
    }

    public boolean isPriorityIndication() {
        return (this.data & 0x80) != 0;
    }

    public BssRecordType getBssRecordType() {
        int code = this.data >> 4 & 3;
        return BssRecordType.getInstance((int)code);
    }

    public MscRecordType getMscRecordType() {
        int code = this.data >> 2 & 3;
        return MscRecordType.getInstance((int)code);
    }

    public HlrRecordType getHlrRecordType() {
        int code = this.data >> 2 & 3;
        return HlrRecordType.getInstance((int)code);
    }

    public TraceTypeInvokingEvent getTraceTypeInvokingEvent() {
        int code = this.data & 3;
        return TraceTypeInvokingEvent.getInstance((int)code);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("bssRecordType=");
        sb.append(this.getBssRecordType());
        sb.append(", ");
        sb.append("mscRecordType=");
        sb.append(this.getMscRecordType());
        sb.append(", ");
        sb.append("hlrRecordType=");
        sb.append(this.getHlrRecordType());
        sb.append(", ");
        sb.append("traceTypeInvokingEvent=");
        sb.append(this.getTraceTypeInvokingEvent());
        sb.append(", ");
        if (this.isPriorityIndication()) {
            sb.append("priorityIndication, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

