/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.SSCamelData;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSCamelDataImpl
extends SequenceBase
implements SSCamelData {
    private static final int _TAG_extensionContainer = 0;
    private ArrayList<SSCode> ssEventList;
    private ISDNAddressString gsmSCFAddress;
    private MAPExtensionContainer extensionContainer;

    public SSCamelDataImpl() {
        super("SSCamelData");
    }

    public SSCamelDataImpl(ArrayList<SSCode> ssEventList, ISDNAddressString gsmSCFAddress, MAPExtensionContainer extensionContainer) {
        super("SSCamelData");
        this.ssEventList = ssEventList;
        this.gsmSCFAddress = gsmSCFAddress;
        this.extensionContainer = extensionContainer;
    }

    public ArrayList<SSCode> getSsEventList() {
        return this.ssEventList;
    }

    public ISDNAddressString getGsmSCFAddress() {
        return this.gsmSCFAddress;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        SSCodeImpl sSCode = null;
        this.ssEventList = null;
        this.gsmSCFAddress = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block11: while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            break block0;
                        }
                    }
                    ais.advanceElement();
                    break;
                }
                case 0: {
                    switch (tag) {
                        case 16: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssEventList: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.ssEventList = new ArrayList();
                            while (ais2.available() != 0) {
                                int tag2 = ais2.readTag();
                                if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is not primitive when decoding ssEventList", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                sSCode = new SSCodeImpl();
                                sSCode.decodeAll(ais2);
                                this.ssEventList.add(sSCode);
                            }
                            if (this.ssEventList.size() >= 1 || this.ssEventList.size() <= 10) continue block11;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter ssEventList size must be from 1 to 10, found: " + this.ssEventList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 4: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".gsmSCFAddress: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.gsmSCFAddress = new ISDNAddressStringImpl();
                            ((ISDNAddressStringImpl)this.gsmSCFAddress).decodeAll(ais);
                            break;
                        }
                        default: {
                            ais.advanceElement();
                            break;
                        }
                    }
                    continue block11;
                }
                default: {
                    ais.advanceElement();
                }
            }
        }
        if (this.ssEventList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": ssEventList required.", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": gsmSCFAddress required.", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ssEventList == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": ssEventList required.");
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": gsmSCFAddress required.");
        }
        if (this.ssEventList != null && (this.ssEventList.size() < 1 || this.ssEventList.size() > 10)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter ssEventList size must be from 1 to 10, found: " + this.ssEventList.size());
        }
        try {
            asnOs.writeTag(0, false, 16);
            int pos = asnOs.StartContentDefiniteLength();
            for (SSCode sSCode : this.ssEventList) {
                ((SSCodeImpl)sSCode).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            ((ISDNAddressStringImpl)this.gsmSCFAddress).encodeAll(asnOs);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 0);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.ssEventList != null) {
            sb.append("ssEventList=[");
            boolean firstItem = true;
            for (SSCode be : this.ssEventList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.gsmSCFAddress != null) {
            sb.append("gsmSCFAddress=");
            sb.append(this.gsmSCFAddress.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

